/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.player.ClientInputEvents;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundCastErrorMessage {
    private final ErrorType errorType;
    private final String spellId;

    public ClientboundCastErrorMessage(ErrorType errorType, AbstractSpell spell) {
        this.spellId = spell.getSpellId();
        this.errorType = errorType;
    }

    public ClientboundCastErrorMessage(FriendlyByteBuf buf) {
        this.errorType = (ErrorType)buf.m_130066_(ErrorType.class);
        this.spellId = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.errorType);
        buf.m_130070_(this.spellId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            AbstractSpell spell = SpellRegistry.getSpell(this.spellId);
            if (this.errorType == ErrorType.COOLDOWN) {
                if (ClientInputEvents.hasReleasedSinceCasting) {
                    Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237110_((String)"ui.irons_spellbooks.cast_error_cooldown", (Object[])new Object[]{spell.getDisplayName()}).m_130940_(ChatFormatting.RED), false);
                }
            } else {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237110_((String)"ui.irons_spellbooks.cast_error_mana", (Object[])new Object[]{spell.getDisplayName()}).m_130940_(ChatFormatting.RED), false);
            }
        });
        return true;
    }

    public static enum ErrorType {
        COOLDOWN,
        MANA;

    }
}

