/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;

public class SpellFilter {
    SchoolType schoolType = null;
    List<AbstractSpell> spells = new ArrayList<AbstractSpell>();

    public SpellFilter(SchoolType schoolType) {
        this.schoolType = schoolType;
    }

    public SpellFilter(List<AbstractSpell> spells) {
        this.spells = spells;
    }

    public SpellFilter() {
    }

    public boolean isFiltered() {
        return this.schoolType != null || this.spells.size() > 0;
    }

    public List<AbstractSpell> getApplicableSpells() {
        if (this.spells.size() > 0) {
            return this.spells;
        }
        if (this.schoolType != null) {
            return SpellRegistry.getSpellsForSchool(this.schoolType);
        }
        return SpellRegistry.REGISTRY.get().getValues().stream().toList();
    }

    public AbstractSpell getRandomSpell(RandomSource random, Predicate<AbstractSpell> filter) {
        List<AbstractSpell> spells = this.getApplicableSpells().stream().filter(filter).toList();
        return spells.get(random.m_188503_(spells.size()));
    }

    public static SpellFilter deserializeSpellFilter(JsonObject json) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)"school")) {
            String schoolType = GsonHelper.m_13906_((JsonObject)json, (String)"school");
            return new SpellFilter(SchoolRegistry.getSchool(new ResourceLocation(schoolType)));
        }
        if (GsonHelper.m_13885_((JsonObject)json, (String)"spells")) {
            JsonArray spellsFromJson = GsonHelper.m_13933_((JsonObject)json, (String)"spells");
            ArrayList<AbstractSpell> applicableSpellList = new ArrayList<AbstractSpell>();
            for (JsonElement element : spellsFromJson) {
                String spellId = element.getAsString();
                AbstractSpell spell = SpellRegistry.getSpell(spellId);
                if (spell == SpellRegistry.none()) continue;
                applicableSpellList.add(spell);
            }
            return new SpellFilter(applicableSpellList);
        }
        return new SpellFilter();
    }
}

