/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item;

import io.redspace.ironsspellbooks.api.item.IScroll;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scroll
extends Item
implements IScroll {
    public Scroll() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    protected void removeScrollAfterCast(ServerPlayer serverPlayer, ItemStack stack) {
        if (!serverPlayer.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public static boolean attemptRemoveScrollAfterCast(ServerPlayer serverPlayer) {
        ItemStack potentialScroll = MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerCastingItem();
        Item item = potentialScroll.m_41720_();
        if (item instanceof Scroll) {
            Scroll scroll = (Scroll)item;
            scroll.removeScrollAfterCast(serverPlayer, potentialScroll);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (ClientMagicData.isCasting()) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        SpellData spellData = SpellData.getSpellData(stack);
        AbstractSpell spell = spellData.getSpell();
        if (spell.attemptInitiateCast(stack, spellData.getLevel(), level, player, CastSource.SCROLL, false)) {
            if (spell.getCastType() == CastType.INSTANT) {
                this.removeScrollAfterCast((ServerPlayer)player, stack);
            }
            if (spell.getCastType().holdToCast()) {
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return 7200;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, LivingEntity entity, int ticksUsed) {
        if (SpellData.getSpellData(itemStack).getSpell().getCastType() != CastType.CONTINUOUS || this.m_8105_(itemStack) - ticksUsed >= 4) {
            Utils.releaseUsingHelper(entity, itemStack, ticksUsed);
        }
        super.m_5551_(itemStack, level, entity, ticksUsed);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        SpellData scrollData = SpellData.getSpellData(itemStack);
        return scrollData.getDisplayName();
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> lines, @NotNull TooltipFlag flag) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            lines.addAll(TooltipsUtils.formatScrollTooltip(itemStack, player));
        }
        super.m_7373_(itemStack, level, lines, flag);
    }
}

