/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays.network;

import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.item.SpellBook;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSetSpellBookActiveIndex {
    private final int selectedIndex;

    public ServerboundSetSpellBookActiveIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public ServerboundSetSpellBookActiveIndex(FriendlyByteBuf buf) {
        this.selectedIndex = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.selectedIndex);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            if (serverPlayer != null) {
                ItemStack mainHandStack = serverPlayer.m_21205_();
                ItemStack offHandStack = serverPlayer.m_21206_();
                if (mainHandStack.m_41720_() instanceof SpellBook) {
                    SpellBookData.getSpellBookData(mainHandStack).setActiveSpellIndex(this.selectedIndex, mainHandStack);
                } else if (offHandStack.m_41720_() instanceof SpellBook) {
                    SpellBookData.getSpellBookData(offHandStack).setActiveSpellIndex(this.selectedIndex, offHandStack);
                }
            }
        });
        return true;
    }
}

