/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.ice_block;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceBlockProjectile
extends AbstractMagicProjectile
implements GeoEntity {
    private UUID targetUUID;
    private Entity cachedTarget;
    private List<Entity> victims;
    int airTime;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public IceBlockProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.victims = new ArrayList<Entity>();
    }

    public IceBlockProjectile(Level pLevel, LivingEntity owner, LivingEntity target) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.ICE_BLOCK_PROJECTILE.get()), pLevel);
        this.m_5602_((Entity)owner);
        this.setTarget((Entity)target);
    }

    public void setAirTime(int airTimeInTicks) {
        this.airTime = airTimeInTicks;
    }

    public void setTarget(@Nullable Entity pOwner) {
        if (pOwner != null) {
            this.targetUUID = pOwner.m_20148_();
            this.cachedTarget = pOwner;
        }
    }

    @Nullable
    public Entity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.f_19853_ instanceof ServerLevel) {
            this.cachedTarget = ((ServerLevel)this.f_19853_).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.targetUUID != null) {
            pCompound.m_128362_("Target", this.targetUUID);
        }
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("Target")) {
            this.targetUUID = pCompound.m_128342_("Target");
        }
    }

    @Override
    public void trailParticles() {
        for (int i = 0; i < 1; ++i) {
            Vec3 random = new Vec3(Utils.getRandomScaled(this.m_20205_() * 0.5f), 0.0, Utils.getRandomScaled(this.m_20205_() * 0.5f));
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + random.f_82479_, this.m_20186_(), this.m_20189_() + random.f_82481_, 0.0, -0.05, 0.0);
        }
    }

    private void doFallingDamage(Entity target) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (!this.m_5603_(target) || this.victims.contains(target)) {
            return;
        }
        boolean flag = DamageSources.applyDamage(target, this.getDamage() / 2.0f, ((AbstractSpell)SpellRegistry.ICE_BLOCK_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()), ((AbstractSpell)SpellRegistry.ICE_BLOCK_SPELL.get()).getSchoolType());
        if (flag) {
            if (target.m_142079_()) {
                target.m_146917_(200);
            }
            this.victims.add(target);
            target.f_19802_ = 0;
        }
    }

    private void doImpactDamage() {
        float explosionRadius = 3.5f;
        this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius)).forEach(entity -> {
            double p;
            float damage;
            double distance;
            if (this.m_5603_((Entity)entity) && (distance = entity.m_20238_(this.m_20182_())) < (double)(explosionRadius * explosionRadius) && DamageSources.applyDamage(entity, damage = (float)((double)this.damage * (p = 1.0 - Math.pow(Math.sqrt(distance) / (double)explosionRadius, 3.0))), ((AbstractSpell)SpellRegistry.ICE_BLOCK_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()), ((AbstractSpell)SpellRegistry.ICE_BLOCK_SPELL.get()).getSchoolType()) && entity.m_142079_()) {
                entity.m_146917_(200);
            }
        });
    }

    @Override
    public void m_8119_() {
        this.m_6075_();
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        if (!this.f_19853_.f_46443_) {
            if (this.airTime <= 0) {
                if (this.m_20096_()) {
                    this.doImpactDamage();
                    this.m_5496_((SoundEvent)SoundRegistry.ICE_BLOCK_IMPACT.get(), 2.5f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    this.impactParticles(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_146870_();
                } else {
                    this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(0.35)).forEach(this::doFallingDamage);
                }
            }
            if (this.airTime-- > 0) {
                boolean tooHigh = false;
                this.m_20256_(this.m_20184_().m_82542_((double)0.95f, 0.75, (double)0.95f));
                if (this.getTarget() != null) {
                    Entity target = this.getTarget();
                    Vec3 diff = target.m_20182_().m_82546_(this.m_20182_());
                    if (diff.m_165925_() > 1.0) {
                        this.m_20256_(this.m_20184_().m_82549_(diff.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)0.02f)));
                    }
                    if (this.m_20186_() - target.m_20186_() > 3.5) {
                        tooHigh = true;
                    }
                } else if (this.airTime % 3 == 0) {
                    BlockHitResult ground = Utils.raycastForBlock(this.f_19853_, this.m_20182_(), this.m_20182_().m_82492_(0.0, 3.5, 0.0), ClipContext.Fluid.ANY);
                    if (ground.m_6662_() == HitResult.Type.MISS) {
                        tooHigh = true;
                    } else if (Math.abs(this.m_20182_().f_82480_ - ground.m_82450_().f_82480_) < 4.0) {
                        // empty if block
                    }
                }
                if (tooHigh) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                } else {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
                }
                if (this.airTime == 0) {
                    this.m_20334_(0.0, 0.5, 0.0);
                }
            } else {
                this.m_20334_(0.0, this.m_20184_().f_82480_ - 0.15, 0.0);
            }
        } else {
            this.trailParticles();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_146926_(float pXRot) {
    }

    public void m_146922_(float pYRot) {
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean m_5603_(Entity pTarget) {
        return pTarget != this.m_19749_() && super.m_5603_(pTarget);
    }

    @Override
    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_175821_, x, y, z, 50, 0.8, 0.1, 0.8, 0.2, false);
        MagicManager.spawnParticles(this.f_19853_, ParticleHelper.SNOWFLAKE, x, y, z, 25, 0.5, 0.1, 0.5, 0.3, false);
    }

    @Override
    public float getSpeed() {
        return 0.0f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

