/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.goals;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;

public class WarlockAttackGoal
extends WizardAttackGoal {
    protected float meleeRange;
    protected boolean wantsToMelee;
    protected int meleeTime;
    protected int meleeTimeDelay;
    protected float meleeBias;

    public WarlockAttackGoal(AbstractSpellCastingMob abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval, float meleeRange) {
        super(abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval);
        this.meleeRange = meleeRange;
        this.meleeTimeDelay = abstractSpellCastingMob.m_217043_().m_216332_(80, 200);
        this.meleeBias = 0.5f;
        this.shouldFlee = false;
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (++this.meleeTime > this.meleeTimeDelay) {
            this.meleeTime = 0;
            this.wantsToMelee = this.mob.m_217043_().m_188501_() <= this.meleeBias;
            this.meleeTimeDelay = this.mob.m_217043_().m_216332_(60, 120);
        }
    }

    @Override
    protected void doMovement(double distanceSquared) {
        if (!this.wantsToMelee) {
            super.doMovement(distanceSquared);
            return;
        }
        if (this.target.m_21224_()) {
            this.mob.m_21573_().m_26573_();
        } else {
            float strafeBackwards = 0.0f;
            if (distanceSquared > (double)(this.meleeRange * this.meleeRange)) {
                if (this.isFlying) {
                    this.mob.m_21566_().m_6849_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), this.speedModifier * (double)1.3f);
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier * (double)1.3f);
                }
                strafeBackwards = 0.0f;
            } else {
                strafeBackwards = (float)(-this.speedModifier * 0.25);
            }
            if (++this.strafeTime > 25 && this.mob.m_217043_().m_188500_() < 0.1) {
                this.strafingClockwise = !this.strafingClockwise;
                this.strafeTime = 0;
            }
            float strafeDir = this.strafingClockwise ? 1.0f : -1.0f;
            this.mob.m_21566_().m_24988_(strafeBackwards, (float)this.speedModifier * strafeDir);
        }
    }

    @Override
    protected void handleAttackLogic(double distanceSquared) {
        if (!this.wantsToMelee || distanceSquared > (double)(this.meleeRange * this.meleeRange) || this.mob.isCasting()) {
            super.handleAttackLogic(distanceSquared);
        } else if (--this.attackTime == 0) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.doMeleeAction();
        }
    }

    protected void doMeleeAction() {
        double distanceSquared = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.mob.m_7327_((Entity)this.target);
        this.resetAttackTimer(distanceSquared);
    }

    public WarlockAttackGoal setMeleeBias(float meleeBias) {
        this.meleeBias = meleeBias;
        return this;
    }

    @Override
    public WarlockAttackGoal setSpells(List<AbstractSpell> attackSpells, List<AbstractSpell> defenseSpells, List<AbstractSpell> movementSpells, List<AbstractSpell> supportSpells) {
        return (WarlockAttackGoal)super.setSpells(attackSpells, defenseSpells, movementSpells, supportSpells);
    }

    @Override
    public WarlockAttackGoal setSpellQuality(float minSpellQuality, float maxSpellQuality) {
        return (WarlockAttackGoal)super.setSpellQuality(minSpellQuality, maxSpellQuality);
    }

    @Override
    public WarlockAttackGoal setSingleUseSpell(AbstractSpell spellType, int minDelay, int maxDelay, int minLevel, int maxLevel) {
        return (WarlockAttackGoal)super.setSingleUseSpell(spellType, minDelay, maxDelay, minLevel, maxLevel);
    }

    @Override
    public WarlockAttackGoal setIsFlying() {
        return (WarlockAttackGoal)super.setIsFlying();
    }
}

