/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobRenderer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class HumanoidRenderer<T extends Mob>
extends GeoEntityRenderer<T> {
    private static final String LEFT_HAND = "bipedHandLeft";
    private static final String RIGHT_HAND = "bipedHandRight";
    private static final String LEFT_BOOT = "armorBipedLeftFoot";
    private static final String RIGHT_BOOT = "armorBipedRightFoot";
    private static final String LEFT_BOOT_2 = "armorBipedLeftFoot2";
    private static final String RIGHT_BOOT_2 = "armorBipedRightFoot2";
    private static final String LEFT_ARMOR_LEG = "armorBipedLeftLeg";
    private static final String RIGHT_ARMOR_LEG = "armorBipedRightLeg";
    private static final String LEFT_ARMOR_LEG_2 = "armorBipedLeftLeg2";
    private static final String RIGHT_ARMOR_LEG_2 = "armorBipedRightLeg2";
    private static final String CHESTPLATE = "armorBipedBody";
    private static final String RIGHT_SLEEVE = "armorBipedRightArm";
    private static final String LEFT_SLEEVE = "armorBipedLeftArm";
    private static final String HELMET = "armorBipedHead";

    public HumanoidRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model) {
        super(renderManager, model);
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<T>((GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_BOOT, HumanoidRenderer.RIGHT_BOOT, HumanoidRenderer.LEFT_BOOT_2, HumanoidRenderer.RIGHT_BOOT_2 -> this.bootsStack;
                    case HumanoidRenderer.LEFT_ARMOR_LEG, HumanoidRenderer.RIGHT_ARMOR_LEG, HumanoidRenderer.LEFT_ARMOR_LEG_2, HumanoidRenderer.RIGHT_ARMOR_LEG_2 -> this.leggingsStack;
                    case HumanoidRenderer.CHESTPLATE, HumanoidRenderer.RIGHT_SLEEVE, HumanoidRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case HumanoidRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_BOOT, HumanoidRenderer.RIGHT_BOOT, HumanoidRenderer.LEFT_BOOT_2, HumanoidRenderer.RIGHT_BOOT_2 -> EquipmentSlot.FEET;
                    case HumanoidRenderer.LEFT_ARMOR_LEG, HumanoidRenderer.RIGHT_ARMOR_LEG, HumanoidRenderer.LEFT_ARMOR_LEG_2, HumanoidRenderer.RIGHT_ARMOR_LEG_2 -> EquipmentSlot.LEGS;
                    case HumanoidRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.m_21526_()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case HumanoidRenderer.LEFT_SLEEVE -> {
                        if (animatable.m_21526_()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case HumanoidRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case HumanoidRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_BOOT, HumanoidRenderer.LEFT_BOOT_2, HumanoidRenderer.LEFT_ARMOR_LEG, HumanoidRenderer.LEFT_ARMOR_LEG_2 -> baseModel.f_102814_;
                    case HumanoidRenderer.RIGHT_BOOT, HumanoidRenderer.RIGHT_BOOT_2, HumanoidRenderer.RIGHT_ARMOR_LEG, HumanoidRenderer.RIGHT_ARMOR_LEG_2 -> baseModel.f_102813_;
                    case HumanoidRenderer.RIGHT_SLEEVE -> baseModel.f_102811_;
                    case HumanoidRenderer.LEFT_SLEEVE -> baseModel.f_102812_;
                    case HumanoidRenderer.CHESTPLATE -> baseModel.f_102810_;
                    case HumanoidRenderer.HELMET -> baseModel.f_102808_;
                    default -> super.getModelPartForBone(bone, slot, stack, animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<T>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, T animatable) {
                AbstractSpellCastingMob castingMob;
                if (animatable instanceof AbstractSpellCastingMob && (castingMob = (AbstractSpellCastingMob)animatable).isDrinkingPotion() && (castingMob.m_21526_() && bone.getName().equals(HumanoidRenderer.LEFT_HAND) || !castingMob.m_21526_() && bone.getName().equals(HumanoidRenderer.RIGHT_HAND))) {
                    return AbstractSpellCastingMobRenderer.makePotion(castingMob);
                }
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield animatable.m_21205_();
                        }
                        yield animatable.m_21206_();
                    }
                    case HumanoidRenderer.RIGHT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield animatable.m_21206_();
                        }
                        yield animatable.m_21205_();
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_HAND, HumanoidRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.m_85837_(0.0, 0.0, -0.0625);
                poseStack.m_85837_(0.0, -0.0625, 0.0);
                if (stack.m_41720_() instanceof PotionItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                }
                if (stack == animatable.m_21205_()) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == animatable.m_21206_()) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }
}

