/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.datafix;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.datafix.IronsSpellBooksWorldData;
import io.redspace.ironsspellbooks.datafix.IronsTagTraverser;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;

public class IronsWorldUpgrader {
    public static int IRONS_WORLD_DATA_VERSION = 1;
    public static final String REGION_FOLDER = "region";
    public static final String ENTITY_FOLDER = "entities";
    private final LevelStorageSource.LevelStorageAccess levelStorage;
    private final DataFixer dataFixer;
    private int converted;
    private int skipped;
    private int fixes;
    private boolean running;
    private final Object2FloatMap<ResourceKey<Level>> progressMap = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.m_137583_()));
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionDataStorage overworldDataStorage;
    private final IronsSpellBooksWorldData ironsSpellBooksWorldData;
    private Set<ResourceKey<Level>> levels;

    public IronsWorldUpgrader(LevelStorageSource.LevelStorageAccess pLevelStorage, LayeredRegistryAccess<RegistryLayer> registries) {
        this.levelStorage = pLevelStorage;
        try {
            this.levels = registries.m_247579_().m_175515_(Registries.f_256862_).m_214010_().stream().map(Registries::m_257551_).collect(Collectors.toUnmodifiableSet());
        }
        catch (Exception exception) {
            IronsSpellbooks.LOGGER.error("IronsWorldUpgrader. Failed to init levels. Cannot upgrade", (Throwable)exception);
        }
        this.dataFixer = new DataFixerBuilder(1).buildUnoptimized();
        File file = this.levelStorage.m_197394_(Level.f_46428_).resolve("data").toFile();
        try {
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.overworldDataStorage = new DimensionDataStorage(file, this.dataFixer);
        this.ironsSpellBooksWorldData = (IronsSpellBooksWorldData)this.overworldDataStorage.m_164861_(IronsSpellBooksWorldData::load, IronsSpellBooksWorldData::new, "irons_spellbooks");
    }

    public boolean worldNeedsUpgrading() {
        return this.ironsSpellBooksWorldData.getDataVersion() < IRONS_WORLD_DATA_VERSION;
    }

    public void runUpgrade() {
        if (this.levels != null && this.worldNeedsUpgrading()) {
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader starting upgrade");
            try {
                this.levelStorage.m_78312_();
            }
            catch (Exception exception) {
                IronsSpellbooks.LOGGER.error("IronsWorldUpgrader Level Backup failed: {}", (Object)exception.getMessage());
            }
            long millis = Util.m_137550_();
            this.doWork(REGION_FOLDER, "block_entities");
            millis = Util.m_137550_() - millis;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader finished REGION_FOLDER after {} ms.  chunks updated:{} chunks skipped:{} tags fixed:{}", new Object[]{millis, this.converted, this.skipped, this.fixes});
            millis = Util.m_137550_();
            this.doWork(ENTITY_FOLDER, null);
            millis = Util.m_137550_() - millis;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader finished ENTITY_FOLDER after {} ms.  chunks updated:{} chunks skipped:{} tags fixed:{}", new Object[]{millis, this.converted, this.skipped, this.fixes});
            millis = Util.m_137550_();
            this.fixDimensionStorage();
            millis = Util.m_137550_() - millis;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader finished fixDimensionStorage after {} ms. tags fixed:{} ", (Object)millis, (Object)this.fixes);
            int previousVersion = this.ironsSpellBooksWorldData.getDataVersion();
            this.ironsSpellBooksWorldData.setDataVersion(IRONS_WORLD_DATA_VERSION);
            this.overworldDataStorage.m_78151_();
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader V{} -> V{} completed", (Object)previousVersion, (Object)IRONS_WORLD_DATA_VERSION);
        }
    }

    private void fixDimensionStorage() {
        this.running = true;
        this.converted = 0;
        this.skipped = 0;
        this.fixes = 0;
        this.levels.stream().map(resourceKey -> this.levelStorage.m_197394_(resourceKey).resolve("data").toFile()).forEach(dir -> {
            File[] files = dir.listFiles();
            if (files != null) {
                Arrays.stream(files).toList().forEach(file -> {
                    try {
                        CompoundTag compoundTag = NbtIo.m_128937_((File)file);
                        IronsTagTraverser ironsTraverser = new IronsTagTraverser();
                        ironsTraverser.visit((Tag)compoundTag);
                        if (ironsTraverser.changesMade()) {
                            NbtIo.m_128944_((CompoundTag)compoundTag, (File)file);
                            IronsSpellbooks.LOGGER.debug("IronsWorldUpgrader: fixDimensionStorage updating file: {}, {}", (Object)file.getPath(), (Object)ironsTraverser.totalChanges());
                        }
                        this.fixes += ironsTraverser.totalChanges();
                    }
                    catch (Exception exception) {
                        IronsSpellbooks.LOGGER.debug("IronsWorldUpgrader: fixDimensionStorage error: {}", (Object)exception.getMessage());
                    }
                });
            }
        });
    }

    private void doWork(String regionFolder, String filterTag) {
        this.running = true;
        this.converted = 0;
        this.skipped = 0;
        this.fixes = 0;
        int totalChunks = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceKey<Level> resourcekey : this.levels) {
            List<ChunkPos> list = this.getAllChunkPos(resourcekey, regionFolder);
            builder.put(resourcekey, list.listIterator());
            totalChunks += list.size();
        }
        if (totalChunks > 0) {
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (ResourceKey resourceKey : this.levels) {
                Path path = this.levelStorage.m_197394_(resourceKey);
                builder1.put((Object)resourceKey, (Object)new ChunkStorage(path.resolve(regionFolder), this.dataFixer, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            while (this.running) {
                boolean bl;
                boolean bl2 = false;
                for (ResourceKey resourceKey : this.levels) {
                    ListIterator listiterator = (ListIterator)immutablemap.get((Object)resourceKey);
                    ChunkStorage chunkstorage = (ChunkStorage)immutablemap1.get((Object)resourceKey);
                    if (!listiterator.hasNext()) continue;
                    ChunkPos chunkpos = (ChunkPos)listiterator.next();
                    boolean updated = false;
                    try {
                        CompoundTag chunkDataTag = ((Optional)chunkstorage.m_223454_(chunkpos).join()).orElse(null);
                        if (chunkDataTag != null) {
                            ListTag blockEntitiesTag;
                            if (filterTag != null) {
                                blockEntitiesTag = (ListTag)chunkDataTag.m_128423_(filterTag);
                            } else {
                                blockEntitiesTag = new ListTag();
                                blockEntitiesTag.add((Object)chunkDataTag);
                            }
                            IronsTagTraverser ironsTagTraverser = new IronsTagTraverser();
                            ironsTagTraverser.visit((Tag)blockEntitiesTag);
                            if (ironsTagTraverser.changesMade()) {
                                chunkstorage.m_63502_(chunkpos, chunkDataTag);
                                this.fixes = ironsTagTraverser.totalChanges();
                                updated = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        IronsSpellbooks.LOGGER.error("IronsWorldUpgrader: Error upgrading chunk {}, {}", (Object)chunkpos, (Object)exception.getMessage());
                    }
                    if (updated) {
                        ++this.converted;
                    } else {
                        ++this.skipped;
                    }
                    bl = true;
                }
                if (bl) continue;
                this.running = false;
            }
            for (ChunkStorage chunkstorage1 : immutablemap1.values()) {
                try {
                    chunkstorage1.close();
                }
                catch (IOException iOException) {
                    IronsSpellbooks.LOGGER.error("IronsWorldUpgrader: Error closing chunk storage: {}", (Object)iOException.getMessage());
                }
            }
        }
    }

    private List<ChunkPos> getAllChunkPos(ResourceKey<Level> p_18831_, String folder) {
        File file1 = this.levelStorage.m_197394_(p_18831_).toFile();
        File file2 = new File(file1, folder);
        File[] afile = file2.listFiles((p_18822_, p_18823_) -> p_18823_.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        for (File file3 : afile) {
            Matcher matcher = REGEX.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file3.toPath(), file2.toPath(), true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        ChunkPos chunkpos = new ChunkPos(k + i, l + j);
                        if (!regionfile.m_63673_(chunkpos)) continue;
                        list.add(chunkpos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }
}

