/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.datafix;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class IronsSchema
extends Schema {
    static final Map<String, String> ITEM_TO_BLOCKENTITY = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_145919_ -> {
        p_145919_.put("minecraft:furnace", "Furnace");
        p_145919_.put("minecraft:lit_furnace", "Furnace");
        p_145919_.put("minecraft:chest", "Chest");
        p_145919_.put("minecraft:trapped_chest", "Chest");
        p_145919_.put("minecraft:ender_chest", "EnderChest");
        p_145919_.put("minecraft:jukebox", "RecordPlayer");
        p_145919_.put("minecraft:dispenser", "Trap");
        p_145919_.put("minecraft:dropper", "Dropper");
        p_145919_.put("minecraft:sign", "Sign");
        p_145919_.put("minecraft:mob_spawner", "MobSpawner");
        p_145919_.put("minecraft:noteblock", "Music");
        p_145919_.put("minecraft:brewing_stand", "Cauldron");
        p_145919_.put("minecraft:enhanting_table", "EnchantTable");
        p_145919_.put("minecraft:command_block", "CommandBlock");
        p_145919_.put("minecraft:beacon", "Beacon");
        p_145919_.put("minecraft:skull", "Skull");
        p_145919_.put("minecraft:daylight_detector", "DLDetector");
        p_145919_.put("minecraft:hopper", "Hopper");
        p_145919_.put("minecraft:banner", "Banner");
        p_145919_.put("minecraft:flower_pot", "FlowerPot");
        p_145919_.put("minecraft:repeating_command_block", "CommandBlock");
        p_145919_.put("minecraft:chain_command_block", "CommandBlock");
        p_145919_.put("minecraft:standing_sign", "Sign");
        p_145919_.put("minecraft:wall_sign", "Sign");
        p_145919_.put("minecraft:piston_head", "Piston");
        p_145919_.put("minecraft:daylight_detector_inverted", "DLDetector");
        p_145919_.put("minecraft:unpowered_comparator", "Comparator");
        p_145919_.put("minecraft:powered_comparator", "Comparator");
        p_145919_.put("minecraft:wall_banner", "Banner");
        p_145919_.put("minecraft:standing_banner", "Banner");
        p_145919_.put("minecraft:structure_block", "Structure");
        p_145919_.put("minecraft:end_portal", "Airportal");
        p_145919_.put("minecraft:end_gateway", "EndGateway");
        p_145919_.put("minecraft:shield", "Banner");
    });
    protected static final Hook.HookFunction ADD_NAMES = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> p_18312_, T p_18313_) {
            return IronsSchema.addNames(new Dynamic(p_18312_, p_18313_), ITEM_TO_BLOCKENTITY, "ArmorStand");
        }
    };

    public IronsSchema(int pVersionKey, Schema pParent) {
        super(pVersionKey, pParent);
    }

    protected static TypeTemplate equipment(Schema pSchema) {
        return DSL.optionalFields((String)"Equipment", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema)));
    }

    protected static void registerMob(Schema pSchema, Map<String, Supplier<TypeTemplate>> pMap, String pName) {
        pSchema.register(pMap, pName, () -> IronsSchema.equipment(pSchema));
    }

    protected static void registerThrowableProjectile(Schema pSchema, Map<String, Supplier<TypeTemplate>> pMap, String pName) {
        pSchema.register(pMap, pName, () -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.f_16787_.in(pSchema)));
    }

    protected static void registerMinecart(Schema pSchema, Map<String, Supplier<TypeTemplate>> pMap, String pName) {
        pSchema.register(pMap, pName, () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.f_16787_.in(pSchema)));
    }

    protected static void registerInventory(Schema pSchema, Map<String, Supplier<TypeTemplate>> pMap, String pName) {
        pSchema.register(pMap, pName, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema pSchema) {
        HashMap map = Maps.newHashMap();
        pSchema.register((Map)map, "Item", p_18301_ -> DSL.optionalFields((String)"Item", (TypeTemplate)References.f_16782_.in(pSchema)));
        pSchema.registerSimple((Map)map, "XPOrb");
        IronsSchema.registerThrowableProjectile(pSchema, map, "ThrownEgg");
        pSchema.registerSimple((Map)map, "LeashKnot");
        pSchema.registerSimple((Map)map, "Painting");
        pSchema.register((Map)map, "Arrow", p_18298_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.f_16787_.in(pSchema)));
        pSchema.register((Map)map, "TippedArrow", p_18295_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.f_16787_.in(pSchema)));
        pSchema.register((Map)map, "SpectralArrow", p_18292_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.f_16787_.in(pSchema)));
        IronsSchema.registerThrowableProjectile(pSchema, map, "Snowball");
        IronsSchema.registerThrowableProjectile(pSchema, map, "Fireball");
        IronsSchema.registerThrowableProjectile(pSchema, map, "SmallFireball");
        IronsSchema.registerThrowableProjectile(pSchema, map, "ThrownEnderpearl");
        pSchema.registerSimple((Map)map, "EyeOfEnderSignal");
        pSchema.register((Map)map, "ThrownPotion", p_18289_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.f_16787_.in(pSchema), (String)"Potion", (TypeTemplate)References.f_16782_.in(pSchema)));
        IronsSchema.registerThrowableProjectile(pSchema, map, "ThrownExpBottle");
        pSchema.register((Map)map, "ItemFrame", p_18284_ -> DSL.optionalFields((String)"Item", (TypeTemplate)References.f_16782_.in(pSchema)));
        IronsSchema.registerThrowableProjectile(pSchema, map, "WitherSkull");
        pSchema.registerSimple((Map)map, "PrimedTnt");
        pSchema.register((Map)map, "FallingSand", p_18279_ -> DSL.optionalFields((String)"Block", (TypeTemplate)References.f_16787_.in(pSchema), (String)"TileEntityData", (TypeTemplate)References.f_16781_.in(pSchema)));
        pSchema.register((Map)map, "FireworksRocketEntity", p_18274_ -> DSL.optionalFields((String)"FireworksItem", (TypeTemplate)References.f_16782_.in(pSchema)));
        pSchema.registerSimple((Map)map, "Boat");
        pSchema.register((Map)map, "Minecart", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.f_16787_.in(pSchema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema))));
        IronsSchema.registerMinecart(pSchema, map, "MinecartRideable");
        pSchema.register((Map)map, "MinecartChest", p_18269_ -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.f_16787_.in(pSchema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema))));
        IronsSchema.registerMinecart(pSchema, map, "MinecartFurnace");
        IronsSchema.registerMinecart(pSchema, map, "MinecartTNT");
        pSchema.register((Map)map, "MinecartSpawner", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.f_16787_.in(pSchema), (TypeTemplate)References.f_16789_.in(pSchema)));
        pSchema.register((Map)map, "MinecartHopper", p_18264_ -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.f_16787_.in(pSchema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema))));
        IronsSchema.registerMinecart(pSchema, map, "MinecartCommandBlock");
        IronsSchema.registerMob(pSchema, map, "ArmorStand");
        IronsSchema.registerMob(pSchema, map, "Creeper");
        IronsSchema.registerMob(pSchema, map, "Skeleton");
        IronsSchema.registerMob(pSchema, map, "Spider");
        IronsSchema.registerMob(pSchema, map, "Giant");
        IronsSchema.registerMob(pSchema, map, "Zombie");
        IronsSchema.registerMob(pSchema, map, "Slime");
        IronsSchema.registerMob(pSchema, map, "Ghast");
        IronsSchema.registerMob(pSchema, map, "PigZombie");
        pSchema.register((Map)map, "Enderman", p_18259_ -> DSL.optionalFields((String)"carried", (TypeTemplate)References.f_16787_.in(pSchema), (TypeTemplate)IronsSchema.equipment(pSchema)));
        IronsSchema.registerMob(pSchema, map, "CaveSpider");
        IronsSchema.registerMob(pSchema, map, "Silverfish");
        IronsSchema.registerMob(pSchema, map, "Blaze");
        IronsSchema.registerMob(pSchema, map, "LavaSlime");
        IronsSchema.registerMob(pSchema, map, "EnderDragon");
        IronsSchema.registerMob(pSchema, map, "WitherBoss");
        IronsSchema.registerMob(pSchema, map, "Bat");
        IronsSchema.registerMob(pSchema, map, "Witch");
        IronsSchema.registerMob(pSchema, map, "Endermite");
        IronsSchema.registerMob(pSchema, map, "Guardian");
        IronsSchema.registerMob(pSchema, map, "Pig");
        IronsSchema.registerMob(pSchema, map, "Sheep");
        IronsSchema.registerMob(pSchema, map, "Cow");
        IronsSchema.registerMob(pSchema, map, "Chicken");
        IronsSchema.registerMob(pSchema, map, "Squid");
        IronsSchema.registerMob(pSchema, map, "Wolf");
        IronsSchema.registerMob(pSchema, map, "MushroomCow");
        IronsSchema.registerMob(pSchema, map, "SnowMan");
        IronsSchema.registerMob(pSchema, map, "Ozelot");
        IronsSchema.registerMob(pSchema, map, "VillagerGolem");
        pSchema.register((Map)map, "EntityHorse", p_18254_ -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema)), (String)"ArmorItem", (TypeTemplate)References.f_16782_.in(pSchema), (String)"SaddleItem", (TypeTemplate)References.f_16782_.in(pSchema), (TypeTemplate)IronsSchema.equipment(pSchema)));
        IronsSchema.registerMob(pSchema, map, "Rabbit");
        pSchema.register((Map)map, "Villager", p_18245_ -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema)), (String)"Offers", (TypeTemplate)DSL.optionalFields((String)"Recipes", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"buy", (TypeTemplate)References.f_16782_.in(pSchema), (String)"buyB", (TypeTemplate)References.f_16782_.in(pSchema), (String)"sell", (TypeTemplate)References.f_16782_.in(pSchema)))), (TypeTemplate)IronsSchema.equipment(pSchema)));
        pSchema.registerSimple((Map)map, "EnderCrystal");
        pSchema.registerSimple((Map)map, "AreaEffectCloud");
        pSchema.registerSimple((Map)map, "ShulkerBullet");
        IronsSchema.registerMob(pSchema, map, "Shulker");
        return map;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema pSchema) {
        HashMap map = Maps.newHashMap();
        IronsSchema.registerInventory(pSchema, map, "Chest");
        pSchema.registerSimple((Map)map, "EnderChest");
        pSchema.registerSimple((Map)map, "Structure");
        return map;
    }

    public void registerTypes(Schema pSchema, Map<String, Supplier<TypeTemplate>> p_18308_, Map<String, Supplier<TypeTemplate>> p_18309_) {
        pSchema.registerType(false, References.f_16771_, DSL::remainder);
        pSchema.registerType(false, References.f_16772_, () -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema)), (String)"EnderItems", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema))));
        pSchema.registerType(false, References.f_16773_, () -> DSL.fields((String)"Level", (TypeTemplate)DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)References.f_16785_.in(pSchema)), (String)"TileEntities", (TypeTemplate)DSL.list((TypeTemplate)DSL.or((TypeTemplate)References.f_16781_.in(pSchema), (TypeTemplate)DSL.remainder())), (String)"TileTicks", (TypeTemplate)DSL.list((TypeTemplate)DSL.fields((String)"i", (TypeTemplate)References.f_16787_.in(pSchema))))));
        pSchema.registerType(true, References.f_16781_, () -> DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)p_18309_));
        pSchema.registerType(true, References.f_16785_, () -> DSL.optionalFields((String)"Riding", (TypeTemplate)References.f_16785_.in(pSchema), (TypeTemplate)References.f_16786_.in(pSchema)));
        pSchema.registerType(false, References.f_16784_, () -> DSL.constType((Type)NamespacedSchema.m_17310_()));
        pSchema.registerType(true, References.f_16786_, () -> DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)p_18308_));
        pSchema.registerType(true, References.f_16782_, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)References.f_16788_.in(pSchema)), (String)"tag", (TypeTemplate)DSL.optionalFields((String)"EntityTag", (TypeTemplate)References.f_16785_.in(pSchema), (String)"BlockEntityTag", (TypeTemplate)References.f_16781_.in(pSchema), (String)"CanDestroy", (TypeTemplate)DSL.list((TypeTemplate)References.f_16787_.in(pSchema)), (String)"CanPlaceOn", (TypeTemplate)DSL.list((TypeTemplate)References.f_16787_.in(pSchema)), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.f_16782_.in(pSchema)))), (Hook.HookFunction)ADD_NAMES, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
        pSchema.registerType(false, References.f_16775_, DSL::remainder);
        pSchema.registerType(false, References.f_16787_, () -> DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DSL.constType((Type)NamespacedSchema.m_17310_())));
        pSchema.registerType(false, References.f_16788_, () -> DSL.constType((Type)NamespacedSchema.m_17310_()));
        pSchema.registerType(false, References.f_16777_, DSL::remainder);
        pSchema.registerType(false, References.f_16778_, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Features", (TypeTemplate)DSL.compoundList((TypeTemplate)References.f_16790_.in(pSchema)), (String)"Objectives", (TypeTemplate)DSL.list((TypeTemplate)References.f_16791_.in(pSchema)), (String)"Teams", (TypeTemplate)DSL.list((TypeTemplate)References.f_16792_.in(pSchema)))));
        pSchema.registerType(false, References.f_16790_, DSL::remainder);
        pSchema.registerType(false, References.f_16791_, DSL::remainder);
        pSchema.registerType(false, References.f_16792_, DSL::remainder);
        pSchema.registerType(true, References.f_16789_, DSL::remainder);
        pSchema.registerType(false, References.f_16780_, DSL::remainder);
        pSchema.registerType(true, References.f_16795_, DSL::remainder);
        pSchema.registerType(false, References.f_145628_, () -> DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)References.f_16785_.in(pSchema))));
    }

    protected static <T> T addNames(Dynamic<T> p_18206_, Map<String, String> p_18207_, String p_18208_) {
        return (T)p_18206_.update("tag", p_145917_ -> p_145917_.update("BlockEntityTag", p_145912_ -> {
            String s = p_18206_.get("id").asString().result().map(NamespacedSchema::m_17311_).orElse("minecraft:air");
            if (!"minecraft:air".equals(s)) {
                String s1 = (String)p_18207_.get(s);
                if (s1 != null) {
                    return p_145912_.set("id", p_18206_.createString(s1));
                }
                IronsSpellbooks.LOGGER.warn("Unable to resolve BlockEntity for ItemStack: {}", (Object)s);
            }
            return p_145912_;
        }).update("EntityTag", p_145908_ -> {
            String s = p_18206_.get("id").asString("");
            return "minecraft:armor_stand".equals(NamespacedSchema.m_17311_((String)s)) ? p_145908_.set("id", p_18206_.createString(p_18208_)) : p_145908_;
        })).getValue();
    }
}

