/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.damage;

import io.redspace.ironsspellbooks.api.entity.NoKnockbackProjectile;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageSources {
    private static final HashMap<LivingEntity, Integer> knockbackImmunes = new HashMap();

    public static DamageSource get(Level level, ResourceKey<DamageType> damageType) {
        return level.m_269111_().m_269079_(damageType);
    }

    public static Holder<DamageType> getHolderFromResource(Entity entity, ResourceKey<DamageType> damageTypeResourceKey) {
        Optional option = entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(damageTypeResourceKey);
        if (option.isPresent()) {
            return (Holder)option.get();
        }
        return entity.m_9236_().m_269111_().m_287172_().m_269150_();
    }

    public static boolean applyDamage(Entity target, float baseAmount, DamageSource damageSource, @Nullable SchoolType damageSchool) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            float adjustedDamage = baseAmount * DamageSources.getResist(livingTarget, damageSchool);
            boolean fromSummon = false;
            Entity entity = damageSource.m_7640_();
            if (entity instanceof MagicSummon) {
                MagicSummon summon = (MagicSummon)entity;
                fromSummon = true;
                if (summon.getSummoner() != null) {
                    adjustedDamage = (float)((double)adjustedDamage * summon.getSummoner().m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()));
                }
            } else if (damageSource.m_7640_() instanceof NoKnockbackProjectile) {
                DamageSources.ignoreNextKnockback(livingTarget);
            }
            if ((entity = damageSource.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)entity;
                if (DamageSources.isFriendlyFireBetween((Entity)livingAttacker, (Entity)livingTarget)) {
                    return false;
                }
                livingAttacker.m_21335_(target);
            }
            boolean flag = livingTarget.m_6469_(damageSource, adjustedDamage);
            if (fromSummon) {
                livingTarget.m_6703_((LivingEntity)damageSource.m_7640_());
            }
            return flag;
        }
        return target.m_6469_(damageSource, baseAmount);
    }

    public static void ignoreNextKnockback(LivingEntity livingEntity) {
        if (!livingEntity.f_19853_.f_46443_) {
            knockbackImmunes.put(livingEntity, livingEntity.f_19797_);
        }
    }

    @SubscribeEvent
    public static void cancelKnockback(LivingKnockBackEvent event) {
        if (knockbackImmunes.containsKey(event.getEntity())) {
            LivingEntity entity = event.getEntity();
            if (entity.f_19797_ - knockbackImmunes.get(entity) <= 1) {
                event.setCanceled(true);
            }
            knockbackImmunes.remove(entity);
        }
    }

    public static boolean isFriendlyFireBetween(Entity attacker, Entity target) {
        if (attacker == null || target == null) {
            return false;
        }
        Team team = attacker.m_5647_();
        if (team != null) {
            return team.m_83536_(target.m_5647_()) && !team.m_6260_();
        }
        return false;
    }

    @Deprecated(since="MC_1.20", forRemoval=true)
    public static DamageSource directDamageSource(DamageSource source, Entity attacker) {
        return new DamageSource(source.m_269150_(), attacker);
    }

    @Deprecated(since="MC_1.20", forRemoval=true)
    public static DamageSource indirectDamageSource(DamageSource source, Entity projectile, @Nullable Entity attacker) {
        return new DamageSource(source.m_269150_(), attacker, projectile);
    }

    public static float getResist(LivingEntity entity, SchoolType damageSchool) {
        if (damageSchool == null) {
            return 1.0f;
        }
        return 2.0f - (float)Utils.softCapFormula(damageSchool.getResistanceFor(entity));
    }
}

