/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.command.SpellArgument;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CreateScrollCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.irons_spellbooks.create_scroll.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createScroll").requires(p_138819_ -> p_138819_.m_6761_(2))).then(Commands.m_82129_((String)"spell", (ArgumentType)SpellArgument.spellArgument()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(commandContext -> CreateScrollCommand.createScroll((CommandSourceStack)commandContext.getSource(), (String)commandContext.getArgument("spell", String.class), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"))))));
    }

    private static int createScroll(CommandSourceStack source, String spell, int spellLevel) throws CommandSyntaxException {
        AbstractSpell abstractSpell;
        if (!((String)spell).contains(":")) {
            spell = "irons_spellbooks:" + (String)spell;
        }
        if ((abstractSpell = (AbstractSpell)SpellRegistry.REGISTRY.get().getValue(new ResourceLocation((String)spell))) == null || abstractSpell == SpellRegistry.none()) {
            throw ERROR_FAILED.create();
        }
        if (spellLevel > abstractSpell.getMaxLevel()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"commands.irons_spellbooks.create_spell.failed_max_level", (Object[])new Object[]{abstractSpell.getSpellName(), abstractSpell.getMaxLevel()})).create();
        }
        ServerPlayer serverPlayer = source.m_230896_();
        if (serverPlayer != null) {
            ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            SpellData.setSpellData(itemstack, (String)spell, spellLevel);
            if (serverPlayer.m_150109_().m_36054_(itemstack)) {
                return 1;
            }
        }
        throw ERROR_FAILED.create();
    }
}

