/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.spellbook;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class SpellBookData {
    public static final String ISB_SPELLBOOK = "ISB_spellbook";
    public static final String SPELL_SLOTS = "spellSlots";
    public static final String ACTIVE_SPELL_INDEX = "activeSpellIndex";
    public static final String SPELLS = "spells";
    public static final String LEGACY_ID = "id";
    public static final String ID = "sid";
    public static final String LEVEL = "level";
    public static final String SLOT = "slot";
    private SpellData[] transcribedSpells;
    private int activeSpellIndex = -1;
    private int spellSlots;
    private int spellCount = 0;

    public SpellBookData(ItemStack stack, CompoundTag tag) {
        this.loadFromNBT(stack, tag);
    }

    public SpellBookData(int spellSlots) {
        this.spellSlots = spellSlots;
        this.transcribedSpells = new SpellData[this.spellSlots];
    }

    public SpellData getActiveSpell() {
        if (this.activeSpellIndex < 0) {
            return SpellData.EMPTY;
        }
        SpellData spellData = this.transcribedSpells[this.activeSpellIndex];
        if (spellData == null) {
            return SpellData.EMPTY;
        }
        return this.transcribedSpells[this.activeSpellIndex];
    }

    public boolean setActiveSpellIndex(int index, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length && this.transcribedSpells[index] != null) {
            this.activeSpellIndex = index;
            this.handleDirty(stack);
            return true;
        }
        return false;
    }

    public SpellData[] getInscribedSpells() {
        SpellData[] result = new SpellData[this.spellSlots];
        System.arraycopy(this.transcribedSpells, 0, result, 0, this.transcribedSpells.length);
        return result;
    }

    public List<SpellData> getActiveInscribedSpells() {
        return Arrays.stream(this.transcribedSpells).filter(Objects::nonNull).toList();
    }

    private void handleDirty(ItemStack stack) {
        if (stack != null) {
            SpellBookData.setSpellBookData(stack, this);
        }
    }

    public int getSpellSlots() {
        return this.spellSlots;
    }

    public int getActiveSpellIndex() {
        return this.activeSpellIndex;
    }

    public int getSpellCount() {
        return this.spellCount;
    }

    @Nullable
    public SpellData getSpell(int index) {
        if (index >= 0 && index < this.transcribedSpells.length) {
            return this.transcribedSpells[index];
        }
        return SpellData.EMPTY;
    }

    public boolean addSpell(AbstractSpell spell, int level, int index, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length && this.transcribedSpells[index] == null && Arrays.stream(this.transcribedSpells).noneMatch(s -> s != null && s.getSpell().equals(spell))) {
            this.transcribedSpells[index] = new SpellData(spell, level);
            ++this.spellCount;
            if (this.spellCount == 1) {
                this.setActiveSpellIndex(index, null);
            }
            this.handleDirty(stack);
            return true;
        }
        return false;
    }

    public boolean addSpell(AbstractSpell spell, int level, ItemStack stack) {
        int index = this.getNextSpellIndex();
        if (index > -1) {
            return this.addSpell(spell, level, index, stack);
        }
        return false;
    }

    private int getNextSpellIndex() {
        return ArrayUtils.indexOf((Object[])this.transcribedSpells, null);
    }

    public boolean removeSpell(int index, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length && this.transcribedSpells[index] != null) {
            this.transcribedSpells[index] = null;
            --this.spellCount;
            if (this.spellCount == 0) {
                this.activeSpellIndex = -1;
            } else {
                for (int i = 0; i < this.transcribedSpells.length; ++i) {
                    if (this.transcribedSpells[i] == null) continue;
                    this.activeSpellIndex = i;
                    break;
                }
            }
            this.handleDirty(stack);
            return true;
        }
        return false;
    }

    public CompoundTag getNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_(SPELL_SLOTS, this.spellSlots);
        compound.m_128405_(ACTIVE_SPELL_INDEX, this.activeSpellIndex);
        ListTag listTagSpells = new ListTag();
        for (int i = 0; i < this.transcribedSpells.length; ++i) {
            SpellData spellData = this.transcribedSpells[i];
            if (spellData == null) continue;
            CompoundTag ct = new CompoundTag();
            ct.m_128359_(ID, spellData.getSpell().getSpellId());
            ct.m_128405_(LEVEL, spellData.getLevel());
            ct.m_128405_(SLOT, i);
            listTagSpells.add((Object)ct);
        }
        compound.m_128365_(SPELLS, (Tag)listTagSpells);
        return compound;
    }

    public void loadFromNBT(ItemStack stack, CompoundTag compound) {
        this.spellSlots = compound.m_128451_(SPELL_SLOTS);
        this.transcribedSpells = new SpellData[this.spellSlots];
        this.activeSpellIndex = compound.m_128451_(ACTIVE_SPELL_INDEX);
        ListTag listTagSpells = (ListTag)compound.m_128423_(SPELLS);
        this.spellCount = 0;
        if (listTagSpells != null && listTagSpells.size() > 0) {
            listTagSpells.forEach(tag -> {
                CompoundTag t = (CompoundTag)tag;
                String id = t.m_128461_(ID);
                int level = t.m_128451_(LEVEL);
                int index = t.m_128451_(SLOT);
                this.transcribedSpells[index] = new SpellData(SpellRegistry.getSpell(id), level);
                ++this.spellCount;
            });
        }
    }

    public static SpellBookData getSpellBookData(ItemStack stack) {
        if (stack == null) {
            return new SpellBookData(0);
        }
        CompoundTag tag = stack.m_41737_(ISB_SPELLBOOK);
        if (tag != null) {
            return new SpellBookData(stack, tag);
        }
        Item item = stack.m_41720_();
        if (item instanceof SpellBook) {
            SpellBook spellBook = (SpellBook)item;
            SpellBookData spellBookData = new SpellBookData(spellBook.getSpellSlots());
            if (spellBook instanceof UniqueSpellBook) {
                UniqueSpellBook uniqueSpellBook = (UniqueSpellBook)spellBook;
                uniqueSpellBook.getSpells().forEach(sd -> spellBookData.addSpell(sd.getSpell(), sd.getLevel(), null));
            }
            SpellBookData.setSpellBookData(stack, spellBookData);
            return spellBookData;
        }
        return new SpellBookData(0);
    }

    public static void setSpellBookData(ItemStack stack, SpellBookData spellBookData) {
        if (spellBookData != null) {
            stack.m_41700_(ISB_SPELLBOOK, (Tag)spellBookData.getNBT());
        }
    }
}

