/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.item.armor.UpgradeType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class UpgradeData {
    public static final String Upgrades = "ISBUpgrades";
    public static final String Upgrade_Key = "id";
    public static final String Slot_Key = "slot";
    public static final String Upgrade_Count = "upgrades";
    public static final UpgradeData NONE = new UpgradeData(Map.of(), EquipmentSlot.MAINHAND);
    private final Map<UpgradeType, Integer> upgrades;
    private EquipmentSlot upgradedSlot;

    protected UpgradeData(Map<UpgradeType, Integer> upgrades, EquipmentSlot slot) {
        this.upgrades = upgrades;
        this.upgradedSlot = slot;
    }

    public static UpgradeData getUpgradeData(ItemStack itemStack) {
        if (!UpgradeData.hasUpgradeData(itemStack)) {
            return NONE;
        }
        ListTag upgrades = itemStack.m_41784_().m_128437_(Upgrades, 10);
        HashMap<UpgradeType, Integer> map = new HashMap<UpgradeType, Integer>();
        EquipmentSlot upgradedSlot = null;
        for (Tag tag : upgrades) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)tag;
            if (upgradedSlot == null) {
                upgradedSlot = EquipmentSlot.m_20747_((String)compoundTag.m_128461_(Slot_Key));
            }
            ResourceLocation upgradeKey = new ResourceLocation(compoundTag.m_128461_(Upgrade_Key));
            UpgradeType.getUpgrade(upgradeKey).ifPresent(upgrade -> map.put((UpgradeType)upgrade, compoundTag.m_128451_(Upgrade_Count)));
        }
        return new UpgradeData(map, upgradedSlot);
    }

    public static boolean hasUpgradeData(ItemStack itemStack) {
        return itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(Upgrades);
    }

    public static void setUpgradeData(ItemStack itemStack, UpgradeData upgradeData) {
        if (upgradeData == NONE) {
            if (UpgradeData.hasUpgradeData(itemStack)) {
                itemStack.m_41749_(Upgrades);
            }
            return;
        }
        ListTag upgrades = new ListTag();
        for (Map.Entry<UpgradeType, Integer> upgradeInstance : upgradeData.upgrades.entrySet()) {
            CompoundTag upgradeTag = new CompoundTag();
            upgradeTag.m_128359_(Upgrade_Key, upgradeInstance.getKey().getId().toString());
            upgradeTag.m_128359_(Slot_Key, upgradeData.upgradedSlot.m_20751_());
            upgradeTag.m_128405_(Upgrade_Count, upgradeInstance.getValue().intValue());
            upgrades.add((Object)upgradeTag);
        }
        itemStack.m_41700_(Upgrades, (Tag)upgrades);
    }

    public static void removeUpgradeData(ItemStack itemStack) {
        UpgradeData.setUpgradeData(itemStack, NONE);
    }

    public UpgradeData addUpgrade(ItemStack stack, UpgradeType upgradeType, EquipmentSlot slot) {
        if (this == NONE) {
            HashMap<UpgradeType, Integer> map = new HashMap<UpgradeType, Integer>();
            map.put(upgradeType, 1);
            UpgradeData upgrade = new UpgradeData(map, slot);
            UpgradeData.setUpgradeData(stack, upgrade);
            return upgrade;
        }
        if (this.upgrades.containsKey(upgradeType)) {
            this.upgrades.put(upgradeType, this.upgrades.get(upgradeType) + 1);
        } else {
            this.upgrades.put(upgradeType, 1);
        }
        UpgradeData.setUpgradeData(stack, this);
        return this;
    }

    public int getCount() {
        int count = 0;
        for (Map.Entry<UpgradeType, Integer> upgradeInstance : this.upgrades.entrySet()) {
            count += upgradeInstance.getValue().intValue();
        }
        return count;
    }

    public EquipmentSlot getUpgradedSlot() {
        return this.upgradedSlot;
    }

    public Map<UpgradeType, Integer> getUpgrades() {
        return this.upgrades;
    }
}

