/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.network.ClientboundSyncCameraShake;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CameraShakeManager {
    public static final ArrayList<CameraShakeData> cameraShakeData = new ArrayList();
    public static ArrayList<CameraShakeData> clientCameraShakeData = new ArrayList();

    public static void addCameraShake(CameraShakeData data) {
        cameraShakeData.add(data);
        CameraShakeManager.doSync();
    }

    public static void removeCameraShake(CameraShakeData data) {
        if (cameraShakeData.remove(data)) {
            CameraShakeManager.doSync();
        }
    }

    private static void doSync() {
        Messages.sendToAllPlayers(new ClientboundSyncCameraShake(cameraShakeData));
    }

    public static void doSync(ServerPlayer player) {
        Messages.sendToPlayer(new ClientboundSyncCameraShake(cameraShakeData), player);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleCameraShake(ViewportEvent.ComputeCameraAngles event) {
        if (clientCameraShakeData.isEmpty()) {
            return;
        }
        Entity player = event.getCamera().m_90592_();
        List closestPositions = clientCameraShakeData.stream().sorted((o1, o2) -> (int)(o1.origin.m_82557_(player.m_20182_()) - o2.origin.m_82557_(player.m_20182_()))).toList();
        Vec3 closestPos = ((CameraShakeData)closestPositions.get((int)0)).origin;
        float intensity = (float)Mth.m_14085_((double)1.0, (double)0.0, (double)(closestPos.m_82557_(player.m_20182_()) * (double)0.0039f));
        float f = (float)((double)player.f_19797_ + event.getPartialTick());
        float yaw = Mth.m_14089_((float)(f * 1.5f)) * intensity * 0.35f;
        float pitch = Mth.m_14089_((float)(f * 2.0f)) * intensity * 0.35f;
        float roll = Mth.m_14031_((float)(f * 2.2f)) * intensity * 0.35f;
        event.setYaw(event.getYaw() + yaw);
        event.setRoll(event.getRoll() + roll);
        event.setPitch(event.getPitch() + pitch);
    }
}

