/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.RawAnimation;

public class AnimationHolder {
    private final RawAnimation geckoAnimation;
    private final ResourceLocation playerAnimation;
    public final boolean adjustLeftArm;
    public final boolean adjustRightArm;
    private static final AnimationHolder empty = new AnimationHolder();

    public AnimationHolder(String path, Animation.LoopType loopType) {
        this.playerAnimation = IronsSpellbooks.id(path);
        this.geckoAnimation = RawAnimation.begin().then(this.playerAnimation.m_135815_(), loopType);
        this.adjustLeftArm = true;
        this.adjustRightArm = true;
    }

    private AnimationHolder() {
        this.playerAnimation = null;
        this.geckoAnimation = null;
        this.adjustLeftArm = false;
        this.adjustRightArm = false;
    }

    public static AnimationHolder none() {
        return empty;
    }

    public Optional<RawAnimation> getForMob() {
        return this.geckoAnimation == null ? Optional.empty() : Optional.of(this.geckoAnimation);
    }

    public Optional<ResourceLocation> getForPlayer() {
        return this.playerAnimation == null ? Optional.empty() : Optional.of(this.playerAnimation);
    }
}

