/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.spells;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Vector3f;

public class SchoolType {
    final ResourceLocation id;
    final TagKey<Item> focus;
    final Component displayName;
    final Style displayStyle;
    final LazyOptional<Attribute> powerAttribute;
    final LazyOptional<Attribute> resistanceAttribute;
    final LazyOptional<SoundEvent> defaultCastSound;
    final ResourceKey<DamageType> damageType;

    public SchoolType(ResourceLocation id, TagKey<Item> focus, Component displayName, LazyOptional<Attribute> powerAttribute, LazyOptional<Attribute> resistanceAttribute, LazyOptional<SoundEvent> defaultCastSound, ResourceKey<DamageType> damageType) {
        this.id = id;
        this.focus = focus;
        this.displayName = displayName;
        this.displayStyle = displayName.m_7383_();
        this.powerAttribute = powerAttribute;
        this.resistanceAttribute = resistanceAttribute;
        this.defaultCastSound = defaultCastSound;
        this.damageType = damageType;
    }

    public double getResistanceFor(LivingEntity livingEntity) {
        Attribute resistanceAttribute = (Attribute)this.resistanceAttribute.orElse(null);
        if (resistanceAttribute != null) {
            return livingEntity.m_21133_(resistanceAttribute);
        }
        return 1.0;
    }

    public double getPowerFor(LivingEntity livingEntity) {
        Attribute powerAttribute = (Attribute)this.powerAttribute.orElse(null);
        if (powerAttribute != null) {
            return livingEntity.m_21133_(powerAttribute);
        }
        return 1.0;
    }

    public SoundEvent getCastSound() {
        return (SoundEvent)this.defaultCastSound.resolve().get();
    }

    public ResourceKey<DamageType> getDamageType() {
        return this.damageType;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public boolean isFocus(ItemStack itemStack) {
        return itemStack.m_204117_(this.focus);
    }

    public Vector3f getTargetingColor() {
        int decimal = this.displayStyle.m_131135_().m_131265_();
        return new Vector3f((float)(decimal >> 16 & 0xFF) / 255.0f, (float)(decimal >> 8 & 0xFF) / 255.0f, (float)(decimal & 0xFF) / 255.0f);
    }
}

