/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ClientScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.network.PacketGetScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ScreenRenderer
implements BlockEntityRenderer<ScreenTileEntity> {
    private static final ClientScreenModuleHelper clientScreenModuleHelper = new ClientScreenModuleHelper();

    public ScreenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull ScreenTileEntity tileEntity, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        ScreenRenderer.renderInternal(tileEntity, matrixStack, buffer, packedLightIn, packedOverlayIn);
    }

    public static void renderInternal(ScreenTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        Direction facing = Direction.SOUTH;
        Direction horizontalFacing = Direction.SOUTH;
        if (!tileEntity.isDummy()) {
            BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(tileEntity.m_58899_());
            if (state.m_60734_() instanceof ScreenBlock) {
                facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                horizontalFacing = (Direction)state.m_61143_((Property)ScreenBlock.HORIZ_FACING);
            } else {
                return;
            }
        }
        matrixStack.m_85836_();
        switch (horizontalFacing) {
            case NORTH: {
                yRotation = -180.0f;
                break;
            }
            case WEST: {
                yRotation = -90.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
            }
        }
        switch (facing) {
            case DOWN: {
                xRotation = 90.0f;
                break;
            }
            case UP: {
                xRotation = -90.0f;
            }
        }
        matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
        RenderHelper.rotateYP((PoseStack)matrixStack, (float)yRotation);
        RenderHelper.rotateXP((PoseStack)matrixStack, (float)xRotation);
        matrixStack.m_252880_(0.0f, 0.0f, -0.4375f);
        if (tileEntity.isDummy()) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            graphics.m_280168_().m_85850_().m_252922_().set((Matrix4fc)matrixStack.m_85850_().m_252922_());
            graphics.m_280168_().m_85850_().m_252943_().set((Matrix3fc)matrixStack.m_85850_().m_252943_());
            graphics.m_280509_(98, 28, 252, 182, -2236963);
            graphics.m_280509_(100, 30, 250, 180, -13421773);
        } else if (!tileEntity.isTransparent()) {
            ScreenRenderer.renderScreenBoard(matrixStack, buffer, tileEntity.getSize(), tileEntity.getColor(), packedLightIn, packedOverlayIn);
        }
        if (tileEntity.isRenderable()) {
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            Map<Integer, IModuleData> screenData = ScreenRenderer.updateScreenData(tileEntity);
            List<IClientScreenModule<?>> modules = tileEntity.getClientScreenModules();
            if (tileEntity.isShowHelp()) {
                modules = ScreenTileEntity.getHelpingScreenModules();
            }
            GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            graphics.m_280168_().m_85850_().m_252922_().set((Matrix4fc)matrixStack.m_85850_().m_252922_());
            graphics.m_280168_().m_85850_().m_252943_().set((Matrix3fc)matrixStack.m_85850_().m_252943_());
            ScreenRenderer.renderModules(graphics, buffer, fontrenderer, tileEntity, modules, screenData, tileEntity.isDummy() ? 0 : tileEntity.getSize());
        }
        matrixStack.m_85849_();
    }

    private static Map<Integer, IModuleData> updateScreenData(ScreenTileEntity screenTileEntity) {
        GlobalPos key;
        Map<Integer, Object> screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > (long)((Integer)ScreenConfiguration.SCREEN_REFRESH_TIMING.get()).intValue() && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            GlobalPos pos = GlobalPos.m_122643_(screenTileEntity.getDimension(), (BlockPos)screenTileEntity.m_58899_());
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetScreenData("rftoolsutility", pos, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(key = GlobalPos.m_122643_(screenTileEntity.getDimension(), (BlockPos)screenTileEntity.m_58899_()))) == null) {
            screenData = Collections.emptyMap();
        }
        return screenData;
    }

    private static void renderModules(GuiGraphics graphics, MultiBufferSource buffer, Font fontrenderer, ScreenTileEntity tileEntity, List<IClientScreenModule<?>> modules, Map<Integer, IModuleData> screenData, int size) {
        PoseStack stack;
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        float f = 0.0075f;
        float minf3 = -1.0f;
        if (tileEntity.isDummy()) {
            stack = new PoseStack();
            stack.m_252880_(100.0f, 30.0f, 0.0f);
            f = 1.0f;
            minf3 = 1.0f;
        } else {
            stack = graphics.m_280168_();
        }
        BlockPos pos = tileEntity.m_58899_();
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        IClientScreenModule<?> hitModule = null;
        ScreenTileEntity.ModuleRaytraceResult hit = null;
        if (!tileEntity.isDummy()) {
            Direction horizontalFacing;
            double zz;
            double yy;
            double xx;
            Direction sideHit;
            BlockState blockState = tileEntity.m_58904_().m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block != ScreenModule.SCREEN.get() && block != ScreenModule.CREATIVE_SCREEN.get() && block != ScreenModule.SCREEN_HIT.get()) {
                return;
            }
            if (mouseOver instanceof BlockHitResult && (sideHit = ((BlockHitResult)mouseOver).m_82434_()) == blockState.m_61143_((Property)BlockStateProperties.f_61372_) && (hit = tileEntity.getHitModule(xx = mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_(), yy = mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_(), zz = mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_(), sideHit, horizontalFacing = (Direction)blockState.m_61143_((Property)ScreenBlock.HORIZ_FACING), tileEntity.isDummy() ? 1 : tileEntity.getSize())) != null) {
                hitModule = modules.get(hit.moduleIndex());
            }
        }
        for (IClientScreenModule<?> module : modules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                stack.m_85836_();
                switch (module.getTransformMode()) {
                    case TEXT: {
                        stack.m_252880_(-0.5f, 0.5f, 0.03f);
                        stack.m_85841_(f * factor, minf3 * f * factor, f);
                        break;
                    }
                    case TEXTLARGE: {
                        stack.m_252880_(-0.5f, 0.5f, 0.03f);
                        stack.m_85841_(f * 2.0f * factor, minf3 * f * 2.0f * factor, f * 2.0f);
                        break;
                    }
                    case ITEM: {
                        stack.m_252880_(0.0f, 0.0f, -0.04f);
                        if (!tileEntity.isDummy()) break;
                        stack.m_252880_(65.0f, 70.0f, 0.0f);
                        stack.m_85841_(133.33334f, -133.33334f, 10000.0f);
                    }
                }
                IModuleData data = screenData.get(moduleIndex);
                try {
                    int hitx = -1;
                    int hity = -1;
                    if (module == hitModule) {
                        hitx = hit.x();
                        hity = hit.y() - hit.currenty();
                    }
                    boolean truetype = false;
                    switch (tileEntity.getTrueTypeMode()) {
                        case -1: {
                            break;
                        }
                        case 1: {
                            truetype = (Boolean)ScreenConfiguration.forceNoTruetype.get() == false;
                            break;
                        }
                        case 0: {
                            if (((Boolean)ScreenConfiguration.forceNoTruetype.get()).booleanValue()) break;
                            truetype = (Boolean)ScreenConfiguration.useTruetype.get();
                        }
                    }
                    ModuleRenderInfo renderInfo = new ModuleRenderInfo(factor, pos, hitx, hity, truetype, tileEntity.isBright() || tileEntity.isDummy(), ScreenConfiguration.getTrueTypeFont());
                    module.render(graphics, buffer, (IModuleRenderHelper)clientScreenModuleHelper, fontrenderer, currenty, data, renderInfo);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                currenty += height;
                stack.m_85849_();
            }
            ++moduleIndex;
        }
    }

    private static void renderScreenBoard(PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int size, int color, int packedLightIn, int packedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
        float dim = switch (size) {
            case 2 -> 2.46f;
            case 1 -> 1.46f;
            default -> 0.46f;
        };
        float fr = 0.5f;
        float fg = 0.5f;
        float fb = 0.5f;
        float zback = 0.05f;
        float zfront = 0.0f;
        float ss = 0.5f;
        RenderHelper.drawBox((PoseStack)matrixStack, (VertexConsumer)builder, (float)(-ss), (float)(ss + (float)size), (float)(-ss), (float)(ss + (float)size), (float)zback, (float)zfront, (float)fr, (float)fg, (float)fb, (int)packedLightIn);
        RenderHelper.drawQuadGui((PoseStack)matrixStack, (VertexConsumer)builder, (float)-0.46f, (float)dim, (float)-0.46f, (float)dim, (float)-0.01f, (int)(0xFF000000 | color), (int)packedLightIn);
        matrixStack.m_85849_();
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ScreenModule.TYPE_SCREEN.get()), ScreenRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ScreenModule.TYPE_CREATIVE_SCREEN.get()), ScreenRenderer::new);
    }
}

