/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.item.ITooltipProvider;

public class ItemWrench
extends TieredItem {
    private ITooltipProvider tooltipProvider;

    public ItemWrench(Item.Properties properties) {
        super((Tier)Tiers.IRON, properties);
    }

    public ItemWrench(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public ItemWrench tooltip(ITooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
        return this;
    }

    public ItemWrench tooltip(String normal, String shift) {
        boolean hasShift;
        boolean hasNormal = !Strings.isNullOrEmpty((String)normal);
        boolean bl = hasShift = !Strings.isNullOrEmpty((String)shift);
        if (hasNormal || hasShift) {
            this.tooltip((stack, world, tooltip, advanced) -> {
                if (hasShift && Screen.m_96638_()) {
                    tooltip.add(Component.m_237115_((String)shift));
                } else {
                    if (hasNormal) {
                        tooltip.add(Component.m_237115_((String)normal));
                    }
                    if (hasShift) {
                        tooltip.add(Component.m_237115_((String)"info.shetiphian.holdshift"));
                    }
                }
            });
        }
        return this;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Rotation direction = player != null && player.m_6047_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        BlockState result = state.rotate((LevelAccessor)world, pos, direction);
        if (player != null) {
            player.m_6674_(context.m_43724_());
        }
        if (result != state) {
            if (result != world.m_8055_(pos)) {
                world.m_7731_(pos, result, 11);
            }
            result.m_60690_(world, pos, result.m_60734_(), pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.tooltipProvider != null) {
            this.tooltipProvider.build(stack, world, tooltip, flag.m_7050_());
        }
    }
}

