/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StringUtil {
    private static final Pattern STYLE_PATTERN = Pattern.compile("\u00a7([0-9a-fk-or])", 2);
    @OnlyIn(value=Dist.CLIENT)
    public static final LoadingCache<String, Component> TRANSLATION_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Component>(){

        public Component load(String key) {
            String text = I18n.m_118938_((String)key, (Object[])new Object[0]);
            return Component.m_237113_((String)("\u00a7f" + text)).m_6270_(StringUtil.computeStyleFrom(text));
        }
    });

    private static String[] prepAndSplit(String string) {
        string = string.replace("\\t", "    ");
        return string.split("(?>\\r\\n|\\r|\\n|%n|<br>)", -1);
    }

    public static void multiLineTooltip(String string, List<Component> list) {
        for (String line : StringUtil.prepAndSplit(string)) {
            list.add((Component)Component.m_237113_((String)line));
        }
    }

    public static void multiLine(String string, List<String> list) {
        Collections.addAll(list, StringUtil.prepAndSplit(string));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateAndSplitTooltip(String string, List<Component> list) {
        StringUtil.multiLineTooltip(I18n.m_118938_((String)string, (Object[])new Object[0]), list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateAndSplit(String string, List<String> list) {
        StringUtil.multiLine(I18n.m_118938_((String)string, (Object[])new Object[0]), list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String[] translateAll(String ... keys) {
        String[] strings = new String[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            strings[index] = I18n.m_118938_((String)keys[index], (Object[])new Object[0]);
        }
        return strings;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Component translateAndComputeStyle(String string) {
        return (Component)TRANSLATION_CACHE.getUnchecked((Object)string);
    }

    public static Style computeStyleFrom(String string) {
        Matcher matcher = STYLE_PATTERN.matcher(string);
        HashSet set = new HashSet();
        matcher.results().forEach(matchResult -> {
            String value = matchResult.group().toLowerCase(Locale.ROOT);
            if (!value.matches("\u00a7[k-o]")) {
                set.clear();
            }
            if (!value.equals("\u00a7r")) {
                set.add(ChatFormatting.m_126645_((char)value.charAt(value.length() - 1)));
            }
        });
        set.remove(null);
        if (!set.isEmpty()) {
            return Style.f_131099_.m_131152_(set.toArray(new ChatFormatting[0]));
        }
        return Style.f_131099_;
    }
}

