/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.awt.Color;
import net.minecraft.util.Mth;

public class ColorHelper {
    public static int rgbToColor(float red, float green, float blue) {
        red = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
        green = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
        blue = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
        return -16777216 + ((int)(red * 255.0f) << 16) + ((int)(green * 255.0f) << 8) + (int)(blue * 255.0f);
    }

    public static int hslToColor(float hue, float saturation, float lightness) {
        int[] values = ColorHelper.fromHSLtoRGB(hue, saturation, lightness);
        return -16777216 + (values[0] << 16) + (values[1] << 8) + values[2];
    }

    public static int hsvToColor(float hue, float saturation, float value) {
        Color color = Color.getHSBColor(hue, saturation, value);
        return color.getRGB();
    }

    public static int rybToColor(float red, float yellow, float blue) {
        red = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
        yellow = Mth.m_14036_((float)yellow, (float)0.0f, (float)1.0f);
        blue = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
        int[] rgb = ColorHelper.fromRYBtoRGB((int)(red * 255.0f), (int)(yellow * 255.0f), (int)(blue * 255.0f));
        return -16777216 + (rgb[0] << 16) + (rgb[1] << 8) + rgb[2];
    }

    public static float[] colorToRGB(int color) {
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        float base = 0.003921569f;
        return new float[]{(float)red * base, (float)green * base, (float)blue * base};
    }

    public static float[] colorToHSL(int color) {
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        return ColorHelper.fromRGBtoHSL(red, green, blue);
    }

    public static float[] colorToHSV(int color) {
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        return Color.RGBtoHSB(red, green, blue, null);
    }

    public static float[] colorToRYB(int color) {
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        return ColorHelper.fromRGBtoRYB(red, green, blue);
    }

    private static int[] fromHSLtoRGB(float hue, float saturation, float lightness) {
        int red;
        int green;
        int blue;
        if (saturation == 0.0f) {
            green = blue = (int)(lightness * 255.0f);
            red = blue;
        } else {
            float chroma = lightness < 0.5f ? lightness * (1.0f + saturation) : lightness + saturation - saturation * lightness;
            float p = 2.0f * lightness - chroma;
            red = (int)(0.5f + 255.0f * ColorHelper.hueToRgb(p, chroma, hue + 0.33333334f));
            green = (int)(0.5f + 255.0f * ColorHelper.hueToRgb(p, chroma, hue));
            blue = (int)(0.5f + 255.0f * ColorHelper.hueToRgb(p, chroma, hue - 0.33333334f));
        }
        return new int[]{red, green, blue};
    }

    private static float hueToRgb(float p, float c, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (c - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return c;
        }
        if (3.0f * h < 2.0f) {
            return p + (c - p) * (0.6666667f - h) * 6.0f;
        }
        return p;
    }

    private static float[] fromRGBtoHSL(int red, int green, int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float delta = max - min;
        float h = 0.0f;
        float s = 0.0f;
        float l = (max + min) / 2.0f;
        if (min != max) {
            s = (double)l < 0.5 ? delta / (max + min) : delta / (2.0f - max - min);
            float dR = ((max - r) / 6.0f + delta / 2.0f) / delta;
            float dG = ((max - g) / 6.0f + delta / 2.0f) / delta;
            float dB = ((max - b) / 6.0f + delta / 2.0f) / delta;
            if (r == max) {
                h = dB - dG;
            } else if (g == max) {
                h = 0.33333334f + dR - dB;
            } else if (b == max) {
                h = 0.6666667f + dG - dR;
            }
            if (h < 0.0f) {
                h += 1.0f;
            }
            if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        return new float[]{h, s, l};
    }

    private static float[] fromRGBtoRYB(int vR, int vG, int vB) {
        float maxYellow;
        float red = vR;
        float green = vG;
        float blue = vB;
        float white = Math.min(red, Math.min(green, blue));
        float maxGreen = Math.max(red -= white, Math.max(green -= white, blue -= white));
        float yellow = Math.min(red, green);
        red -= yellow;
        green -= yellow;
        if (blue > 0.0f && green > 0.0f) {
            blue /= 2.0f;
            green /= 2.0f;
        }
        if ((maxYellow = Math.max(red, Math.max(yellow += green, blue += green))) > 0.0f) {
            float diff = maxGreen / maxYellow;
            red *= diff;
            yellow *= diff;
            blue *= diff;
        }
        return new float[]{(red += white) / 255.0f, (yellow += white) / 255.0f, (blue += white) / 255.0f};
    }

    private static int[] fromRYBtoRGB(int vR, int vY, int vB) {
        float maxGreen;
        float red = vR;
        float yellow = vY;
        float blue = vB;
        float white = Math.min(red, Math.min(yellow, blue));
        float maxYellow = Math.max(red -= white, Math.max(yellow -= white, blue -= white));
        float green = Math.min(yellow, blue);
        yellow -= green;
        if ((blue -= green) > 0.0f && green > 0.0f) {
            blue *= 2.0f;
            green *= 2.0f;
        }
        if ((maxGreen = Math.max(red += yellow, Math.max(green += yellow, blue))) > 0.0f) {
            float diff = maxYellow / maxGreen;
            red *= diff;
            green *= diff;
            blue *= diff;
        }
        return new int[]{(int)(red += white), (int)(green += white), (int)(blue += white)};
    }
}

