/*
 * Decompiled with CFR 0.152.
 */
package team.creative.opticmanager.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.opticmanager.OpticEventHandler;
import team.creative.opticmanager.OpticManager;

@OnlyIn(value=Dist.CLIENT)
public class OpticEventHandlerClient {
    public long lastWorldTimeClient = -1L;
    public long lastTotalWorldTimeClient = -1L;
    public long realWorldTimeClient;
    public static double defaultGammaSetting;

    public void tick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            ClientLevel level = mc.f_91073_;
            if (!OpticEventHandler.shouldAffectWorld((Level)level)) {
                return;
            }
            long expectedWorldTime = this.lastWorldTimeClient + 1L;
            if (expectedWorldTime == level.m_46468_()) {
                ++this.realWorldTimeClient;
                int days = (int)(this.realWorldTimeClient / (long)OpticManager.CONFIG.getTotalDayDuration());
                if (OpticEventHandler.isDay(this.realWorldTimeClient, OpticManager.CONFIG.dayDuration, OpticManager.CONFIG.nightDuration)) {
                    level.m_104746_((long)days * 24000L + (long)((float)(this.realWorldTimeClient % (long)OpticManager.CONFIG.getTotalDayDuration()) / (float)OpticManager.CONFIG.dayDuration * 12000.0f));
                } else {
                    level.m_104746_((long)((float)((long)days * 24000L) + (float)(this.realWorldTimeClient % (long)OpticManager.CONFIG.getTotalDayDuration() - (long)OpticManager.CONFIG.dayDuration) / (float)OpticManager.CONFIG.nightDuration * 12000.0f + 12000.0f));
                }
                level.m_104637_(level.m_46467_() + expectedWorldTime - level.m_46468_());
            } else {
                this.assignTimeClient(level.m_46468_());
            }
            this.lastWorldTimeClient = level.m_46468_();
            this.lastTotalWorldTimeClient = level.m_46467_();
        }
    }

    public void assignTimeClient(long worldTime) {
        long days = worldTime / 24000L;
        this.realWorldTimeClient = days * (long)OpticManager.CONFIG.getTotalDayDuration();
        this.realWorldTimeClient = OpticEventHandler.isDayVanilla(worldTime) ? (this.realWorldTimeClient += (long)((float)(worldTime % 24000L) / 12000.0f * (float)OpticManager.CONFIG.dayDuration)) : (this.realWorldTimeClient += (long)((float)(worldTime % 24000L - 12000L) / 12000.0f * (float)OpticManager.CONFIG.nightDuration + (float)OpticManager.CONFIG.dayDuration));
    }

    public void renderStart() {
        Minecraft mc = Minecraft.m_91087_();
        if (OpticManager.CONFIG.overrideBrightness) {
            defaultGammaSetting = (Double)mc.f_91066_.m_231927_().m_231551_();
            mc.f_91066_.m_231927_().m_231514_((Object)OpticManager.CONFIG.getRealBrightness());
        }
    }

    public void render() {
        Minecraft mc = Minecraft.m_91087_();
        if (OpticManager.CONFIG.overrideBrightness) {
            mc.f_91066_.m_231927_().m_231514_((Object)defaultGammaSetting);
        }
        mc.f_91066_.m_232090_().m_231514_((Object)OpticManager.CONFIG.visibility);
    }
}

