/*
 * Decompiled with CFR 0.152.
 */
package team.creative.opticmanager;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import team.creative.opticmanager.OpticManager;

public class OpticEventHandler {
    public static final long vanillaDuration = 24000L;
    public static final long vanillaHalfDuration = 12000L;
    public long lastWorldTime = -1L;
    public long lastTotalWorldTime = -1L;
    public long realWorldTime;

    public static boolean shouldAffectWorld(Level world) {
        return world.m_46472_().m_135782_().equals((Object)BuiltinDimensionTypes.f_223538_.m_135782_()) && world.m_46469_().m_46207_(GameRules.f_46140_);
    }

    public static boolean isDayVanilla(long time) {
        return OpticEventHandler.isDay(time, 12000L, 12000L);
    }

    public static boolean isDay(long time, long dayDuration, long nightDuration) {
        return time % (dayDuration + nightDuration) <= dayDuration;
    }

    public void assignTime(long worldTime) {
        long days = worldTime / 24000L;
        this.realWorldTime = days * (long)OpticManager.CONFIG.getTotalDayDuration();
        this.realWorldTime = OpticEventHandler.isDayVanilla(worldTime) ? (this.realWorldTime += (long)((float)(worldTime % 24000L) / 12000.0f * (float)OpticManager.CONFIG.dayDuration)) : (this.realWorldTime += (long)((float)(worldTime % 24000L - 12000L) / 12000.0f * (float)OpticManager.CONFIG.nightDuration + (float)OpticManager.CONFIG.dayDuration));
    }

    public void levelTick(ServerLevel level) {
        if (!OpticEventHandler.shouldAffectWorld((Level)level)) {
            return;
        }
        long expectedWorldTime = this.lastWorldTime + 1L;
        if (expectedWorldTime == level.m_46468_()) {
            ++this.realWorldTime;
            int days = (int)(this.realWorldTime / (long)OpticManager.CONFIG.getTotalDayDuration());
            if (OpticEventHandler.isDay(this.realWorldTime, OpticManager.CONFIG.dayDuration, OpticManager.CONFIG.nightDuration)) {
                level.m_8615_((long)days * 24000L + (long)((float)(this.realWorldTime % (long)OpticManager.CONFIG.getTotalDayDuration()) / (float)OpticManager.CONFIG.dayDuration * 12000.0f));
            } else {
                level.m_8615_((long)((float)((long)days * 24000L) + (float)(this.realWorldTime % (long)OpticManager.CONFIG.getTotalDayDuration() - (long)OpticManager.CONFIG.dayDuration) / (float)OpticManager.CONFIG.nightDuration * 12000.0f + 12000.0f));
            }
        } else {
            this.assignTime(level.m_46468_());
        }
        this.lastWorldTime = level.m_46468_();
        this.lastTotalWorldTime = level.m_46467_();
    }
}

