/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import twilightforest.entity.MagicPainting;
import twilightforest.init.custom.MagicPaintingVariants;

public class MagicPaintingItem
extends Item {
    public MagicPaintingItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Direction face = context.m_43719_();
        BlockPos relative = context.m_8083_().m_121945_(face);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && !this.mayPlace(player, face, stack, relative)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        Optional<MagicPainting> optional = MagicPainting.create(level, relative, face);
        if (optional.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        MagicPainting painting = optional.get();
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            if (!level.m_5776_()) {
                EntityType.m_20620_((Level)level, (Player)player, (Entity)painting, (CompoundTag)compoundtag);
            } else if (compoundtag.m_128425_("EntityTag", 10)) {
                painting.setVariant(compoundtag.m_128469_("EntityTag").m_128461_("variant"));
            }
        }
        if (painting.m_7088_()) {
            if (!level.f_46443_) {
                painting.m_7084_();
                level.m_220400_((Entity)player, GameEvent.f_157810_, painting.m_20182_());
                level.m_7967_((Entity)painting);
            }
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack stack, BlockPos pos) {
        return !direction.m_122434_().m_122478_() && player.m_36204_(pos, direction, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
        CompoundTag tag;
        super.m_7373_(stack, level, components, isAdvanced);
        if (level != null && (tag = stack.m_41783_()) != null && tag.m_128425_("EntityTag", 10)) {
            CompoundTag entityTag = tag.m_128469_("EntityTag");
            MagicPaintingVariants.getVariant(level.m_9598_(), entityTag.m_128461_("variant")).ifPresent(variant -> {
                ResourceLocation location = new ResourceLocation(entityTag.m_128461_("variant"));
                components.add((Component)Component.m_237115_((String)location.m_269108_("magic_painting", "title")).m_130940_(ChatFormatting.YELLOW));
                components.add((Component)Component.m_237115_((String)location.m_269108_("magic_painting", "author")).m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237110_((String)"painting.dimensions", (Object[])new Object[]{Mth.m_184652_((int)variant.width(), (int)16), Mth.m_184652_((int)variant.height(), (int)16)}));
            });
        }
    }
}

