/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import twilightforest.data.helpers.TFLangProvider;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;

public class LangGenerator
extends TFLangProvider {
    public static final Map<ResourceLocation, Pair<String, String>> MAGIC_PAINTING_HELPER = new HashMap<ResourceLocation, Pair<String, String>>();

    public LangGenerator(PackOutput output) {
        super(output);
    }

    protected void addTranslations() {
        this.add("itemGroup.twilightforest.blocks", "Twilight Forest: Blocks");
        this.add("itemGroup.twilightforest.items", "Twilight Forest: Items");
        this.add("itemGroup.twilightforest.equipment", "Twilight Forest: Equipment");
        this.addBiome(TFBiomes.FOREST, "Twilight Forest");
        this.addBiome(TFBiomes.DENSE_FOREST, "Dense Forest");
        this.addBiome(TFBiomes.FIREFLY_FOREST, "Firefly Forest");
        this.addBiome(TFBiomes.CLEARING, "Twilight Clearing");
        this.addBiome(TFBiomes.OAK_SAVANNAH, "Oak Savanna");
        this.addBiome(TFBiomes.STREAM, "Twilight Stream");
        this.addBiome(TFBiomes.LAKE, "Twilight Lake");
        this.addBiome(TFBiomes.MUSHROOM_FOREST, "Mushroom Forest");
        this.addBiome(TFBiomes.DENSE_MUSHROOM_FOREST, "Dense Mushroom Forest");
        this.addBiome(TFBiomes.ENCHANTED_FOREST, "Enchanted Forest");
        this.addBiome(TFBiomes.SPOOKY_FOREST, "Spooky Forest");
        this.addBiome(TFBiomes.SWAMP, "Twilight Swamp");
        this.addBiome(TFBiomes.FIRE_SWAMP, "Fire Swamp");
        this.addBiome(TFBiomes.DARK_FOREST, "Dark Forest");
        this.addBiome(TFBiomes.DARK_FOREST_CENTER, "Dark Forest Center");
        this.addBiome(TFBiomes.SNOWY_FOREST, "Snowy Forest");
        this.addBiome(TFBiomes.GLACIER, "Twilight Glacier");
        this.addBiome(TFBiomes.HIGHLANDS, "Twilight Highlands");
        this.addBiome(TFBiomes.THORNLANDS, "Thornlands");
        this.addBiome(TFBiomes.FINAL_PLATEAU, "Final Plateau");
        this.addBiome(TFBiomes.UNDERGROUND, "Underground");
        this.add("dimension.twilightforest.twilight_forest", "Twilight Forest");
        this.addStructure(TFStructures.HEDGE_MAZE, "Hedge Maze");
        this.addStructure(TFStructures.HOLLOW_HILL_SMALL, "Small Hollow Hill");
        this.addStructure(TFStructures.HOLLOW_HILL_MEDIUM, "Medium Hollow Hill");
        this.addStructure(TFStructures.HOLLOW_HILL_LARGE, "Large Hollow Hill");
        this.addStructure(TFStructures.QUEST_GROVE, "Quest Grove");
        this.addStructure(TFStructures.MUSHROOM_TOWER, "Mushroom Castle");
        this.addStructure(TFStructures.NAGA_COURTYARD, "Naga Courtyard");
        this.addStructure(TFStructures.LICH_TOWER, "Lich Tower");
        this.addStructure(TFStructures.LABYRINTH, "Minotaur Labyrinth");
        this.addStructure(TFStructures.HYDRA_LAIR, "Hydra's Lair");
        this.addStructure(TFStructures.KNIGHT_STRONGHOLD, "Knight Stronghold");
        this.addStructure(TFStructures.DARK_TOWER, "Dark Tower");
        this.addStructure(TFStructures.YETI_CAVE, "Yeti Cave");
        this.addStructure(TFStructures.AURORA_PALACE, "Aurora Palace");
        this.addStructure(TFStructures.TROLL_CAVE, "Troll Cave");
        this.addStructure(TFStructures.FINAL_CASTLE, "Final Plateau Castle");
        this.addCommand("usage", "/%s <info | reactivate | conquer | center>");
        this.addCommand("not_in_twilight_forest", "You are not in the Twilight Forest dimension");
        this.addCommand("not_player", "This command must be run by a valid player!");
        this.addCommand("none_nearby", "Couldn't find a feature nearby!");
        this.addCommand("nearest", "The nearest feature is: %s");
        this.addCommand("center", "Center of feature: %s");
        this.addCommand("chunk", "Located in feature chunk: %s");
        this.addCommand("structure.inside", "You are in a Landmark structure");
        this.addCommand("structure.outside", "You are not in a Landmark structure");
        this.addCommand("structure.required", "You are not in a structure");
        this.addCommand("structure.conquer.status", "Structure conquer flag: %s");
        this.addCommand("structure.conquer.update", "Structure conquer flag was %s, changing to %s");
        this.addCommand("structure.spawn_list", "Spawn list for this area is:");
        this.addCommand("structure.spawn_info", "%s, Weight %s");
        this.add("gamerule.tfEnforcedProgression", "Twilight Forest: Enforced Progression");
        this.add("gamerule.tfEnforcedProgression.description", "Some Twilight Forest biomes will be locked until you defeat certain bosses in the dimension. (You can check the progression order in your advancements)");
        this.add("effect.twilightforest.frosted", "Frosted");
        this.addEnchantment("chill_aura", "Chill Aura", "Adds a chance for the attacker to gain the frosted effect after hitting the wearer.");
        this.addEnchantment("fire_react", "Fire React", "Adds a chance for the attacker to be set on fire after hitting the wearer.");
        this.addEnchantment("destruction", "Destruction", "Allows the Block and Chain to break blocks with a higher mining tier.");
        this.addAdvancement("root", "Twilight Forest", "Enter the mysterious, magical woodlands: the Twilight Forest");
        this.addAdvancement("kill_cicada", "Shut", "Kill a Cicada");
        this.addAdvancement("hedge", "Bug Stomper", "Defeat a spider in a Hedge Maze");
        this.addAdvancement("hill1", "The Boots Are Mine!", "Defeat a %s in a Small Hollow Hill");
        this.addAdvancement("hill2", "What Was That Noise?", "Defeat a %s in a Medium Hollow Hill");
        this.addAdvancement("hill3", "I See Right Through You", "Defeat a %s in a Large Hollow Hill");
        this.addAdvancement("quest_ram", "Consummate Baaahs", "Give the %s what it is missing");
        this.addAdvancement("magic_map_focus", "With Fire It Writes", "Craft the %s with a %s, %s, and %s");
        this.addAdvancement("magic_map", "I Can See Forever", "Craft the %s");
        this.addAdvancement("maze_map", "And Now, to Find the Exit", "Craft the %s after obtaining the focus from the labyrinth");
        this.addAdvancement("ore_map", "How Can That Be Worth It?", "Craft the %s");
        this.addAdvancement("twilight_hunter", "The Silence of the Forest", "Hunt some of the local wildlife");
        this.addAdvancement("kill_naga", "Time To Even The Scales", "Slay the %s in its forest courtyard and obtain a %s to overcome the barrier magic surrounding the Lich's tower");
        this.addAdvancement("naga_armors", "Naga Armorer", "Craft both %s chest and leg armor");
        this.addAdvancement("kill_lich", "Bring Out Your Dead", "Slay the %s at top of his tower and retrieve a scepter to clear poisonous mosquitoes from the Swamp, see through blinding darkness of the Dark Forest's curse, and resist the Snowy Forest's chill");
        this.addAdvancement("lich_scepters", "By Our Powers Combined!", "Acquire all four scepters of power");
        this.addAdvancement("full_mettle_alchemist", "Full Mettle Alchemist", "Drink four doses of Harming II from a potion flask in under 8 seconds and survive");
        this.addAdvancement("progress_labyrinth", "Mighty Stroganoff", "Eat the Meef Stroganoff to acclimatize your body to the dangerous heat of the Fire Swamp");
        this.addAdvancement("mazebreaker", "Breaking the Maze", "Find the %s pickaxe in the secret labyrinth vault");
        this.addAdvancement("kill_hydra", "Hydra Slayer", "Defeat the mighty %s and empower yourself");
        this.addAdvancement("hydra_chop", "Hydra Chop, Baby!", "Chow down on a %s when your hunger bar is depleted");
        this.addAdvancement("progress_trophy_pedestal", "Trophied Champion", "Claim your title by placing a trophy on the pedestal in the Dark Forest ruins");
        this.addAdvancement("progress_knights", "Carminite Acclimation", "Settle the restless phantoms in the knight's tomb and the carminite tower's devices will obey you");
        this.addAdvancement("ghast_trap", "Something Strange in Towerwood", "Slay the %ss around a %s and activate to wrench the %s from the sky!");
        this.addAdvancement("progress_ur_ghast", "Tears of Fire", "Touch the fiery red tears of the %s");
        this.addAdvancement("experiment_115", "Mystery Meat?", "It looks like cake, though...");
        this.addAdvancement("experiment_115_2", "Making a note: Huge Success!", "It's so delicious and moist!");
        this.addAdvancement("experiment_115_3", "Eating 115 Everyday, 115 Years, Forever", "eating experiment one-hundred-fifteen all day, forever, one-hundred-fifteen times experiment one-hundred-fifteen, experiment one-hundred-fifteen dot com, double-u double-u double-u dot experiment one-hundred-fifteen dot com, one-hundred-fifteen years, every minute experiment one-hundred-fifteen dot com, double-u double-u double-u dot one-hundred-fifteen times experiment one-hundred-fifteen dot com");
        this.addAdvancement("progress_yeti", "Alpha Fur", "Line your garments with the soft fur from the %s, keeping you safe from the Glacier's cold");
        this.addAdvancement("arctic_dyed", "Getting in Fashion", "Dye four unique pieces of Arctic armor");
        this.addAdvancement("progress_glacier", "Clear Skies", "Defeat the %s atop the Aurora Palace");
        this.addAdvancement("glass_sword", "One Hit Wonder", "Hope you made good use of that.");
        this.addAdvancement("fiery_set", "Gallons of Blood and Tears", "Wield a fiery tool or weapon while having at least one piece of fiery armor in your inventory");
        this.addAdvancement("progress_merge", "Ultimate Showdown", "Slay the %s, %s, and %s to clear the acid rain and embolden yourself for the Highlands");
        this.addAdvancement("troll", "We Do a Little Trolling", "Find and kill a %s");
        this.addAdvancement("beanstalk", "Jack and the Beanstalk", "Obtain some %s in the troll caves and use them on the glowing soil beneath the clouds");
        this.addAdvancement("giants", "I'm on Cloud Nine", "Kill a %s in the clouds, retrieve a %s, and return back to the troll caves");
        this.addAdvancement("progress_troll", "I Wish For More Burning", "Find the %s in the troll caves, and you can burn away the thorn barriers");
        this.addAdvancement("progression_end", "End of Progression", "Anything past this point in the Highlands is a work in progress. It will be finished in the future");
        this.addAdvancement("twilight_dining", "We Dine At Eternal Sundown", "Eat every edible item exclusive to Twilight Forest");
        this.addAdvancement("arborist", "Maniacal Dendrologist", "Get your axes and shears ready. Search every nook and cranny and get anything and everything that comes from trees! Craft, loot, obtain every slab... sapling... leaves... more... everything. ALL OF IT!");
        this.addMessage("advancement_hidden", "<Hidden Advancement>");
        this.addMessage("advancement_required", "Advancement Required:");
        this.addMessage("biome_locked", "Biome Locked!");
        this.addMessage("biome_locked_2", "Check your advancements");
        this.addMessage("core_disabled", "%s is disabled via config");
        this.addMessage("firefly_spawner_radius", "Firefly Particle Radius: %s Blocks");
        this.addMessage("magic_map_fail", "The Magic faltered. Perhaps it doesn't work here?");
        this.addMessage("nyi", "This feature has effects that are not yet implemented.");
        this.addMessage("ore_meter_exposed", "Exposed: %s");
        this.addMessage("ore_meter_range", "Radius: %s, Origin: [%s, %s]");
        this.addMessage("pedestal_ineligible", "You are unworthy.");
        this.addMessage("portal_unsafe", "It doesn't seem safe here...");
        this.addMessage("portal_unworthy", "The Portal pool is unresponsive. Perhaps something was neglected?");
        this.addMessage("wip0", "This feature is a work in progress and may have bugs or unintended effects that may damage your world.");
        this.addMessage("wip1", "Use with caution.");
        this.addBlock((Supplier)TFBlocks.CICADA, "Cicada");
        this.addBlock((Supplier)TFBlocks.CICADA_JAR, "Cicada Jar");
        this.addBlock((Supplier)TFBlocks.FIREFLY, "Firefly");
        this.addBlock((Supplier)TFBlocks.FIREFLY_JAR, "Firefly Jar");
        this.addBlock((Supplier)TFBlocks.MOONWORM, "Moonworm");
        this.addBlock((Supplier)TFBlocks.FIREFLY_SPAWNER, "Firefly Particle Spawner");
        this.addBlock((Supplier)TFBlocks.TWILIGHT_PORTAL, "Twilight Forest Portal");
        this.addBlock((Supplier)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE, "Miniature Twilight Forest Portal");
        this.addBlock((Supplier)TFBlocks.NAGASTONE, "Nagastone");
        this.addBlock((Supplier)TFBlocks.NAGASTONE_HEAD, "Nagastone Head");
        this.addStoneVariants("etched_nagastone", "Etched Nagastone");
        this.addStoneVariants("nagastone_pillar", "Nagastone Pillar");
        this.addBlock((Supplier)TFBlocks.NAGASTONE_STAIRS_LEFT, "Nagastone Stairs (Left)");
        this.addBlock((Supplier)TFBlocks.NAGASTONE_STAIRS_RIGHT, "Nagastone Stairs (Right)");
        this.addBlock((Supplier)TFBlocks.CRACKED_NAGASTONE_STAIRS_LEFT, "Cracked Nagastone Stairs (Left)");
        this.addBlock((Supplier)TFBlocks.CRACKED_NAGASTONE_STAIRS_RIGHT, "Cracked Nagastone Stairs (Right)");
        this.addBlock((Supplier)TFBlocks.MOSSY_NAGASTONE_STAIRS_LEFT, "Mossy Nagastone Stairs (Left)");
        this.addBlock((Supplier)TFBlocks.MOSSY_NAGASTONE_STAIRS_RIGHT, "Mossy Nagastone Stairs (Right)");
        this.addBlock((Supplier)TFBlocks.SPIRAL_BRICKS, "Spiral Bricks");
        this.addBlock((Supplier)TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE, "Miniature Naga Courtyard");
        this.addBlock((Supplier)TFBlocks.TWISTED_STONE, "Twisted Stone");
        this.addBlock((Supplier)TFBlocks.TWISTED_STONE_PILLAR, "Twisted Stone Pillar");
        this.addBlock((Supplier)TFBlocks.BOLD_STONE_PILLAR, "Bold Stone Pillar");
        this.addBlock((Supplier)TFBlocks.CANDELABRA, "Candelabra");
        this.addBlock((Supplier)TFBlocks.WROUGHT_IRON_FENCE, "Wrought Iron Fence");
        this.addBlock((Supplier)TFBlocks.WROUGHT_IRON_FINIAL, "Wrought Iron Finial");
        this.addBlock((Supplier)TFBlocks.KEEPSAKE_CASKET, "Keepsake Casket");
        this.add("block.twilightforest.casket.broken", "Your Keepsake Casket was too damaged to hold any more items. All items that would be stored in your casket were dropped on the ground.");
        this.add("block.twilightforest.casket.locked", "This Casket can only be opened by %s!");
        this.addBlock((Supplier)TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE, "Miniature Lich Tower");
        this.addBlock((Supplier)TFBlocks.HUGE_LILY_PAD, "Huge Lily Pad");
        this.addBlock((Supplier)TFBlocks.HUGE_WATER_LILY, "Huge Water Lily");
        this.addBlock((Supplier)TFBlocks.MAZESTONE, "Mazestone");
        this.addBlock((Supplier)TFBlocks.MAZESTONE_BRICK, "Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.CRACKED_MAZESTONE, "Cracked Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.MOSSY_MAZESTONE, "Mossy Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.CUT_MAZESTONE, "Cut Mazestone");
        this.addBlock((Supplier)TFBlocks.DECORATIVE_MAZESTONE, "Decorative Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.MAZESTONE_MOSAIC, "Mazestone Mosaic");
        this.addBlock((Supplier)TFBlocks.MAZESTONE_BORDER, "Mazestone Border");
        this.addBlock((Supplier)TFBlocks.RED_THREAD, "Red Thread");
        this.addBlock((Supplier)TFBlocks.SMOKER, "Smoker");
        this.addBlock((Supplier)TFBlocks.FIRE_JET, "Fire Jet");
        this.addBlock((Supplier)TFBlocks.ENCASED_SMOKER, "Encased Smoker");
        this.addBlock((Supplier)TFBlocks.ENCASED_FIRE_JET, "Encased Fire Jet");
        this.addBlock((Supplier)TFBlocks.TROPHY_PEDESTAL, "Trophy Pedestal");
        this.addBlock((Supplier)TFBlocks.STRONGHOLD_SHIELD, "Stronghold Shield");
        this.addBlock((Supplier)TFBlocks.UNDERBRICK, "Underbrick");
        this.addBlock((Supplier)TFBlocks.CRACKED_UNDERBRICK, "Cracked Underbrick");
        this.addBlock((Supplier)TFBlocks.MOSSY_UNDERBRICK, "Mossy Underbrick");
        this.addBlock((Supplier)TFBlocks.UNDERBRICK_FLOOR, "Underbrick Floor");
        this.addBlock((Supplier)TFBlocks.TOWERWOOD, "Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.CRACKED_TOWERWOOD, "Cracked Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.MOSSY_TOWERWOOD, "Mossy Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.INFESTED_TOWERWOOD, "Infested Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.ENCASED_TOWERWOOD, "Encased Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.UNBREAKABLE_VANISHING_BLOCK, "Vanishing Block");
        this.addBlock((Supplier)TFBlocks.VANISHING_BLOCK, "Vanishing Block");
        this.addBlock((Supplier)TFBlocks.REAPPEARING_BLOCK, "Reappearing Block");
        this.addBlock((Supplier)TFBlocks.LOCKED_VANISHING_BLOCK, "Locked Vanishing Block");
        this.addBlock((Supplier)TFBlocks.CARMINITE_BUILDER, "Carminite Builder");
        this.addBlock((Supplier)TFBlocks.BUILT_BLOCK, "Built Block");
        this.addBlock((Supplier)TFBlocks.ANTIBUILDER, "Antibuilder");
        this.addBlock((Supplier)TFBlocks.ANTIBUILT_BLOCK, "Antibuilt Block");
        this.addBlock((Supplier)TFBlocks.GHAST_TRAP, "Ghast Trap");
        this.addBlock((Supplier)TFBlocks.CARMINITE_REACTOR, "Carminite Reactor");
        this.addBlock((Supplier)TFBlocks.REACTOR_DEBRIS, "Reactor Debris");
        this.addBlock((Supplier)TFBlocks.FAKE_DIAMOND, "Diamond Block");
        this.addBlock((Supplier)TFBlocks.FAKE_GOLD, "Gold Block");
        this.addBlock((Supplier)TFBlocks.EXPERIMENT_115, "Experiment 115");
        this.addBlock((Supplier)TFBlocks.AURORA_BLOCK, "Aurora Block");
        this.addBlock((Supplier)TFBlocks.AURORA_SLAB, "Aurora Slab");
        this.addBlock((Supplier)TFBlocks.AURORA_PILLAR, "Aurora Pillar");
        this.addBlock((Supplier)TFBlocks.AURORALIZED_GLASS, "Auroralized Glass");
        this.addBlock((Supplier)TFBlocks.HUGE_MUSHGLOOM, "Huge Mushgloom Block");
        this.addBlock((Supplier)TFBlocks.HUGE_MUSHGLOOM_STEM, "Huge Mushgloom Stem");
        this.addBlock((Supplier)TFBlocks.HUGE_STALK, "Huge Stalk");
        this.addBlock((Supplier)TFBlocks.BEANSTALK_LEAVES, "Beanstalk Leaves");
        this.addBlock((Supplier)TFBlocks.UBEROUS_SOIL, "Uberous Soil");
        this.addBlock((Supplier)TFBlocks.TROLLVIDR, "Trollvidr");
        this.addBlock((Supplier)TFBlocks.UNRIPE_TROLLBER, "Unripe Trollber");
        this.addBlock((Supplier)TFBlocks.TROLLBER, "Trollber");
        this.addBlock((Supplier)TFBlocks.TROLLSTEINN, "Trollsteinn");
        this.addBlock((Supplier)TFBlocks.FLUFFY_CLOUD, "Fluffy Cloud");
        this.addBlock((Supplier)TFBlocks.RAINY_CLOUD, "Rainy Cloud");
        this.addBlock((Supplier)TFBlocks.SNOWY_CLOUD, "Snowy Cloud");
        this.addBlock((Supplier)TFBlocks.WISPY_CLOUD, "Wispy Cloud");
        this.addBlock((Supplier)TFBlocks.GIANT_LEAVES, "Giant Leaves");
        this.addBlock((Supplier)TFBlocks.GIANT_LOG, "Giant Log");
        this.addBlock((Supplier)TFBlocks.GIANT_COBBLESTONE, "Giant Cobblestone");
        this.addBlock((Supplier)TFBlocks.GIANT_OBSIDIAN, "Giant Obsidian");
        this.addBlock((Supplier)TFBlocks.BROWN_THORNS, "Thorns");
        this.addBlock((Supplier)TFBlocks.GREEN_THORNS, "Green Thorns");
        this.addBlock((Supplier)TFBlocks.BURNT_THORNS, "Burnt Thorns");
        this.addBlock((Supplier)TFBlocks.THORN_ROSE, "Thorn Rose");
        this.addBlock((Supplier)TFBlocks.THORN_LEAVES, "Thorn Leaves");
        this.addBlock((Supplier)TFBlocks.DEADROCK, "Deadrock");
        this.addBlock((Supplier)TFBlocks.CRACKED_DEADROCK, "Cracked Deadrock");
        this.addBlock((Supplier)TFBlocks.WEATHERED_DEADROCK, "Weathered Deadrock");
        this.addStoneVariants("castle_brick", "Castle Brick");
        this.addStoneVariants("castle_brick_stairs", "Castle Brick Stairs");
        this.add((Block)TFBlocks.WORN_CASTLE_BRICK.get(), "Worn Castle Brick");
        this.add((Block)TFBlocks.THICK_CASTLE_BRICK.get(), "Thick Castle Brick");
        this.add((Block)TFBlocks.CASTLE_ROOF_TILE.get(), "Castle Roof Tile");
        this.add((Block)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get(), "Encased Castle Brick Pillar");
        this.add((Block)TFBlocks.ENCASED_CASTLE_BRICK_TILE.get(), "Encased Castle Brick Tile");
        this.add((Block)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get(), "Bold Castle Brick Pillar");
        this.add((Block)TFBlocks.BOLD_CASTLE_BRICK_TILE.get(), "Bold Castle Brick Tile");
        this.add((Block)TFBlocks.WORN_CASTLE_BRICK_STAIRS.get(), "Worn Castle Brick Stairs");
        this.add((Block)TFBlocks.ENCASED_CASTLE_BRICK_STAIRS.get(), "Encased Castle Brick Stairs");
        this.add((Block)TFBlocks.BOLD_CASTLE_BRICK_STAIRS.get(), "Bold Castle Brick Stairs");
        this.add((Block)TFBlocks.PINK_CASTLE_RUNE_BRICK.get(), "Magenta Castle Rune Brick");
        this.add((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get(), "Yellow Castle Rune Brick");
        this.add((Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get(), "Blue Castle Rune Brick");
        this.add((Block)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get(), "Violet Castle Rune Brick");
        this.add((Block)TFBlocks.PINK_CASTLE_DOOR.get(), "Magenta Castle Door");
        this.add((Block)TFBlocks.YELLOW_CASTLE_DOOR.get(), "Yellow Castle Door");
        this.add((Block)TFBlocks.BLUE_CASTLE_DOOR.get(), "Blue Castle Door");
        this.add((Block)TFBlocks.VIOLET_CASTLE_DOOR.get(), "Violet Castle Door");
        this.add((Block)TFBlocks.PINK_FORCE_FIELD.get(), "Magenta Force Field");
        this.add((Block)TFBlocks.ORANGE_FORCE_FIELD.get(), "Orange Force Field");
        this.add((Block)TFBlocks.GREEN_FORCE_FIELD.get(), "Green Force Field");
        this.add((Block)TFBlocks.BLUE_FORCE_FIELD.get(), "Blue Force Field");
        this.add((Block)TFBlocks.VIOLET_FORCE_FIELD.get(), "Violet Force Field");
        this.addBlock((Supplier)TFBlocks.IRONWOOD_BLOCK, "Block of Ironwood");
        this.addBlock((Supplier)TFBlocks.STEELEAF_BLOCK, "Block of Steeleaf");
        this.addBlock((Supplier)TFBlocks.KNIGHTMETAL_BLOCK, "Block of Knightmetal");
        this.add("block.twilightforest.knightmetal_block.desc", "Works as a stronger cactus");
        this.addBlock((Supplier)TFBlocks.ARCTIC_FUR_BLOCK, "Block of Arctic Fur");
        this.add("block.twilightforest.arctic_fur_block.desc", "Reduces fall damage by 90%");
        this.addBlock((Supplier)TFBlocks.FIERY_BLOCK, "Block of Fiery Metal");
        this.addBlock((Supplier)TFBlocks.CARMINITE_BLOCK, "Block of Carminite");
        this.addBlock((Supplier)TFBlocks.CINDER_FURNACE, "Cinder Furnace");
        this.addBlock((Supplier)TFBlocks.CINDER_LOG, "Cinder Log");
        this.addBlock((Supplier)TFBlocks.CINDER_WOOD, "Cinder Wood");
        this.addBlock((Supplier)TFBlocks.IRON_LADDER, "Iron Ladder");
        this.addBlock((Supplier)TFBlocks.SLIDER, "Slide Trap");
        this.addBlock((Supplier)TFBlocks.TWILIGHT_OAK_LEAVES, "Twilight Oak Leaves");
        this.addSapling("twilight_oak", "Sickly Twilight Oak Sapling");
        this.createLogs("twilight_oak", "Twilight Oak");
        this.createWoodSet("twilight_oak", "Twilight Oak");
        this.addBlock((Supplier)TFBlocks.CANOPY_LEAVES, "Canopy Tree Leaves");
        this.addSapling("canopy", "Canopy Tree Sapling");
        this.createLogs("canopy", "Canopy Tree");
        this.createWoodSet("canopy", "Canopy");
        this.addBlock((Supplier)TFBlocks.CANOPY_BOOKSHELF, "Canopy Bookshelf");
        this.addBlock((Supplier)TFBlocks.EMPTY_CANOPY_BOOKSHELF, "Empty Canopy Bookshelf");
        this.addBlock((Supplier)TFBlocks.DEATH_TOME_SPAWNER, "Death Tome Spawner");
        this.addBlock((Supplier)TFBlocks.MANGROVE_LEAVES, "Mangrove Leaves");
        this.addSapling("mangrove", "Mangrove Sapling");
        this.createLogs("mangrove", "Mangrove");
        this.createWoodSet("mangrove", "Mangrove");
        this.addBlock((Supplier)TFBlocks.DARK_LEAVES, "Darkwood Leaves");
        this.addBlock((Supplier)TFBlocks.HARDENED_DARK_LEAVES, "Thick Darkwood Leaves");
        this.addSapling("darkwood", "Darkwood Sapling");
        this.createLogs("dark", "Darkwood");
        this.createWoodSet("dark", "Darkwood");
        this.addBlock((Supplier)TFBlocks.TIME_LOG_CORE, "Timewood Clock");
        this.addBlock((Supplier)TFBlocks.TIME_LEAVES, "Timewood Leaves");
        this.addSapling("time", "Tree of Time Sapling");
        this.createLogs("time", "Timewood");
        this.createWoodSet("time", "Timewood");
        this.addBlock((Supplier)TFBlocks.TRANSFORMATION_LOG_CORE, "Heart of Transformation");
        this.addBlock((Supplier)TFBlocks.TRANSFORMATION_LEAVES, "Leaves of Transformation");
        this.addSapling("transformation", "Tree of Transformation Sapling");
        this.createLogs("transformation", "Transwood");
        this.createWoodSet("transformation", "Transwood");
        this.addBlock((Supplier)TFBlocks.MINING_LOG_CORE, "Minewood Core");
        this.addBlock((Supplier)TFBlocks.MINING_LEAVES, "Miner's Leaves");
        this.addSapling("mining", "Miner's Tree Sapling");
        this.createLogs("mining", "Minewood");
        this.createWoodSet("mining", "Minewood");
        this.addBlock((Supplier)TFBlocks.SORTING_LOG_CORE, "Sortingwood Engine");
        this.addBlock((Supplier)TFBlocks.SORTING_LEAVES, "Sorting Leaves");
        this.addSapling("sorting", "Sorting Tree Sapling");
        this.createLogs("sorting", "Sortingwood");
        this.createWoodSet("sorting", "Sortingwood");
        this.addBlock((Supplier)TFBlocks.RAINBOW_OAK_LEAVES, "Rainbow Oak Leaves");
        this.addSapling("rainbow_oak", "Rainbow Oak Sapling");
        this.addSapling("hollow_oak", "Robust Twilight Oak Sapling");
        this.addBlock((Supplier)TFBlocks.OAK_BANISTER, "Oak Banister");
        this.addBlock((Supplier)TFBlocks.SPRUCE_BANISTER, "Spruce Banister");
        this.addBlock((Supplier)TFBlocks.BIRCH_BANISTER, "Birch Banister");
        this.addBlock((Supplier)TFBlocks.JUNGLE_BANISTER, "Jungle Banister");
        this.addBlock((Supplier)TFBlocks.ACACIA_BANISTER, "Acacia Banister");
        this.addBlock((Supplier)TFBlocks.DARK_OAK_BANISTER, "Dark Oak Banister");
        this.addBlock((Supplier)TFBlocks.CRIMSON_BANISTER, "Crimson Banister");
        this.addBlock((Supplier)TFBlocks.WARPED_BANISTER, "Warped Banister");
        this.addBlock((Supplier)TFBlocks.VANGROVE_BANISTER, "Mangrove Banister");
        this.addBlock((Supplier)TFBlocks.BAMBOO_BANISTER, "Bamboo Banister");
        this.addBlock((Supplier)TFBlocks.CHERRY_BANISTER, "Cherry Banister");
        this.createHollowLogs("oak", "Oak", false);
        this.createHollowLogs("spruce", "Spruce", false);
        this.createHollowLogs("birch", "Birch", false);
        this.createHollowLogs("jungle", "Jungle", false);
        this.createHollowLogs("acacia", "Acacia", false);
        this.createHollowLogs("dark_oak", "Dark Oak", false);
        this.createHollowLogs("crimson", "Crimson", true);
        this.createHollowLogs("warped", "Warped", true);
        this.createHollowLogs("vangrove", "Mangrove", false);
        this.createHollowLogs("cherry", "Cherry", false);
        this.add("block.twilightforest.banister.cycle", "Right click with an axe to cycle");
        this.addBlock((Supplier)TFBlocks.MOSS_PATCH, "Moss Patch");
        this.addBlock((Supplier)TFBlocks.CLOVER_PATCH, "Clover Patch");
        this.addBlock((Supplier)TFBlocks.TORCHBERRY_PLANT, "Torchberry Plant");
        this.addBlock((Supplier)TFBlocks.ROOT_STRAND, "Root Strands");
        this.addBlock((Supplier)TFBlocks.FALLEN_LEAVES, "Fallen Leaves");
        this.addBlock((Supplier)TFBlocks.MAYAPPLE, "Mayapple");
        this.addBlock((Supplier)TFBlocks.POTTED_MAYAPPLE, "Potted Mayapple");
        this.addBlock((Supplier)TFBlocks.FIDDLEHEAD, "Fiddlehead Fern");
        this.addBlock((Supplier)TFBlocks.POTTED_FIDDLEHEAD, "Potted Fiddlehead");
        this.addBlock((Supplier)TFBlocks.MUSHGLOOM, "Mushgloom");
        this.addBlock((Supplier)TFBlocks.POTTED_MUSHGLOOM, "Potted Mushgloom");
        this.addBlock((Supplier)TFBlocks.POTTED_THORN, "Potted Thorn");
        this.addBlock((Supplier)TFBlocks.POTTED_GREEN_THORN, "Potted Green Thorn");
        this.addBlock((Supplier)TFBlocks.POTTED_DEAD_THORN, "Potted Burnt Thorn");
        this.addBlock((Supplier)TFBlocks.HEDGE, "Hedge");
        this.addBlock((Supplier)TFBlocks.ROOT_BLOCK, "Roots");
        this.addBlock((Supplier)TFBlocks.LIVEROOT_BLOCK, "Liveroots");
        this.addBlock((Supplier)TFBlocks.MANGROVE_ROOT, "Mangrove Roots");
        this.addBlock((Supplier)TFBlocks.NAGA_TROPHY, "Naga Trophy");
        this.addBlock((Supplier)TFBlocks.LICH_TROPHY, "Lich Trophy");
        this.addBlock((Supplier)TFBlocks.MINOSHROOM_TROPHY, "Minoshroom Trophy");
        this.addBlock((Supplier)TFBlocks.HYDRA_TROPHY, "Hydra Trophy");
        this.addBlock((Supplier)TFBlocks.KNIGHT_PHANTOM_TROPHY, "Knight Phantom Trophy");
        this.addBlock((Supplier)TFBlocks.UR_GHAST_TROPHY, "Ur-Ghast Trophy");
        this.addBlock((Supplier)TFBlocks.ALPHA_YETI_TROPHY, "Alpha Yeti Trophy");
        this.addBlock((Supplier)TFBlocks.SNOW_QUEEN_TROPHY, "Snow Queen Trophy");
        this.addBlock((Supplier)TFBlocks.QUEST_RAM_TROPHY, "Quest Ram Trophy");
        this.addBlock((Supplier)TFBlocks.NAGA_BOSS_SPAWNER, "Naga Boss Spawner");
        this.addBlock((Supplier)TFBlocks.LICH_BOSS_SPAWNER, "Lich Boss Spawner");
        this.addBlock((Supplier)TFBlocks.MINOSHROOM_BOSS_SPAWNER, "Minoshroom Boss Spawner");
        this.addBlock((Supplier)TFBlocks.HYDRA_BOSS_SPAWNER, "Hydra Boss Spawner");
        this.addBlock((Supplier)TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER, "Knight Phantom Boss Spawner");
        this.addBlock((Supplier)TFBlocks.UR_GHAST_BOSS_SPAWNER, "Ur-Ghast Boss Spawner");
        this.addBlock((Supplier)TFBlocks.ALPHA_YETI_BOSS_SPAWNER, "Alpha Yeti Boss Spawner");
        this.addBlock((Supplier)TFBlocks.SNOW_QUEEN_BOSS_SPAWNER, "Snow Queen Boss Spawner");
        this.addBlock((Supplier)TFBlocks.FINAL_BOSS_BOSS_SPAWNER, "Final Boss Boss Spawner");
        this.addBannerPattern("naga", "Naga Scales");
        this.addBannerPattern("lich", "Lich Crown");
        this.addBannerPattern("minoshroom", "Minoshroom Axes");
        this.addBannerPattern("hydra", "Hydra Flame");
        this.addBannerPattern("knight_phantom", "Knight Helmet");
        this.addBannerPattern("ur_ghast", "Carminite Border");
        this.addBannerPattern("alpha_yeti", "Alpha Yeti Face");
        this.addBannerPattern("snow_queen", "Snow Queen Crown");
        this.addBannerPattern("quest_ram", "Quest Ram Swirls");
        this.addBlock((Supplier)TFBlocks.ZOMBIE_SKULL_CANDLE, "Zombie Skull Candle");
        this.addBlock((Supplier)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE, "Zombie Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.SKELETON_SKULL_CANDLE, "Skeleton Skull Candle");
        this.addBlock((Supplier)TFBlocks.SKELETON_WALL_SKULL_CANDLE, "Skeleton Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.WITHER_SKELE_SKULL_CANDLE, "Wither Skeleton Skull Candle");
        this.addBlock((Supplier)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE, "Wither Skeleton Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.CREEPER_SKULL_CANDLE, "Creeper Skull Candle");
        this.addBlock((Supplier)TFBlocks.CREEPER_WALL_SKULL_CANDLE, "Creeper Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.PLAYER_SKULL_CANDLE, "Player Skull Candle");
        this.add("block.twilightforest.player_skull_candle.named", "%s's Head with Candles");
        this.addBlock((Supplier)TFBlocks.PLAYER_WALL_SKULL_CANDLE, "Player Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.PIGLIN_SKULL_CANDLE, "Piglin Skull Candle");
        this.addBlock((Supplier)TFBlocks.PIGLIN_WALL_SKULL_CANDLE, "Piglin Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.UNCRAFTING_TABLE, "Uncrafting Table");
        this.add("block.twilightforest.uncrafting_table.disabled", "This block has been disabled.");
        this.add("container.twilightforest.uncrafting_table", "Uncrafting Table");
        this.add("container.twilightforest.uncrafting_table.disabled_item", "Uncrafting this item is disabled.");
        this.add("container.twilightforest.uncrafting_table.uncrafting_disabled", "Uncrafting is disabled via config");
        this.addItem((Supplier)TFItems.NAGA_SCALE, "Naga Scale");
        this.addItem((Supplier)TFItems.NAGA_CHESTPLATE, "Naga Scale Tunic");
        this.addItem((Supplier)TFItems.NAGA_LEGGINGS, "Naga Scale Leggings");
        this.addItem((Supplier)TFItems.FORTIFICATION_SCEPTER, "Scepter of Fortification");
        this.addItem((Supplier)TFItems.LIFEDRAIN_SCEPTER, "Scepter of Life Draining");
        this.addItem((Supplier)TFItems.TWILIGHT_SCEPTER, "Scepter of Twilight");
        this.addItem((Supplier)TFItems.ZOMBIE_SCEPTER, "Zombie Scepter");
        this.add("item.twilightforest.scepter.desc", "%s charges left");
        this.addItem((Supplier)TFItems.BRITTLE_FLASK, "Brittle Potion Flask");
        this.addItem((Supplier)TFItems.GREATER_FLASK, "Greater Potion Flask");
        this.add("item.twilightforest.flask.doses", "Doses: %s/%s");
        this.add("item.twilightforest.flask.no_refill", "Cannot be refilled");
        this.addItem((Supplier)TFItems.MAGIC_PAINTING, "Magic Painting");
        this.addItem((Supplier)TFItems.ORE_METER, "Ore Meter");
        this.addItem((Supplier)TFItems.FILLED_MAGIC_MAP, "Magic Map");
        this.addItem((Supplier)TFItems.FILLED_MAZE_MAP, "Maze Map");
        this.addItem((Supplier)TFItems.FILLED_ORE_MAP, "Maze/Ore Map");
        this.addItem((Supplier)TFItems.MAGIC_MAP, "Blank Magic Map");
        this.addItem((Supplier)TFItems.MAZE_MAP, "Blank Maze Map");
        this.addItem((Supplier)TFItems.ORE_MAP, "Blank Maze/Ore Map");
        this.addItem((Supplier)TFItems.RAVEN_FEATHER, "Raven Feather");
        this.addItem((Supplier)TFItems.MAGIC_MAP_FOCUS, "Magic Map Focus");
        this.addItem((Supplier)TFItems.MAZE_MAP_FOCUS, "Maze Map Focus");
        this.addItem((Supplier)TFItems.LIVEROOT, "Liveroot");
        this.addItem((Supplier)TFItems.RAW_IRONWOOD, "Raw Ironwood");
        this.addItem((Supplier)TFItems.IRONWOOD_INGOT, "Ironwood Ingot");
        this.addArmor("ironwood", "Ironwood");
        this.addTools("ironwood", "Ironwood");
        this.addItem((Supplier)TFItems.STEELEAF_INGOT, "Steeleaf");
        this.addArmor("steeleaf", "Steeleaf");
        this.addTools("steeleaf", "Steeleaf");
        this.addItem((Supplier)TFItems.ARMOR_SHARD, "Armor Shard");
        this.addItem((Supplier)TFItems.ARMOR_SHARD_CLUSTER, "Armor Shard Cluster");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_INGOT, "Knightmetal Ingot");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_HELMET, "Knightmetal Helmet");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_CHESTPLATE, "Knightmetal Chestplate");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_LEGGINGS, "Knightmetal Greaves");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_BOOTS, "Knightmetal Boots");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_SWORD, "Knightmetal Sword");
        this.add("item.twilightforest.knightmetal_sword.desc", "Extra damage to armored targets");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_PICKAXE, "Knightmetal Pickaxe");
        this.add("item.twilightforest.knightmetal_pickaxe.desc", "Extra damage to armored targets");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_AXE, "Knightmetal Axe");
        this.add("item.twilightforest.knightmetal_axe.desc", "Extra damage to unarmored targets");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_RING, "Knightmetal Loop");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_SHIELD, "Knightmetal Shield");
        this.addItem((Supplier)TFItems.BLOCK_AND_CHAIN, "Block and Chain");
        this.addItem((Supplier)TFItems.PHANTOM_HELMET, "Phantom Helmet");
        this.addItem((Supplier)TFItems.PHANTOM_CHESTPLATE, "Phantom Chestplate");
        this.add("item.twilightforest.phantom_armor.desc", "Is never lost on death");
        this.addItem((Supplier)TFItems.FIERY_BLOOD, "Fiery Blood");
        this.addItem((Supplier)TFItems.FIERY_TEARS, "Fiery Tears");
        this.addItem((Supplier)TFItems.FIERY_INGOT, "Fiery Ingot");
        this.addArmor("fiery", "Fiery");
        this.add("item.twilightforest.fiery_armor.desc", "Burns attackers");
        this.addItem((Supplier)TFItems.FIERY_SWORD, "Fiery Sword");
        this.add("item.twilightforest.fiery_sword.desc", "Burns targets");
        this.addItem((Supplier)TFItems.FIERY_PICKAXE, "Fiery Pickaxe");
        this.add("item.twilightforest.fiery_pickaxe.desc", "Auto-smelting");
        this.addItem((Supplier)TFItems.ARCTIC_FUR, "Arctic Fur");
        this.addItem((Supplier)TFItems.ARCTIC_HELMET, "Arctic Hood");
        this.addItem((Supplier)TFItems.ARCTIC_CHESTPLATE, "Arctic Jacket");
        this.addItem((Supplier)TFItems.ARCTIC_LEGGINGS, "Arctic Leggings");
        this.addItem((Supplier)TFItems.ARCTIC_BOOTS, "Arctic Boots");
        this.add("item.twilightforest.arctic_armor.desc", "Dyeable");
        this.addItem((Supplier)TFItems.ALPHA_YETI_FUR, "Alpha Yeti Fur");
        this.addItem((Supplier)TFItems.YETI_HELMET, "Yeti Horned Helm");
        this.addItem((Supplier)TFItems.YETI_CHESTPLATE, "Yeti Jacket");
        this.addItem((Supplier)TFItems.YETI_LEGGINGS, "Yeti Leggings");
        this.addItem((Supplier)TFItems.YETI_BOOTS, "Yeti Boots");
        this.add("item.twilightforest.yeti_armor.desc", "Chills attackers");
        this.addItem((Supplier)TFItems.DIAMOND_MINOTAUR_AXE, "Diamond Minotaur Axe");
        this.addItem((Supplier)TFItems.GOLDEN_MINOTAUR_AXE, "Golden Minotaur Axe");
        this.add("item.twilightforest.minotaur_axe.desc", "Extra damage while charging");
        this.addItem((Supplier)TFItems.MAZEBREAKER_PICKAXE, "Mazebreaker");
        this.addItem((Supplier)TFItems.ICE_SWORD, "Ice Sword");
        this.addItem((Supplier)TFItems.ICE_BOMB, "Ice Bomb");
        this.addItem((Supplier)TFItems.GLASS_SWORD, "Glass Sword");
        this.add("item.twilightforest.glass_sword.desc", "Creative Mode only");
        this.addItem((Supplier)TFItems.TRIPLE_BOW, "Tri-Bow");
        this.addItem((Supplier)TFItems.SEEKER_BOW, "Seeker Bow");
        this.addItem((Supplier)TFItems.ICE_BOW, "Ice Bow");
        this.addItem((Supplier)TFItems.ENDER_BOW, "Ender Bow");
        this.addItem((Supplier)TFItems.GIANT_SWORD, "Giant's Sword");
        this.addItem((Supplier)TFItems.GIANT_PICKAXE, "Giant's Pickaxe");
        this.add("item.twilightforest.giant_pickaxe.desc", "Breaks giant blocks");
        this.addItem((Supplier)TFItems.LAMP_OF_CINDERS, "Lamp of Cinders");
        this.addItem((Supplier)TFItems.CUBE_OF_ANNIHILATION, "Cube of Annihilation");
        this.addItem((Supplier)TFItems.MOON_DIAL, "Moon Dial");
        this.add("item.twilightforest.moon_dial.phase_0", "Full Moon");
        this.add("item.twilightforest.moon_dial.phase_1", "Waning Gibbous");
        this.add("item.twilightforest.moon_dial.phase_2", "Third Quarter");
        this.add("item.twilightforest.moon_dial.phase_3", "Waning Crescent");
        this.add("item.twilightforest.moon_dial.phase_4", "New Moon");
        this.add("item.twilightforest.moon_dial.phase_5", "Waxing Crescent");
        this.add("item.twilightforest.moon_dial.phase_6", "First Quarter");
        this.add("item.twilightforest.moon_dial.phase_7", "Waxing Gibbous");
        this.add("item.twilightforest.moon_dial.phase_unknown", "Moon phase indeterminate");
        this.add("item.twilightforest.moon_dial.phase_unknown_fools", "404 moon not found");
        this.addItem((Supplier)TFItems.ORE_MAGNET, "Ore Magnet");
        this.addItem((Supplier)TFItems.CRUMBLE_HORN, "Crumble Horn");
        this.addItem((Supplier)TFItems.MOONWORM_QUEEN, "Moonworm Queen");
        this.addItem((Supplier)TFItems.PEACOCK_FEATHER_FAN, "Peacock Feather Fan");
        this.addItem((Supplier)TFItems.TRANSFORMATION_POWDER, "Transformation Powder");
        this.addItem((Supplier)TFItems.TOWER_KEY, "Tower Key");
        this.addItem((Supplier)TFItems.BORER_ESSENCE, "Borer Essence");
        this.addItem((Supplier)TFItems.CARMINITE, "Carminite");
        this.addItem((Supplier)TFItems.MAGIC_BEANS, "Magic Beans");
        this.addItem((Supplier)TFItems.CUBE_TALISMAN, "Talisman of the Cube");
        this.add("item.twilightforest.skull_candle.desc", "Has: %s %s Candle");
        this.add("item.twilightforest.skull_candle.desc.multiple", "Has: %s %s Candles");
        this.addItem((Supplier)TFItems.TORCHBERRIES, "Torchberries");
        this.addItem((Supplier)TFItems.RAW_VENISON, "Raw Venison");
        this.addItem((Supplier)TFItems.COOKED_VENISON, "Venison Steak");
        this.addItem((Supplier)TFItems.MAZE_WAFER, "Maze Wafer");
        this.addItem((Supplier)TFItems.RAW_MEEF, "Raw Meef");
        this.addItem((Supplier)TFItems.COOKED_MEEF, "Meef Steak");
        this.addItem((Supplier)TFItems.MEEF_STROGANOFF, "Meef Stroganoff");
        this.addItem((Supplier)TFItems.HYDRA_CHOP, "Hydra Chop");
        this.addItem((Supplier)TFItems.CHARM_OF_LIFE_1, "Charm of Life I");
        this.addItem((Supplier)TFItems.CHARM_OF_LIFE_2, "Charm of Life II");
        this.addItem((Supplier)TFItems.CHARM_OF_KEEPING_1, "Charm of Keeping I");
        this.addItem((Supplier)TFItems.CHARM_OF_KEEPING_2, "Charm of Keeping II");
        this.addItem((Supplier)TFItems.CHARM_OF_KEEPING_3, "Charm of Keeping III");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_RADIANCE, "Rotch Gwylt - Radiance");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_STEPS, "Rotch Gwylt - Steps");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_SUPERSTITIOUS, "Rotch Gwylt - Superstitious");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_HOME, "MrCompost - Home");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_WAYFARER, "MrCompost - Wayfarer");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_FINDINGS, "MrCompost - Findings");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_MAKER, "MrCompost - Maker");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_THREAD, "MrCompost - Thread");
        this.addMusicDisc((Supplier<Item>)TFItems.MUSIC_DISC_MOTION, "MrCompost - Motion");
        this.add("item.twilightforest.lower_goblin_knight_spawn_egg", "Goblin Knight Spawn Egg");
        this.addEntityAndEgg(TFEntities.ADHERENT, "Adherent");
        this.addEntityAndEgg(TFEntities.ALPHA_YETI, "Alpha Yeti");
        this.addEntityAndEgg(TFEntities.ARMORED_GIANT, "Armored Giant");
        this.addEntityAndEgg(TFEntities.BIGHORN_SHEEP, "Bighorn Sheep");
        this.addEntityAndEgg(TFEntities.BLOCKCHAIN_GOBLIN, "Block and Chain Goblin");
        this.addEntityAndEgg(TFEntities.BOAR, "Boar");
        this.addEntityAndEgg(TFEntities.CARMINITE_BROODLING, "Carminite Broodling");
        this.addEntityAndEgg(TFEntities.CARMINITE_GHASTGUARD, "Carminite Ghastguard");
        this.addEntityAndEgg(TFEntities.CARMINITE_GHASTLING, "Carminite Ghastling");
        this.addEntityAndEgg(TFEntities.CARMINITE_GOLEM, "Carminite Golem");
        this.addEntityAndEgg(TFEntities.DEATH_TOME, "Death Tome");
        this.addEntityAndEgg(TFEntities.DEER, "Deer");
        this.addEntityAndEgg(TFEntities.DWARF_RABBIT, "Dwarf Rabbit");
        this.addEntityAndEgg(TFEntities.FIRE_BEETLE, "Fire Beetle");
        this.addEntityAndEgg(TFEntities.GIANT_MINER, "Giant Miner");
        this.addEntityAndEgg(TFEntities.HARBINGER_CUBE, "Harbinger Cube");
        this.addEntityAndEgg(TFEntities.HEDGE_SPIDER, "Hedge Spider");
        this.addEntityAndEgg(TFEntities.HELMET_CRAB, "Helmet Crab");
        this.addEntityAndEgg(TFEntities.HOSTILE_WOLF, "Hostile Wolf");
        this.addEntityAndEgg(TFEntities.HYDRA, "Hydra");
        this.addEntityAndEgg(TFEntities.ICE_CRYSTAL, "Ice Crystal");
        this.addEntityAndEgg(TFEntities.KING_SPIDER, "King Spider");
        this.addEntityAndEgg(TFEntities.KNIGHT_PHANTOM, "Knight Phantom");
        this.addEntityAndEgg(TFEntities.KOBOLD, "Kobold");
        this.addEntityAndEgg(TFEntities.LICH, "Lich");
        this.addEntityAndEgg(TFEntities.MAZE_SLIME, "Maze Slime");
        this.addEntityAndEgg(TFEntities.MINOSHROOM, "Minoshroom");
        this.addEntityAndEgg(TFEntities.MINOTAUR, "Minotaur");
        this.addEntityAndEgg(TFEntities.MIST_WOLF, "Mist Wolf");
        this.addEntityAndEgg(TFEntities.MOSQUITO_SWARM, "Mosquito Swarm");
        this.addEntityAndEgg(TFEntities.NAGA, "Naga");
        this.addEntityAndEgg(TFEntities.PENGUIN, "Penguin");
        this.addEntityAndEgg(TFEntities.PINCH_BEETLE, "Pinch Beetle");
        this.addEntityAndEgg(TFEntities.QUEST_RAM, "Quest Ram");
        this.addEntityAndEgg(TFEntities.RAVEN, "Raven");
        this.addEntityAndEgg(TFEntities.REDCAP, "Redcap");
        this.addEntityAndEgg(TFEntities.REDCAP_SAPPER, "Redcap Sapper");
        this.addEntityAndEgg(TFEntities.SKELETON_DRUID, "Skeleton Druid");
        this.addEntityAndEgg(TFEntities.SLIME_BEETLE, "Slime Beetle");
        this.addEntityAndEgg(TFEntities.SNOW_GUARDIAN, "Snow Guardian");
        this.addEntityAndEgg(TFEntities.SNOW_QUEEN, "Snow Queen");
        this.addEntityAndEgg(TFEntities.SQUIRREL, "Squirrel");
        this.addEntityAndEgg(TFEntities.STABLE_ICE_CORE, "Stable Ice Core");
        this.addEntityAndEgg(TFEntities.SWARM_SPIDER, "Swarm Spider");
        this.addEntityAndEgg(TFEntities.TINY_BIRD, "Tiny Bird");
        this.addEntityAndEgg(TFEntities.TOWERWOOD_BORER, "Towerwood Borer");
        this.addEntityAndEgg(TFEntities.TROLL, "Troll");
        this.addEntityAndEgg(TFEntities.UNSTABLE_ICE_CORE, "Unstable Ice Core");
        this.addEntityAndEgg(TFEntities.UR_GHAST, "Ur-Ghast");
        this.addEntityAndEgg(TFEntities.WINTER_WOLF, "Winter Wolf");
        this.addEntityAndEgg(TFEntities.WRAITH, "Wraith");
        this.addEntityAndEgg(TFEntities.YETI, "Yeti");
        this.addEntityType((Supplier)TFEntities.LICH_MINION, "Lich Minion");
        this.addEntityType((Supplier)TFEntities.LOYAL_ZOMBIE, "Loyal Zombie");
        this.addEntityType((Supplier)TFEntities.LOWER_GOBLIN_KNIGHT, "Lower Goblin Knight");
        this.addEntityType((Supplier)TFEntities.RISING_ZOMBIE, "Zombie");
        this.addEntityType((Supplier)TFEntities.ROVING_CUBE, "Roving Cube");
        this.addEntityType((Supplier)TFEntities.UPPER_GOBLIN_KNIGHT, "Upper Goblin Knight");
        this.addEntityType((Supplier)TFEntities.ICE_SNOWBALL, "Ice Snowball");
        this.addEntityType((Supplier)TFEntities.ICE_ARROW, "Ice Arrow");
        this.addEntityType((Supplier)TFEntities.SEEKER_ARROW, "Seeker Arrow");
        this.addEntityType((Supplier)TFEntities.MOONWORM_SHOT, "Moonworm");
        this.addEntityType((Supplier)TFEntities.NATURE_BOLT, "Nature Bolt");
        this.addEntityType((Supplier)TFEntities.SLIME_BLOB, "Slime Blob");
        this.addEntityType((Supplier)TFEntities.TOME_BOLT, "Death Tome Bolt");
        this.addEntityType((Supplier)TFEntities.WAND_BOLT, "Twilight Scepter Bolt");
        this.addEntityType((Supplier)TFEntities.LICH_BOLT, "Lich Bolt");
        this.addEntityType((Supplier)TFEntities.LICH_BOMB, "Explosive Lich Bolt");
        this.addEntityType((Supplier)TFEntities.HYDRA_MORTAR, "Hydra Mortar");
        this.addEntityType((Supplier)TFEntities.FALLING_ICE, "Falling Ice");
        this.addEntityType((Supplier)TFEntities.THROWN_WEP, "Thrown Weapon");
        this.addEntityType((Supplier)TFEntities.CHARM_EFFECT, "Charm Effect");
        this.addEntityType((Supplier)TFEntities.CHAIN_BLOCK, "Block and Chain");
        this.addEntityType((Supplier)TFEntities.CUBE_OF_ANNIHILATION, "Cube of Annihilation");
        this.addEntityType((Supplier)TFEntities.THROWN_BLOCK, "Thrown Block");
        this.addEntityType((Supplier)TFEntities.SLIDER, "Moving Slide Trap");
        this.addEntityType((Supplier)TFEntities.PROTECTION_BOX, "Progression Protection Box");
        this.addEntityType((Supplier)TFEntities.BOAT, "Boat");
        this.addEntityType((Supplier)TFEntities.CHEST_BOAT, "Boat with Chest");
        this.addEntityType((Supplier)TFEntities.MAGIC_PAINTING, "Magic Painting");
        this.addSubtitle(TFSounds.ACID_RAIN_BURNS, "Acid rain scalds");
        this.addSubtitle(TFSounds.ALPHA_YETI_ALERT, "Alpha Yeti takes notice");
        this.addSubtitle(TFSounds.ALPHA_YETI_DEATH, "Alpha Yeti dies");
        this.addSubtitle(TFSounds.ALPHA_YETI_GRAB, "Alpha Yeti grabs");
        this.addSubtitle(TFSounds.ALPHA_YETI_GROWL, "Alpha Yeti growls");
        this.addSubtitle(TFSounds.ALPHA_YETI_HURT, "Alpha Yeti hurts");
        this.addSubtitle(TFSounds.ALPHA_YETI_ICE, "Alpha Yeti throws ice");
        this.addSubtitle(TFSounds.ALPHA_YETI_PANT, "Alpha Yeti pants");
        this.addSubtitle(TFSounds.ALPHA_YETI_ROAR, "Alpha Yeti roars");
        this.addSubtitle(TFSounds.ALPHA_YETI_THROW, "Alpha Yeti throws");
        this.addSubtitle(TFSounds.BIGHORN_SHEEP_AMBIENT, "Bighorn Sheep bleats");
        this.addSubtitle(TFSounds.BIGHORN_SHEEP_DEATH, "Bighorn Sheep dies");
        this.addSubtitle(TFSounds.BIGHORN_SHEEP_HURT, "Bighorn Sheep hurts");
        this.addSubtitle(TFSounds.BLOCKCHAIN_GOBLIN_AMBIENT, "Block and Chain Goblin chuckles");
        this.addSubtitle(TFSounds.BLOCKCHAIN_GOBLIN_DEATH, "Block and Chain Goblin dies");
        this.addSubtitle(TFSounds.BLOCKCHAIN_GOBLIN_HURT, "Block and Chain Goblin screams");
        this.addSubtitle(TFSounds.BOAR_AMBIENT, "Boar oinks");
        this.addSubtitle(TFSounds.BOAR_DEATH, "Boar dies");
        this.addSubtitle(TFSounds.BOAR_HURT, "Boar hurts");
        this.addSubtitle(TFSounds.CARMINITE_BROODLING_AMBIENT, "Carminite Broodling hisses");
        this.addSubtitle(TFSounds.CARMINITE_BROODLING_DEATH, "Carminite Broodling dies");
        this.addSubtitle(TFSounds.CARMINITE_BROODLING_HURT, "Carminite Broodling hurts");
        this.addSubtitle(TFSounds.CARMINITE_GHASTGUARD_AMBIENT, "Carminite Ghastguard cries");
        this.addSubtitle(TFSounds.CARMINITE_GHASTGUARD_DEATH, "Carminite Ghastguard dies");
        this.addSubtitle(TFSounds.CARMINITE_GHASTGUARD_HURT, "Carminite Ghastguard screams");
        this.addSubtitle(TFSounds.CARMINITE_GHASTGUARD_SHOOT, "Carminite Ghastguard shoots");
        this.addSubtitle(TFSounds.CARMINITE_GHASTLING_AMBIENT, "Carminite Ghastling cries");
        this.addSubtitle(TFSounds.CARMINITE_GHASTLING_DEATH, "Carminite Ghastling dies");
        this.addSubtitle(TFSounds.CARMINITE_GHASTLING_HURT, "Carminite Ghastling screams");
        this.addSubtitle(TFSounds.CARMINITE_GHASTLING_SHOOT, "Carminite Ghastling shoots");
        this.addSubtitle(TFSounds.CARMINITE_GOLEM_ATTACK, "Carminite Golem swings");
        this.addSubtitle(TFSounds.CARMINITE_GOLEM_DEATH, "Carminite Golem dies");
        this.addSubtitle(TFSounds.CARMINITE_GOLEM_HURT, "Carminite Golem hurts");
        this.addSubtitle(TFSounds.DEATH_TOME_AMBIENT, "Death Tome flips pages");
        this.addSubtitle(TFSounds.DEATH_TOME_DEATH, "Death Tome falls apart");
        this.addSubtitle(TFSounds.DEATH_TOME_HURT, "Death Tome creases");
        this.addSubtitle(TFSounds.DEER_AMBIENT, "Deer moos");
        this.addSubtitle(TFSounds.DEER_DEATH, "Deer dies");
        this.addSubtitle(TFSounds.DEER_HURT, "Deer hurts");
        this.addSubtitle(TFSounds.DWARF_RABBIT_AMBIENT, "Dwarf Rabbit squeaks");
        this.addSubtitle(TFSounds.DWARF_RABBIT_DEATH, "Dwarf Rabbit dies");
        this.addSubtitle(TFSounds.DWARF_RABBIT_HURT, "Dwarf Rabbit hurts");
        this.addSubtitle(TFSounds.SKELETON_DRUID_AMBIENT, "Skeleton Druid rattles");
        this.addSubtitle(TFSounds.SKELETON_DRUID_DEATH, "Skeleton Druid dies");
        this.addSubtitle(TFSounds.SKELETON_DRUID_HURT, "Skeleton Druid hurts");
        this.addSubtitle(TFSounds.SKELETON_DRUID_SHOOT, "Skeleton Druid shoots");
        this.addSubtitle(TFSounds.FIRE_BEETLE_DEATH, "Fire Beetle dies");
        this.addSubtitle(TFSounds.FIRE_BEETLE_HURT, "Fire Beetle hurts");
        this.addSubtitle(TFSounds.FIRE_BEETLE_SHOOT, "Fire Beetle spews flames");
        this.addSubtitle(TFSounds.GOBLIN_KNIGHT_AMBIENT, "Goblin Knight chuckles");
        this.addSubtitle(TFSounds.GOBLIN_KNIGHT_DEATH, "Goblin Knight groans in agony");
        this.addSubtitle(TFSounds.GOBLIN_KNIGHT_HURT, "Goblin Knight screeches in pain");
        this.addSubtitle(TFSounds.GOBLIN_KNIGHT_MUFFLED_AMBIENT, "Muffled Goblin Knight chuckles");
        this.addSubtitle(TFSounds.GOBLIN_KNIGHT_MUFFLED_DEATH, "Muffled Goblin Knight groans in agony");
        this.addSubtitle(TFSounds.GOBLIN_KNIGHT_MUFFLED_HURT, "Muffled Goblin Knight screeches in pain");
        this.addSubtitle(TFSounds.HEDGE_SPIDER_AMBIENT, "Hedge Spider hisses");
        this.addSubtitle(TFSounds.HEDGE_SPIDER_DEATH, "Hedge Spider dies");
        this.addSubtitle(TFSounds.HEDGE_SPIDER_HURT, "Hedge Spider hurts");
        this.addSubtitle(TFSounds.HELMET_CRAB_DEATH, "Helmet Crab dies");
        this.addSubtitle(TFSounds.HELMET_CRAB_HURT, "Helmet Crab hurts");
        this.addSubtitle(TFSounds.HOSTILE_WOLF_AMBIENT, "Hostile Wolf growls");
        this.addSubtitle(TFSounds.HOSTILE_WOLF_DEATH, "Hostile Wolf dies");
        this.addSubtitle(TFSounds.HOSTILE_WOLF_HURT, "Hostile Wolf hurts");
        this.addSubtitle(TFSounds.HOSTILE_WOLF_TARGET, "Hostile Wolf takes notice");
        this.addSubtitle(TFSounds.HYDRA_DEATH, "Hydra roars in defeat");
        this.addSubtitle(TFSounds.HYDRA_GROWL, "Hydra growls");
        this.addSubtitle(TFSounds.HYDRA_HURT, "Hydra hurts");
        this.addSubtitle(TFSounds.HYDRA_ROAR, "Hydra roars");
        this.addSubtitle(TFSounds.HYDRA_SHOOT, "Hydra shoots mortar");
        this.addSubtitle(TFSounds.HYDRA_SHOOT_FIRE, "Hydra shoots fire");
        this.addSubtitle(TFSounds.HYDRA_WARN, "Hydra prepares to bite");
        this.addSubtitle(TFSounds.ICE_CORE_AMBIENT, "Ice Core crackles");
        this.addSubtitle(TFSounds.ICE_CORE_DEATH, "Ice Core dies");
        this.addSubtitle(TFSounds.ICE_CORE_HURT, "Ice Core hurts");
        this.addSubtitle(TFSounds.ICE_CORE_SHOOT, "Ice Core shoots snowball");
        this.addSubtitle(TFSounds.KING_SPIDER_AMBIENT, "King Spider hisses");
        this.addSubtitle(TFSounds.KING_SPIDER_DEATH, "King Spider dies");
        this.addSubtitle(TFSounds.KING_SPIDER_HURT, "King Spider hurts");
        this.addSubtitle(TFSounds.KNIGHT_PHANTOM_AMBIENT, "Knight Phantom gasps");
        this.addSubtitle(TFSounds.KNIGHT_PHANTOM_DEATH, "Knight Phantom dies");
        this.addSubtitle(TFSounds.KNIGHT_PHANTOM_HURT, "Knight Phantom hurts");
        this.addSubtitle(TFSounds.KNIGHT_PHANTOM_THROW_PICK, "Knight Phantom throws axe");
        this.addSubtitle(TFSounds.KNIGHT_PHANTOM_THROW_AXE, "Knight Phantom throws pickaxe");
        this.addSubtitle(TFSounds.KOBOLD_AMBIENT, "Kobold grumbles");
        this.addSubtitle(TFSounds.KOBOLD_DEATH, "Kobold dies");
        this.addSubtitle(TFSounds.KOBOLD_HURT, "Kobold hurts");
        this.addSubtitle(TFSounds.KOBOLD_MUNCH, "Kobold munches on food");
        this.addSubtitle(TFSounds.LICH_AMBIENT, "Lich breathes");
        this.addSubtitle(TFSounds.LICH_CLONE_HURT, "Lich shadow clone bypasses attack");
        this.addSubtitle(TFSounds.LICH_DEATH, "Lich dies");
        this.addSubtitle(TFSounds.LICH_HURT, "Lich hurts");
        this.addSubtitle(TFSounds.LICH_POP_MOB, "Lich absorbs mob");
        this.addSubtitle(TFSounds.LICH_SHOOT, "Lich shoots");
        this.addSubtitle(TFSounds.LICH_TELEPORT, "Lich teleports");
        this.addSubtitle(TFSounds.LOYAL_ZOMBIE_AMBIENT, "Loyal Zombie groans");
        this.addSubtitle(TFSounds.LOYAL_ZOMBIE_DEATH, "Loyal Zombie dies");
        this.addSubtitle(TFSounds.LOYAL_ZOMBIE_HURT, "Loyal Zombie hurts");
        this.addSubtitle(TFSounds.LOYAL_ZOMBIE_SUMMON, "Loyal Zombie summoned");
        this.addSubtitle(TFSounds.MAZE_SLIME_DEATH, "Maze Slime dies");
        this.addSubtitle(TFSounds.MAZE_SLIME_HURT, "Maze Slime hurts");
        this.addSubtitle(TFSounds.MAZE_SLIME_SQUISH, "Maze Slime squishes");
        this.addSubtitle(TFSounds.MINION_AMBIENT, "Lich Minion groans");
        this.addSubtitle(TFSounds.MINION_DEATH, "Lich Minion dies");
        this.addSubtitle(TFSounds.MINION_HURT, "Lich Minion hurts");
        this.addSubtitle(TFSounds.MINION_SUMMON, "Lich summons new Minion");
        this.addSubtitle(TFSounds.MINOSHROOM_AMBIENT, "Minoshroom moos");
        this.addSubtitle(TFSounds.MINOSHROOM_ATTACK, "Minoshroom attacks");
        this.addSubtitle(TFSounds.MINOSHROOM_DEATH, "Minoshroom dies");
        this.addSubtitle(TFSounds.MINOSHROOM_HURT, "Minoshroom hurts");
        this.addSubtitle(TFSounds.MINOSHROOM_SLAM, "Minoshroom slams ground");
        this.addSubtitle(TFSounds.MINOTAUR_AMBIENT, "Minotaur moos");
        this.addSubtitle(TFSounds.MINOTAUR_ATTACK, "Minotaur attacks");
        this.addSubtitle(TFSounds.MINOTAUR_DEATH, "Minotaur dies");
        this.addSubtitle(TFSounds.MINOTAUR_HURT, "Minotaur hurts");
        this.addSubtitle(TFSounds.MIST_WOLF_AMBIENT, "Mist Wolf growls");
        this.addSubtitle(TFSounds.MIST_WOLF_DEATH, "Mist Wolf dies");
        this.addSubtitle(TFSounds.MIST_WOLF_HURT, "Mist Wolf hurts");
        this.addSubtitle(TFSounds.MIST_WOLF_TARGET, "Mist Wolf takes notice");
        this.addSubtitle(TFSounds.MOSQUITO, "Mosquitoes buzz");
        this.addSubtitle(TFSounds.NAGA_HISS, "Naga hisses");
        this.addSubtitle(TFSounds.NAGA_HURT, "Naga hurts");
        this.addSubtitle(TFSounds.NAGA_RATTLE, "Naga rattles");
        this.addSubtitle(TFSounds.PINCH_BEETLE_DEATH, "Pinch Beetle dies");
        this.addSubtitle(TFSounds.PINCH_BEETLE_HURT, "Pinch Beetle hurts");
        this.addSubtitle(TFSounds.QUEST_RAM_AMBIENT, "Quest Ram bleats");
        this.addSubtitle(TFSounds.QUEST_RAM_DEATH, "Quest Ram dies");
        this.addSubtitle(TFSounds.QUEST_RAM_HURT, "Quest Ram hurts");
        this.addSubtitle(TFSounds.RAVEN_CAW, "Raven caws");
        this.addSubtitle(TFSounds.RAVEN_SQUAWK, "Raven squawks in pain");
        this.addSubtitle(TFSounds.REDCAP_AMBIENT, "Redcap chuckles");
        this.addSubtitle(TFSounds.REDCAP_DEATH, "Redcap groans in agony");
        this.addSubtitle(TFSounds.REDCAP_HURT, "Redcap screeches in pain");
        this.addSubtitle(TFSounds.SHIELD_ADD, "Fortification Shield spawns");
        this.addSubtitle(TFSounds.SHIELD_BREAK, "Fortification Shield breaks");
        this.addSubtitle(TFSounds.SLIME_BEETLE_DEATH, "Slime Beetle dies");
        this.addSubtitle(TFSounds.SLIME_BEETLE_HURT, "Slime Beetle hurts");
        this.addSubtitle(TFSounds.SLIME_BEETLE_SQUISH, "Slime Beetle shoots");
        this.addSubtitle(TFSounds.SNOW_GUARDIAN_AMBIENT, "Snow Guardian crackles");
        this.addSubtitle(TFSounds.SNOW_GUARDIAN_DEATH, "Snow Guardian dies");
        this.addSubtitle(TFSounds.SNOW_GUARDIAN_HURT, "Snow Guardian hurts");
        this.addSubtitle(TFSounds.SNOW_QUEEN_AMBIENT, "Snow Queen crackles");
        this.addSubtitle(TFSounds.SNOW_QUEEN_ATTACK, "Snow Queen attacks");
        this.addSubtitle(TFSounds.SNOW_QUEEN_BREAK, "Snow Queen deflects attack");
        this.addSubtitle(TFSounds.SNOW_QUEEN_DEATH, "Snow Queen dies");
        this.addSubtitle(TFSounds.SNOW_QUEEN_HURT, "Snow Queen hurts");
        this.addSubtitle(TFSounds.SWARM_SPIDER_AMBIENT, "Swarm Spider hisses");
        this.addSubtitle(TFSounds.SWARM_SPIDER_DEATH, "Swarm Spider dies");
        this.addSubtitle(TFSounds.SWARM_SPIDER_HURT, "Swarm Spider hurts");
        this.addSubtitle(TFSounds.TEAR_BREAK, "Ur-Ghast tear shatters");
        this.addSubtitle(TFSounds.TINY_BIRD_CHIRP, "Bird chirps");
        this.addSubtitle(TFSounds.TINY_BIRD_HURT, "Bird squeaks in pain");
        this.addSubtitle(TFSounds.TINY_BIRD_SONG, "Bird sings");
        this.addSubtitle(TFSounds.TINY_BIRD_TAKEOFF, "Bird takes off");
        this.addSubtitle(TFSounds.TROLL_THROWS_ROCK, "Troll chucks block");
        this.addSubtitle(TFSounds.UR_GHAST_AMBIENT, "Ur-Ghast cries");
        this.addSubtitle(TFSounds.UR_GHAST_DEATH, "Ur-Ghast dies");
        this.addSubtitle(TFSounds.UR_GHAST_HURT, "Ur-Ghast screams");
        this.addSubtitle(TFSounds.UR_GHAST_SHOOT, "Ur-Ghast shoots");
        this.addSubtitle(TFSounds.UR_GHAST_TANTRUM, "Ur-Ghast wails");
        this.addSubtitle(TFSounds.WINTER_WOLF_AMBIENT, "Winter Wolf growls");
        this.addSubtitle(TFSounds.WINTER_WOLF_DEATH, "Winter Wolf dies");
        this.addSubtitle(TFSounds.WINTER_WOLF_HURT, "Winter Wolf hurts");
        this.addSubtitle(TFSounds.WINTER_WOLF_SHOOT, "Winter Wolf shoots");
        this.addSubtitle(TFSounds.WINTER_WOLF_TARGET, "Winter Wolf takes notice");
        this.addSubtitle(TFSounds.WRAITH_AMBIENT, "Wraith gasps");
        this.addSubtitle(TFSounds.WRAITH_DEATH, "Wraith dies");
        this.addSubtitle(TFSounds.WRAITH_HURT, "Wraith hurts");
        this.addSubtitle(TFSounds.YETI_DEATH, "Yeti dies");
        this.addSubtitle(TFSounds.YETI_GRAB, "Yeti grabs");
        this.addSubtitle(TFSounds.YETI_GROWL, "Yeti growls");
        this.addSubtitle(TFSounds.YETI_HURT, "Yeti hurts");
        this.addSubtitle(TFSounds.YETI_THROW, "Yeti throws");
        this.addSubtitle(TFSounds.ALPHA_YETI_PARROT, "Parrot coldly growls");
        this.addSubtitle(TFSounds.CARMINITE_GOLEM_PARROT, "Parrot thunks");
        this.addSubtitle(TFSounds.DEATH_TOME_PARROT, "Parrot makes book noises");
        this.addSubtitle(TFSounds.HOSTILE_WOLF_PARROT, "Parrot growls");
        this.addSubtitle(TFSounds.HYDRA_PARROT, "Parrot roars");
        this.addSubtitle(TFSounds.ICE_CORE_PARROT, "Parrot crackles");
        this.addSubtitle(TFSounds.KOBOLD_PARROT, "Parrot grumbles");
        this.addSubtitle(TFSounds.MINOTAUR_PARROT, "Parrot moos angrily");
        this.addSubtitle(TFSounds.MOSQUITO_PARROT, "Parrot buzzes");
        this.addSubtitle(TFSounds.NAGA_PARROT, "Parrot rattles");
        this.addSubtitle(TFSounds.REDCAP_PARROT, "Parrot chuckles");
        this.addSubtitle(TFSounds.WRAITH_PARROT, "Parrot gasps");
        this.addSubtitle(TFSounds.BEANSTALK_GROWTH, "Ground rumbles");
        this.addSubtitle(TFSounds.BLOCK_ANNIHILATED, "Block dissolves");
        this.addSubtitle(TFSounds.BOSS_CHEST_APPEAR, "Boss Chest appears");
        this.addSubtitle(TFSounds.BUG_SQUISH, "Bug gets squished :(");
        this.addSubtitle(TFSounds.BUILDER_CREATE, "Carminite Builder creates block");
        this.addSubtitle(TFSounds.BUILDER_OFF, "Carminite Builder deactivates");
        this.addSubtitle(TFSounds.BUILDER_ON, "Carminite Builder activates");
        this.addSubtitle(TFSounds.BUILDER_REPLACE, "Built Block expires");
        this.addSubtitle(TFSounds.CASKET_CLOSE, "Keepsake Casket closes");
        this.addSubtitle(TFSounds.CASKET_LOCKED, "Keepsake Casket clicks");
        this.addSubtitle(TFSounds.CASKET_OPEN, "Keepsake Casket opens");
        this.addSubtitle(TFSounds.CASKET_REPAIR, "Keepsake Casket repaired");
        this.addSubtitle(TFSounds.CICADA, "Cicada screams");
        this.addSubtitle(TFSounds.DOOR_ACTIVATED, "Castle Door clicks");
        this.addSubtitle(TFSounds.DOOR_REAPPEAR, "Castle Door reappears");
        this.addSubtitle(TFSounds.DOOR_VANISH, "Castle Door vanishes");
        this.addSubtitle(TFSounds.GHAST_TRAP_AMBIENT, "Ghast Trap dings");
        this.addSubtitle(TFSounds.GHAST_TRAP_ON, "Ghast Trap buzzes");
        this.addSubtitle(TFSounds.GHAST_TRAP_SPINDOWN, "Ghast Trap shuts off");
        this.addSubtitle(TFSounds.GHAST_TRAP_WARMUP, "Ghast Trap warms up");
        this.addSubtitle(TFSounds.JET_ACTIVE, "Fire Jet flares");
        this.addSubtitle(TFSounds.JET_POP, "Fire Jet pops");
        this.addSubtitle(TFSounds.JET_START, "Fire Jet activates");
        this.addSubtitle(TFSounds.LOCKED_VANISHING_BLOCK, "Towerwood door clicks");
        this.addSubtitle(TFSounds.PEDESTAL_ACTIVATE, "Trophy Pedestal accepts trophy");
        this.addSubtitle(TFSounds.PICKED_TORCHBERRIES, "Torchberries pop");
        this.addSubtitle(TFSounds.PORTAL_WHOOSH, "Twilight Forest Portal beckons");
        this.addSubtitle(TFSounds.REACTOR_AMBIENT, "Carminite Reactor whooshes");
        this.addSubtitle(TFSounds.REAPPEAR_BLOCK, "Reappearing Block reappears");
        this.addSubtitle(TFSounds.REAPPEAR_POOF, "Reappearing Block disappears");
        this.addSubtitle(TFSounds.SLIDER, "Sliding Trap creaks");
        this.addSubtitle(TFSounds.SMOKER_START, "Smoker activates");
        this.addSubtitle(TFSounds.TIME_CORE, "Tree of Time ticks");
        this.addSubtitle(TFSounds.TRANSFORMATION_CORE, "Tree of Transformation hums");
        this.addSubtitle(TFSounds.UNLOCK_VANISHING_BLOCK, "Towerwood door unlocks");
        this.addSubtitle(TFSounds.VANISHING_BLOCK, "Vanishing Block vanishes");
        this.addSubtitle(TFSounds.BLOCK_AND_CHAIN_COLLIDE, "Block and Chain hits block");
        this.addSubtitle(TFSounds.BLOCK_AND_CHAIN_FIRED, "Block and Chain fires");
        this.addSubtitle(TFSounds.BLOCK_AND_CHAIN_HIT, "Block and Chain hits entity");
        this.addSubtitle(TFSounds.BRITTLE_FLASK_BREAK, "Brittle Flask shatters");
        this.addSubtitle(TFSounds.BRITTLE_FLASK_CRACK, "Brittle Flask cracks");
        this.addSubtitle(TFSounds.CHARM_KEEP, "Charm of Keeping returns items");
        this.addSubtitle(TFSounds.CHARM_LIFE, "Charm of Keeping regenerates");
        this.addSubtitle(TFSounds.FAN_WHOOSH, "Peacock Feather Fan blows");
        this.addSubtitle(TFSounds.FLASK_FILL, "Potion Flask fills");
        this.addSubtitle(TFSounds.GLASS_SWORD_BREAK, "Glass Sword shatters");
        this.addSubtitle(TFSounds.ICE_BOMB_FIRED, "Ice Bomb thrown");
        this.addSubtitle(TFSounds.KNIGHTMETAL_EQUIP, "Knightmetal Armor clanks");
        this.addSubtitle(TFSounds.LAMP_BURN, "Lamp of Cinders ignites area");
        this.addSubtitle(TFSounds.MAGNET_GRAB, "Ore Magnet pulls up ore");
        this.addSubtitle(TFSounds.METAL_SHIELD_SHATTERS, "Metal Shield shatters");
        this.addSubtitle(TFSounds.MOONWORM_SQUISH, "Moonworm fires");
        this.addSubtitle(TFSounds.POWDER_USE, "Mob Transforms");
        this.addSubtitle(TFSounds.SCEPTER_DRAIN, "Life Scepter drains");
        this.addSubtitle(TFSounds.SCEPTER_PEARL, "Twilight Scepter throws pearl");
        this.addSubtitle(TFSounds.WOOD_SHIELD_SHATTERS, "Wooden Shield shatters");
        this.addDeathMessage("ghastTear", "%1$s was scalded by fiery tears");
        this.addDeathMessage("ghastTear.player", "%1$s was scalded by fiery tears while escaping %2$s");
        this.addDeathMessage("hydraFire", "%1$s was roasted alive by the Hydra");
        this.addDeathMessage("hydraFire.player", "%1$s was roasted alive by the Hydra while escaping %2$s");
        this.addDeathMessage("hydraBite", "%1$s's skin was ripped off by the Hydra");
        this.addDeathMessage("hydraBite.player", "%1$s's skin was ripped off by the Hydra while escaping %2$s");
        this.addDeathMessage("lichBolt", "The Lich's aim was better than %1$s");
        this.addDeathMessage("lichBolt.player", "The Lich and %2$s had better aim than %1$s");
        this.addDeathMessage("lichBomb", "%1$s succumbed to the Lich's explosive magic");
        this.addDeathMessage("lichBomb.player", "%1$s succumbed to the Lich's explosive magic while escaping %2$s");
        this.addDeathMessage("chillingBreath", "%1$s was frozen to death by the Snow Queen");
        this.addDeathMessage("chillingBreath.player", "%1$s was frozen to death by the Snow Queen while escaping %2$s");
        this.addDeathMessage("squish", "%1$s was squashed by the Snow Queen");
        this.addDeathMessage("squish.player", "%1$s was squashed by the Snow Queen while escaping %2$s");
        this.addDeathMessage("thrownAxe", "%1$s was decapitated by a thrown axe");
        this.addDeathMessage("thrownAxe.player", "%1$s was decapitated by a thrown axe while escaping %2$s");
        this.addDeathMessage("thrownPickaxe", "%1$s was decapitated by a thrown pickaxe");
        this.addDeathMessage("thrownPickaxe.player", "%1$s was decapitated by a thrown pickaxe while escaping %2$s");
        this.addDeathMessage("fireJet", "%1$s accidentally walked into a Fire Jet");
        this.addDeathMessage("fireJet.player", "%1$s accidentally walked into a Fire Jet while escaping %2$s");
        this.addDeathMessage("reactor", "%1$s stood too close to a Carminite Reactor");
        this.addDeathMessage("reactor.player", "%1$s stood too close to a Carminite Reactor while escaping %2$s");
        this.addDeathMessage("slider", "%1$s was sliced up by a Sliding Trap");
        this.addDeathMessage("slider.player", "%1$s was sliced up by a Sliding Trap while escaping %2$s");
        this.addDeathMessage("thorns", "%1$s walked into some thorns");
        this.addDeathMessage("thorns.player", "%1$s walked into some thorns while escaping %2$s");
        this.addDeathMessage("knightmetal", "%1$s was skewered by a Knightmetal block");
        this.addDeathMessage("knightmetal.player", "%1$s was skewered by a Knightmetal block while escaping %2$s");
        this.addDeathMessage("fiery", "%1$s walked onto a Fiery block");
        this.addDeathMessage("fiery.player", "%1$s walked onto a Fiery block while escaping %2$s");
        this.addDeathMessage("thrownBlock", "%1$s was squashed by a thrown block");
        this.addDeathMessage("thrownBlock.player", "%1$s was squashed by a thrown block while escaping %2$s");
        this.addDeathMessage("expired", "%1$s's life expired");
        this.addDeathMessage("expired.player", "%1$s's life expired");
        this.addDeathMessage("axing", "%1$s was chopped up by %2$s");
        this.addDeathMessage("axing.item", "%1$s was chopped up by %2$s using %3$s");
        this.addDeathMessage("moonworm", "%1$s was shot by Moonworm");
        this.addDeathMessage("ant", "%1$s was squashed like an ant by %2$s");
        this.addDeathMessage("ant.item", "%1$s was squashed like an ant by %2$s holding %3$s");
        this.addDeathMessage("haunt", "%1$s joined the %2$s's haunt");
        this.addDeathMessage("haunt.item", "%1$s joined the %2$s's haunt after being killed by %3$s");
        this.addDeathMessage("clamped", "%1$s was squeezed to death by %2$s");
        this.addDeathMessage("clamped.item", "%1$s was squeezed to death by %2$s using %3$s");
        this.addDeathMessage("scorched", "%1$s was scorched by %2$s");
        this.addDeathMessage("scorched.item", "%1$s was scorched by %2$s using %3$s");
        this.addDeathMessage("frozen", "%1$s was frozen by %2$s using an Ice Bomb");
        this.addDeathMessage("frozen.item", "%1$s was frozen by %2$s using %3$s");
        this.addDeathMessage("spiked", "%1$s was skewered by %2$s");
        this.addDeathMessage("spiked.item", "%1$s was skewered by %2$s using %3$s");
        this.addDeathMessage("leafBrain", "%1$s's brain was turned into leaves by %2$s");
        this.addDeathMessage("leafBrain.item", "%1$s's brain was turned into leaves by %2$s using %3$s");
        this.addDeathMessage("lostWords", "%1$s was at a loss for words after being killed by %2$s");
        this.addDeathMessage("lostWords.item", "%1$s was at a loss for words after being killed by %2$s using %3$s");
        this.addDeathMessage("schooled", "%1$s was schooled by %2$s");
        this.addDeathMessage("schooled.item", "%1$s was schooled by %2$s using %3$s");
        this.addDeathMessage("snowballFight", "%1$s lost a snowball fight to %2$s");
        this.addDeathMessage("snowballFight.item", "%1$s lost a snowball fight to %2$s using %3$s");
        this.addDeathMessage("lifedrain", "%1$s's life was drained by %2$s");
        this.addDeathMessage("lifedrain.item", "%1$s's life was drained by %2$s using %3$s");
        this.addDeathMessage("yeeted", "%1$s was yeeted for the last time");
        this.addDeathMessage("yeeted.entity", "%1$s was yeeted for the last time by %2$s");
        this.addDeathMessage("yeeted.item", "%1$s was yeeted for the last time by %2$s while somehow holding %3$s");
        this.addDeathMessage("acid_rain", "%1$s went dancing in the acid rain");
        this.addStat("blocks_crumbled", "Blocks Crumbled");
        this.addStat("bugs_squished", "Bugs Squashed");
        this.addStat("e115_slices_eaten", "Experiment 115 Slices Eaten");
        this.addStat("keeping_charms_activated", "Charms of Keeping Used");
        this.addStat("life_charms_activated", "Charms of Life Used");
        this.addStat("skull_candles_made", "Skull Candles Created");
        this.addStat("tf_shields_broken", "Fortification Shields Broken");
        this.addStat("torchberries_harvested", "Torchberries Harvested");
        this.addStat("trophy_pedestals_activated", "Trophy Pedestals Activated");
        this.addStat("uncrafting_table_interactions", "Interactions with Uncrafting Table");
        this.add("config.jade.plugin_twilightforest.quest_ram_wool", "Quest Ram Wool");
        this.add("twilightforest.book.author", "a forgotten explorer");
        this.addBookAndContents("lichtower", "Notes on a Pointy Tower", "\u00a78[An explorer's notebook, gnawed on by monsters]\u00a70\n\nI have begun examining the strange aura surrounding this tower. The bricks of the tower are protected by a curse, stronger than any I've seen before. The magic from the curse is boiling off into the", "surrounding area.\n\nIn my homeland I would have many options for dealing with this magic, but here my supplies are limited. I shall have to research...", "\u00a78[[Many entries later]]\u00a70\n\nA breakthrough! In my journeys I sighted a huge snake-like monster in a decorated courtyard. Nearby, I picked up a worn down, discarded green scale.\n\nThe magic in the scale seems to have the curse-breaking", "properties I need, but the magic is too dim. I may need to acquire a fresher specimen, directly from the creature.");
        this.addBookAndContents("labyrinth", "Notes on a Swampy Labyrinth", "\u00a78[[An explorer's notebook, written on waterproof paper]]\u00a70\n\nThe mosquitoes in this swamp are vexing, but strange. The vast majority of them seem to have no natural source, nor do they seem to have a role in the local ecology. I have begun to suspect that they are", "some kind of magical curse.\n\n\u00a78[[Next entry]]\u00a70\n\nNow that I have encountered a protection spell on the ruined labyrinth here, I consider my suspicions confirmed. Both the protection spell and the mosquitoes are a", "curse. This curse seems to have a different source from the others I have encountered. I will have to research further...\n\n\u00a78[[Next entry]]\u00a70\n\nThe curse seems to be of a type too powerful for one being alone to", "produce. Several wizards working in combination would be necessary.\n\nIf one of the wizards stopped contributing, the whole of the curse over the entire swamp would fall. Strangely, my divinations do not show signs of any nearby living wizards.", "I did see something interesting in one of the nearby pointy-roofed towers though...");
        this.addBookAndContents("hydralair", "Notes on the Fire Swamp", "\u00a78[[An explorer's notebook, written on fireproof paper]]\u00a70\n\nFire is a trivial obstacle for a master explorer such as myself. I have traversed seas of fire, and swam through oceans of lava. The burning air here is an interesting variation, but", "ultimately no hindrance.\n\nWhat does stop me though is that I have encountered another protection spell, this time surrounding a mighty creature that must be king of this fire swamp. This is not the first protection spell I have encountered, and I am", "beginning to unravel the mysteries of how they work.\n\nIf this spell is like the others, it will be sustained by a powerful creature nearby. Surrounding the fire swamp are several wet swamps, and under those swamps are labyrinths full of minotaurs.", "The logical choice to bind such a spell to would be some sort of powerful minotaur, different in some way from the others that surround it...");
        this.addBookAndContents("tfstronghold", "Notes on a Stronghold", "\u00a78[[An explorer's notebook, written on faintly glowing paper]]\u00a70\n\nThe tendrils of darkness surrounding this area are just a manifestation of a protective spell over the entire dark forest. The spell causes blindness, which is quite vexing. I have seen several", "interesting things in the area and would like to keep exploring.\n\n\u00a78[[Next entry]]\u00a70\n\nI have found ruins in the dark forest. They belong to a stronghold, of a type usually inhabited by knights. Rather than knights though, this stronghold is full of", "goblins. They wear knightly armor, but their behavior is most un-knightly.\n\n\u00a78[[Next entry]]\u00a70\n\nDeep in the ruins, I have found a pedestal. The pedestal seems to be of a type that knights would place trophies on to prove their strength.", "Obtaining a powerful scepter would seem to weaken the curse on the dark forest, and placing a trophy associated with a powerful creature on the pedestal would likely grant access into the main part of the stronghold.");
        this.addBookAndContents("darktower", "Notes on a Wooden Tower", "\u00a78[[An explorer's notebook that seems to have survived an explosion]]\u00a70\n\nThis tower clearly has mechanisms that are not responding to me. Their magic almost yearns to acknowledge my touch, but it cannot. It is if the devices of the tower are being", "suppressed by a powerful group of beings nearby.\n\n\u00a78[[Next entry]]\u00a70\n\nThe magic seems to emanate from deep within the strongholds nearby. It can't come from the goblins, as their magic is charming, but unfocused. There", "must still be some force still active in the strongholds.\n\n\u00a78[[Next entry]]\u00a70\n\nMy analysis indicates that it comes from several sources, operating as a group. I will head back to the stronghold after I resupply...");
        this.addBookAndContents("yeticave", "Notes on an Icy Cave", "\u00a78[[An explorer's notebook, covered in frost]]\u00a70\n\nThe blizzard surrounding these snowy lands is unceasing. This is no ordinary snowfall--this is a magical phenomenon. I will have to conduct experiments to find what is capable of", "causing such an effect.\n\n\u00a78[[Next entry]]\u00a70\n\nThe curse seems to be of a type too powerful for one being alone to produce. Several wizards working in combination would be necessary. If one of the wizards stopped", "contributing, the blizzard would calm. Strangely, my divinations do not show signs of any nearby living wizards. I did see something interesting in one of the nearby pointy-roofed towers though...");
        this.addBookAndContents("icetower", "Notes on Auroral Fortification", "\u00a78[[An explorer's notebook, caked in ice]]\u00a70\n\nI overcame one blizzard, only to run into this terrible ice storm atop the glacier. My explorations have shown me the splendor of an ice palace, shining with the colors of the", "polar aurora. It all seems protected by some sort of curse.\n\n\u00a78[[Next entry]]\u00a70\n\nI am no novice. This curse is fed by the power of a creature nearby. The cause of the curse surrounding the fire swamp was built off the power of the", "leader of the minotaurs nearby.\n\nSurrounding this glacier, there are masses of yetis. Perhaps the yetis have some sort of leader...");
        this.addBookAndContents("trollcave", "Notes on the Highlands", "\u00a78[[An explorer's notebook, damaged by acid]]\u00a70\n\nThere seems to be no way to protect myself from the toxic rainstorm surrounding this area. In my brief excursions, I have also encountered another protection spell, similar to the others I have", "witnessed. The spell must be connected to the toxic storm in some way. Further research to follow...\n\n\u00a78[[Next entry]]\u00a70\n\nSuch supreme weather magic must be the result of multiple undefeated great evils in this world. My studies contain", "several clues pointing at a searing swamp, a forest coated in deep darkness, and a realm coated in snow.");
        this.addBookAndContents("unknown", "Notes on the Unexplained", "\u00a78[[This book shows signs of having been copied many times]]\u00a70\n\nI cannot explain the field surrounding this structure, but the magic is powerful. If this curse is like the others, then the answer to unlocking it lies elsewhere. Perhaps there is something I have left", "undone, or some monster I have yet to defeat. I will have to turn back. I will return to this place later, to see if anything has changed.");
        this.addScreenMessage("optifine.title", "WARNING: OPTIFINE DETECTED");
        this.addScreenMessage("optifine.message", "Before proceeding, please note that Optifine is known to cause crashes, multipart entity visual bugs and many other issues.\n\nBefore reporting a bug, please remove Optifine first and check again to see if the bug is still present.\n\nOptifine-related issues are not solvable on Twilight Forest's end!\n\nThis screen may be disabled in the Client Config.");
        this.addScreenMessage("optifine.suggestions", "Here's a selection of mods that we recommend using instead.");
        this.addScreenMessage("progression_end.message", "This is the end of progression for now. The Final Castle that awaits on the plateau is still unfinished and a work in progress. If you would like to keep up with the mod's development you can join our %s.");
        this.addScreenMessage("progression_end.discord", "Discord Server");
        this.addScreenMessage("crumble_horn_jei", "Crumble Horn");
        this.addScreenMessage("transformation_jei", "Transformation Powder");
        this.addScreenMessage("uncrafting_jei", "Uncrafting");
        this.addTrim("carminite", "Carminite");
        this.addTrim("fiery", "Fiery");
        this.addTrim("ironwood", "Ironwood");
        this.addTrim("knightmetal", "Knightmetal");
        this.addTrim("naga_scale", "Naga Scale");
        this.addTrim("steeleaf", "Steeleaf");
        this.add("museumcurator.animalhusbandry.twilightforest.bugs", "Bugs");
        this.add("museumcurator.architecture.twilightforest.aurorablocks", "Aurora Blocks");
        this.add("museumcurator.architecture.twilightforest.banisters", "Banisters");
        this.add("museumcurator.architecture.twilightforest.castlebrick", "Castle Brick");
        this.add("museumcurator.architecture.twilightforest.giantblocks", "Giant Blocks");
        this.add("museumcurator.botany.twilightforest.beanstalk", "Beanstalk");
        this.add("museumcurator.botany.twilightforest.canopytree", "Canopy Tree");
        this.add("museumcurator.botany.twilightforest.darkwoodtree", "Darkwood Tree");
        this.add("museumcurator.botany.twilightforest.miningtree", "Minewood Tree");
        this.add("museumcurator.botany.twilightforest.sortingtree", "Sortingwood Tree");
        this.add("museumcurator.botany.twilightforest.mangrovetree", "Mangrove Tree");
        this.add("museumcurator.botany.twilightforest.timetree", "Timewood Tree");
        this.add("museumcurator.botany.twilightforest.transformationtree", "Transwood Tree");
        this.add("museumcurator.botany.twilightforest.twilightoaktree", "Twilight Oak Tree");
        this.add("museumcurator.equipment.twilightforest.scepters", "Scepters of Power");
        this.add("museumcurator.lithology.twilightforest.deadrock", "Deadrock");
        this.add("museumcurator.lithology.twilightforest.mazestone", "Mazestone");
        this.add("museumcurator.lithology.twilightforest.nagastone", "Nagastone");
        this.add("museumcurator.machinery.twilightforest.carminitemachines", "Carminite Mechanisms");
        this.add("museumcurator.metallurgy.twilightforest.fiery", "Fiery Metal");
        this.add("museumcurator.metallurgy.twilightforest.ironwood", "Ironwood");
        this.add("museumcurator.metallurgy.twilightforest.knightmetal", "Knightmetal");
        MAGIC_PAINTING_HELPER.forEach((location, stringStringPair) -> {
            this.add(location.m_269108_("magic_painting", "title"), (String)stringStringPair.getFirst());
            this.add(location.m_269108_("magic_painting", "author"), (String)stringStringPair.getSecond());
        });
    }
}

