/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.capability.SeismicWavesCapability;
import fuzs.mutantmonsters.data.ModDamageTypeProvider;
import fuzs.mutantmonsters.data.ModDamageTypeTagsProvider;
import fuzs.mutantmonsters.data.ModEntityTypeTagsProvider;
import fuzs.mutantmonsters.data.ModItemTagsProvider;
import fuzs.mutantmonsters.data.ModLootTableProvider;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModRegistryForge;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.puzzleslib.api.capability.v2.ForgeCapabilityHelper;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="mutantmonsters")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MutantMonstersForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ModConstructor.construct((String)"mutantmonsters", MutantMonsters::new, (ContentRegistrationFlags[])new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOME_MODIFICATIONS});
        ModRegistryForge.touch();
        MutantMonstersForge.registerCapabilities();
    }

    private static void registerCapabilities() {
        ForgeCapabilityHelper.setCapabilityToken(ModRegistry.SEISMIC_WAVES_CAPABILITY, (CapabilityToken)new CapabilityToken<SeismicWavesCapability>(){});
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent evt) {
        evt.put((EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), MutantSkeleton.registerAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0).m_22265_());
        evt.put((EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), MutantZombie.registerAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0).m_22265_());
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = evt.getLookupProvider();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.addProvider(true, (DataProvider)new ModDamageTypeProvider(packOutput, "mutantmonsters", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModDamageTypeTagsProvider(packOutput, lookupProvider, "mutantmonsters", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModEntityTypeTagsProvider(packOutput, lookupProvider, "mutantmonsters", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, "mutantmonsters", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModLootTableProvider(packOutput));
    }
}

