/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.worldgen.tree;

import com.google.common.collect.Lists;
import com.kaboomroads.lostfeatures.worldgen.ModTrunkPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class BaobabTrunkPlacer
extends TrunkPlacer {
    public static final Codec<BaobabTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group(BaobabTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).t1(), BaobabTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).t2(), BaobabTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).t3(), (App)Codec.intRange((int)1, (int)32).fieldOf("base_width").forGetter(trunkPlacer -> trunkPlacer.baseWidth), (App)IntProvider.f_146532_.fieldOf("branch_seperation").forGetter(trunkPlacer -> trunkPlacer.branchSeperation), (App)IntProvider.f_146533_.fieldOf("branch_length").forGetter(trunkPlacer -> trunkPlacer.branchLength), (App)IntProvider.f_146532_.fieldOf("upward_branch_length").forGetter(trunkPlacer -> trunkPlacer.upwardBranchLength), (App)Codec.intRange((int)0, (int)32).fieldOf("branch_height_min").forGetter(trunkPlacer -> trunkPlacer.minBranchHeight), (App)Codec.intRange((int)0, (int)32).fieldOf("branch_height_max").forGetter(trunkPlacer -> trunkPlacer.maxBranchHeight), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability))).apply((Applicative)instance, BaobabTrunkPlacer::new));
    private final IntProvider branchLength;
    private final float placeBranchPerLogProbability;
    private final IntProvider upwardBranchLength;
    protected final IntProvider branchSeperation;
    protected final int baseWidth;
    protected final int minBranchHeight;
    protected final int maxBranchHeight;

    public BaobabTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int baseWidth, IntProvider branchSeperation, IntProvider branchLength, IntProvider upwardBranchLength, int minBranchHeight, int maxBranchHeight, float branchProbability) {
        super(baseHeight, heightRandA, heightRandB);
        this.baseWidth = baseWidth;
        this.branchSeperation = branchSeperation;
        this.branchLength = branchLength;
        this.upwardBranchLength = upwardBranchLength;
        this.minBranchHeight = minBranchHeight;
        this.maxBranchHeight = maxBranchHeight;
        this.placeBranchPerLogProbability = branchProbability;
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return ModTrunkPlacerTypes.BAOBAB_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader reader, @NotNull BiConsumer<BlockPos, BlockState> biConsumer, @NotNull RandomSource random, int height, @NotNull BlockPos pos, @NotNull TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos below = pos.m_7495_();
        int offset = Mth.m_14143_((float)((float)this.baseWidth / -2.0f)) + 1;
        BlockPos dirtStartPos = below.m_7918_(offset, 0, offset);
        BlockPos dirtEndPos = dirtStartPos.m_7918_(this.baseWidth - 1, 0, this.baseWidth - 1);
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)dirtStartPos, (BlockPos)dirtEndPos)) {
            BaobabTrunkPlacer.m_226169_((LevelSimulatedReader)reader, biConsumer, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int lastBranchPos = Integer.MIN_VALUE;
        for (int current = 0; current < height; ++current) {
            int j = pos.m_123342_() + current;
            mutablePos.m_122178_(pos.m_123341_(), j, pos.m_123343_());
            BlockPos startPos = mutablePos.m_7949_().m_7918_(offset, 0, offset);
            BlockPos endPos = startPos.m_7918_(this.baseWidth - 1, 0, this.baseWidth - 1);
            ArrayList<BlockPos> possiblePositions = new ArrayList<BlockPos>(this.baseWidth * this.baseWidth - (this.baseWidth - 2) * (this.baseWidth - 2));
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos)) {
                this.m_226187_(reader, biConsumer, random, blockPos, config);
                if (blockPos.m_123341_() != startPos.m_123341_() && blockPos.m_123341_() != endPos.m_123341_() && blockPos.m_123343_() != startPos.m_123343_() && blockPos.m_123343_() != endPos.m_123343_()) continue;
                possiblePositions.add(blockPos.m_7949_());
            }
            BlockPos.MutableBlockPos branchPos = ((BlockPos)possiblePositions.get(random.m_188503_(possiblePositions.size()))).m_122032_();
            int sample = this.branchSeperation.m_214085_(random);
            if (current >= lastBranchPos + sample && current < height - this.maxBranchHeight && current >= this.minBranchHeight && random.m_188501_() < this.placeBranchPerLogProbability) {
                lastBranchPos = current;
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
                int upwardLength = this.upwardBranchLength.m_214085_(random);
                int length = this.branchLength.m_214085_(random);
                this.placeBranch(reader, biConsumer, random, config, list, branchPos, direction, length, upwardLength);
            }
            if (current != height - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutablePos.m_122178_(pos.m_123341_(), j + 1, pos.m_123343_()), 0, false));
        }
        return list;
    }

    private void placeBranch(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> foliage, BlockPos.MutableBlockPos mutablePos, Direction direction, int length, int upwardLength) {
        int i;
        BlockPos.MutableBlockPos current = mutablePos.m_122032_();
        for (i = 0; i < length; ++i) {
            current.m_122173_(direction);
            this.m_226175_(reader, biConsumer, random, (BlockPos)current, config, state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
        }
        for (i = 0; i < upwardLength; ++i) {
            current.m_122173_(Direction.UP);
            this.m_226187_(reader, biConsumer, random, (BlockPos)current, config);
            if (i < upwardLength - 1) continue;
            foliage.add(new FoliagePlacer.FoliageAttachment(current.m_7918_(0, 1, 0).m_7949_(), 0, false));
        }
    }
}

