/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;

public class Utils {
    public static int loopClamp(int num, int min, int max) {
        if (num > max) {
            num = num % max - 1;
        }
        if (num < min) {
            num = max - Math.abs((int)num) % max;
        }
        return num;
    }

    public static float interpolateLinear(float from, float to, float speed) {
        if (Mth.m_14154_((float)(from - to)) > speed) {
            return from + speed * Math.signum((float)(to - from));
        }
        return to;
    }

    public static double interpolateLinear(double from, double to, double speed) {
        if (Math.abs((double)(from - to)) > speed) {
            return from + speed * Math.signum((double)(to - from));
        }
        return to;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityIsDamageable(Entity entity) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!livingEntity.m_6084_()) return false;
        if (livingEntity.m_20147_()) return false;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35934_) return true;
        }
        if (livingEntity instanceof Player) return false;
        return true;
    }

    public static Vec3 interpolateLinear(Vec3 a, Vec3 b, double t) {
        double x = Utils.interpolateLinear(a.f_82479_, b.f_82479_, t);
        double y = Utils.interpolateLinear(a.f_82480_, b.f_82480_, t);
        double z = Utils.interpolateLinear(a.f_82481_, b.f_82481_, t);
        return new Vec3(x, y, z);
    }

    public static Vec3 lerp(Vec3 a, Vec3 b, double t) {
        double x = Math.lerp((double)a.f_82479_, (double)b.f_82479_, (double)t);
        double y = Math.lerp((double)a.f_82480_, (double)b.f_82480_, (double)t);
        double z = Math.lerp((double)a.f_82481_, (double)b.f_82481_, (double)t);
        return new Vec3(x, y, z);
    }

    public static void sendClientMessage(Component message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_213846_(message);
        }
    }

    public static <T> void sendClientMessage(T message) {
        Utils.sendClientMessage((Component)Component.m_237113_((String)String.valueOf(message)));
    }
}

