/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.mixin;

import com.kaboomroads.lostfeatures.entity.ModEntityTypes;
import com.kaboomroads.lostfeatures.entity.custom.CopperGolem;
import com.kaboomroads.lostfeatures.entity.custom.TuffGolem;
import com.kaboomroads.lostfeatures.tag.ModTags;
import com.kaboomroads.lostfeatures.utils.MutablePair;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarvedPumpkinBlock.class})
public abstract class CarvedPumpkinBlockMixin {
    @Final
    @Shadow
    private static Predicate<BlockState> f_51372_;
    @Shadow
    @Final
    public static DirectionProperty f_51367_;
    @Nullable
    private BlockPattern copperGolemBase;
    @Nullable
    private BlockPattern copperGolemFull;
    @Nullable
    private BlockPattern tuffGolemBase;
    @Nullable
    private BlockPattern tuffGolemFull;
    private final MutablePair<Boolean, Integer> currentPair = MutablePair.of(false, 0);

    @Shadow
    public abstract boolean m_51381_(LevelReader var1, BlockPos var2);

    @Shadow
    private static void m_245952_(Level level, BlockPattern.BlockPatternMatch patternMatch, Entity entity, BlockPos blockPos) {
    }

    private Predicate<BlockState> copperPredicate() {
        return blockState -> {
            if (blockState.m_204336_(ModTags.Blocks.COPPER_BLOCKS)) {
                int age = 0;
                if (blockState.m_204336_(ModTags.Blocks.EXPOSED_COPPER)) {
                    age = 1;
                } else if (blockState.m_204336_(ModTags.Blocks.WEATHERED_COPPER)) {
                    age = 2;
                } else if (blockState.m_204336_(ModTags.Blocks.OXIDIZED_COPPER)) {
                    age = 3;
                }
                this.currentPair.setSecond(age);
                this.currentPair.setFirst(blockState.m_204336_(ModTags.Blocks.WAXED_COPPER));
                return true;
            }
            return false;
        };
    }

    private BlockPattern getOrCreateCopperGolemFull() {
        if (this.copperGolemFull == null) {
            this.copperGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#"}).m_61244_('#', BlockInWorld.m_61169_(this.copperPredicate())).m_61244_('^', BlockInWorld.m_61169_(f_51372_)).m_61249_();
        }
        return this.copperGolemFull;
    }

    private BlockPattern getOrCreateCopperGolemBase() {
        if (this.copperGolemBase == null) {
            this.copperGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#"}).m_61244_('#', BlockInWorld.m_61169_(this.copperPredicate())).m_61249_();
        }
        return this.copperGolemBase;
    }

    private BlockPattern getOrCreateTuffGolemFull() {
        if (this.tuffGolemFull == null) {
            this.tuffGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockPredicate.m_61275_((Block)Blocks.f_152496_))).m_61244_('^', BlockInWorld.m_61169_(f_51372_)).m_61249_();
        }
        return this.tuffGolemFull;
    }

    private BlockPattern getOrCreateTuffGolemBase() {
        if (this.tuffGolemBase == null) {
            this.tuffGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockPredicate.m_61275_((Block)Blocks.f_152496_))).m_61249_();
        }
        return this.tuffGolemBase;
    }

    @Inject(method={"canSpawnGolem"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectCanSpawnGolem(LevelReader levelReader, BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(this.getOrCreateTuffGolemBase().m_61184_(levelReader, blockPos) != null || this.getOrCreateCopperGolemBase().m_61184_(levelReader, blockPos) != null || this.m_51381_(levelReader, blockPos) ? 1 : 0));
    }

    @Inject(method={"trySpawnGolem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/CarvedPumpkinBlock;getOrCreateIronGolemFull()Lnet/minecraft/world/level/block/state/pattern/BlockPattern;")})
    public void injectTrySpawnGolem(Level level, BlockPos blockPos, CallbackInfo ci) {
        BlockPattern.BlockPatternMatch copperPattern = this.getOrCreateCopperGolemFull().m_61184_((LevelReader)level, blockPos);
        if (copperPattern != null) {
            CopperGolem golem = (CopperGolem)ModEntityTypes.COPPER_GOLEM.get().m_20615_(level);
            if (golem != null) {
                golem.setWaxed(this.currentPair.getFirst());
                golem.setStage(this.currentPair.getSecond());
                CarvedPumpkinBlockMixin.m_245952_(level, copperPattern, (Entity)golem, copperPattern.m_61229_(0, 1, 0).m_61176_());
            }
        } else {
            TuffGolem golem;
            BlockPattern.BlockPatternMatch tuffPattern = this.getOrCreateTuffGolemFull().m_61184_((LevelReader)level, blockPos);
            if (tuffPattern != null && (golem = (TuffGolem)ModEntityTypes.TUFF_GOLEM.get().m_20615_(level)) != null) {
                golem.spawnDirection = (Direction)level.m_8055_(blockPos).m_61143_((Property)f_51367_);
                CarvedPumpkinBlockMixin.m_245952_(level, tuffPattern, (Entity)golem, tuffPattern.m_61229_(0, 1, 0).m_61176_());
            }
        }
    }
}

