/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.custom;

import com.google.common.collect.ImmutableList;
import com.kaboomroads.lostfeatures.entity.ai.ModMemoryModuleType;
import com.kaboomroads.lostfeatures.entity.ai.ModSensorType;
import com.kaboomroads.lostfeatures.entity.ai.brain.CopperGolemAi;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CopperGolem
extends AbstractGolem {
    private static final EntityDataAccessor<Integer> STAGE = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WAXED = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState buttonAnimationState = new AnimationState();
    protected static final ImmutableList<SensorType<? extends Sensor<? super CopperGolem>>> SENSOR_TYPES = ImmutableList.of(ModSensorType.COPPER_BUTTON_SENSOR.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26373_, ModMemoryModuleType.INTERESTING_BLOCK_LOCATION.get());
    protected int oxidizeTicks;
    protected int oxidizeDuration = this.f_19796_.m_216339_(30000, 50000);

    public CopperGolem(EntityType<? extends CopperGolem> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STAGE, (Object)0);
        this.f_19804_.m_135372_(WAXED, (Object)false);
    }

    public int getStage() {
        return (Integer)this.f_19804_.m_135370_(STAGE);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getStage() >= 3;
    }

    public void setStage(int stage) {
        if (stage >= 3) {
            this.m_6274_().m_21936_(ModMemoryModuleType.INTERESTING_BLOCK_LOCATION.get());
            this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            this.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        } else if (this.getStage() >= 3) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.f_19804_.m_135381_(STAGE, (Object)stage);
        this.oxidizeTicks = 0;
    }

    public boolean getWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(WAXED, (Object)waxed);
        this.oxidizeTicks = 0;
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("OxidizeTicks", this.oxidizeTicks);
        compoundTag.m_128405_("OxidizeDuration", this.oxidizeDuration);
        compoundTag.m_128405_("Stage", this.getStage());
        compoundTag.m_128379_("Waxed", this.getWaxed());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setStage(compoundTag.m_128451_("Stage"));
        this.setWaxed(compoundTag.m_128471_("Waxed"));
        this.oxidizeTicks = compoundTag.m_128451_("OxidizeTicks");
        if (compoundTag.m_128441_("OxidizeDuration")) {
            this.oxidizeDuration = compoundTag.m_128451_("OxidizeDuration");
        }
    }

    @NotNull
    protected Brain.Provider<CopperGolem> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return CopperGolemAi.makeBrain((Brain<CopperGolem>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<CopperGolem> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("copperGolemBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        CopperGolemAi.updateActivity(this);
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && !this.getWaxed() && this.getStage() < 3) {
            ++this.oxidizeTicks;
            if (this.oxidizeTicks >= this.oxidizeDuration) {
                this.setStage(Mth.m_14045_((int)(this.getStage() + 1), (int)0, (int)3));
                this.oxidizeTicks = 0;
                this.oxidizeDuration = this.f_19796_.m_216339_(30000, 50000);
            }
        }
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec3, @NotNull InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_150930_(Items.f_42784_) && !this.getWaxed()) {
            this.setWaxed(true);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175828_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 50, 0.25, 0.5, 0.25, 0.0);
            }
            this.m_9236_().m_245747_(this.m_20183_(), SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (item.m_41720_() instanceof AxeItem) {
            if (this.getWaxed()) {
                this.setWaxed(false);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 50, 0.25, 0.5, 0.25, 0.0);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.getStage() > 0) {
                this.setStage(this.getStage() - 1);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175831_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 50, 0.25, 0.5, 0.25, 0.0);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return super.m_7111_(player, vec3, hand);
    }

    public void m_7822_(byte id) {
        if (id == 64) {
            this.buttonAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.walkAnimationState.m_246184_((this.m_20096_() || this.m_217005_()) && !this.m_21525_() && this.m_20184_().m_165925_() > 1.0E-6, this.f_19797_);
        }
    }
}

