/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.client.wildfire;

import com.kaboomroads.lostfeatures.entity.client.wildfire.WildfireAnimation;
import com.kaboomroads.lostfeatures.entity.custom.Wildfire;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WildfireModel<T extends Wildfire>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("lostfeatures", "wildfire"), "main");
    private final ModelPart root;
    private final ModelPart shield1;
    private final ModelPart shield2;
    private final ModelPart shield3;
    private final ModelPart shield4;

    public WildfireModel(ModelPart root) {
        this.root = root.m_171324_("wildfire");
        ModelPart shields = this.root.m_171324_("body").m_171324_("shields");
        this.shield1 = shields.m_171324_("shield1");
        this.shield2 = shields.m_171324_("shield2");
        this.shield3 = shields.m_171324_("shield3");
        this.shield4 = shields.m_171324_("shield4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition wildfire = partdefinition.m_171599_("wildfire", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = wildfire.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 52).m_171488_(-2.0f, -22.0f, -2.0f, 4.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(30, 36).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(62, 35).m_171488_(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f).m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)0.0f));
        PartDefinition shields = body.m_171599_("shields", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shield1 = shields.m_171599_("shield1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-10.0f));
        shield1.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(38, 16).m_171488_(-5.0f, -1.0f, -1.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition shield2 = shields.m_171599_("shield2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-10.0f, (float)-20.0f, (float)0.0f));
        shield2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -5.0f, 2.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition shield3 = shields.m_171599_("shield3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)10.0f));
        shield3.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-5.0f, -1.0f, -1.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition shield4 = shields.m_171599_("shield4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)10.0f, (float)-20.0f, (float)0.0f));
        shield4.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(14, 17).m_171488_(-1.0f, -1.0f, -5.0f, 2.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(((Wildfire)((Object)entity)).idleAnimationState, WildfireAnimation.IDLE, ageInTicks, 1.0f);
        this.m_233385_(((Wildfire)((Object)entity)).hurtAnimationState, WildfireAnimation.HURT, ageInTicks, 1.0f);
        int shields = ((Wildfire)((Object)entity)).getShields();
        this.shield1.f_104207_ = shields >= 4;
        this.shield2.f_104207_ = shields >= 3;
        this.shield3.f_104207_ = shields >= 2;
        this.shield4.f_104207_ = shields >= 1;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

