/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.client.coppergolem;

import com.kaboomroads.lostfeatures.entity.client.coppergolem.CopperGolemAnimation;
import com.kaboomroads.lostfeatures.entity.custom.CopperGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class CopperGolemModel<T extends CopperGolem>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("lostfeatures", "copper_golem"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public CopperGolemModel(ModelPart root) {
        this.root = root.m_171324_("golem");
        this.head = this.root.m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition golem = partdefinition.m_171599_("golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = golem.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-4.0f, -7.0f, -2.0f, 8.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -7.0f, -4.0f, 10.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(36, 18).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        head.m_171599_("rod", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(28, 0).m_171488_(-2.0f, -8.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        arms.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        arms.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(20, 21).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        legs.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(32, 33).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-4.0f, (float)0.0f));
        legs.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(32, 10).m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = (float)entity.m_20184_().m_165925_();
        float f1 = Mth.m_14036_((float)(f * 10000.0f), (float)0.5f, (float)1.5f);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_233385_(((CopperGolem)((Object)entity)).walkAnimationState, CopperGolemAnimation.WALK, ageInTicks, f1);
        this.m_233385_(((CopperGolem)((Object)entity)).buttonAnimationState, CopperGolemAnimation.BUTTON, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float p_233517_, float p_233518_) {
        this.head.f_104203_ = p_233518_ * ((float)Math.PI / 180);
        this.head.f_104204_ = p_233517_ * ((float)Math.PI / 180);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

