/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.client.boat;

import com.google.common.collect.ImmutableMap;
import com.kaboomroads.lostfeatures.entity.custom.ModBoat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class ModBoatRenderer
extends EntityRenderer<ModBoat> {
    private final Map<ModBoat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public ModBoatRenderer(EntityRendererProvider.Context context, boolean hasChest, boolean raft) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("lostfeatures", ModBoatRenderer.getTextureLocation(type, hasChest)), this.createBoatModel(context, (ModBoat.Type)((Object)type), hasChest, raft))));
    }

    protected ListModel<Boat> createBoatModel(EntityRendererProvider.Context modelPart, ModBoat.Type type, boolean hasChest, boolean raft) {
        ModelLayerLocation modellayerlocation = ModBoatRenderer.createBoatModelName(type, hasChest);
        ModelPart modelpart = modelPart.m_174023_(modellayerlocation);
        if (raft) {
            return hasChest ? new ChestRaftModel(modelpart) : new RaftModel(modelpart);
        }
        return hasChest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ModBoat.Type type, boolean hasChest) {
        return new ModelLayerLocation(new ResourceLocation("lostfeatures", (String)(hasChest ? "chest_boat/" : "boat/" + type.getName())), "main");
    }

    protected static String getTextureLocation(ModBoat.Type p_234566_, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + p_234566_.getName() + ".png" : "textures/entity/boat/" + p_234566_.getName() + ".png";
    }

    public void render(ModBoat boat, float p_113930_, float p_113931_, PoseStack p_113932_, @NotNull MultiBufferSource multiBufferSource, int p_113934_) {
        float f2;
        p_113932_.m_85836_();
        p_113932_.m_252880_(0.0f, 0.375f, 0.0f);
        p_113932_.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_113930_));
        float f = (float)boat.m_38385_() - p_113931_;
        float f1 = boat.m_38384_() - p_113931_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            p_113932_.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(p_113931_)), (float)0.0f)) {
            p_113932_.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(p_113931_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        p_113932_.m_85841_(-1.0f, -1.0f, 1.0f);
        p_113932_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_((Entity)boat, p_113931_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(listmodel.m_103119_(resourcelocation));
        listmodel.m_7695_(p_113932_, vertexconsumer, p_113934_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexconsumer1 = multiBufferSource.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.m_102282_().m_104301_(p_113932_, vertexconsumer1, p_113934_, OverlayTexture.f_118083_);
            }
        }
        p_113932_.m_85849_();
        super.m_7392_((Entity)boat, p_113930_, p_113931_, p_113932_, multiBufferSource, p_113934_);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ModBoat boat) {
        return (ResourceLocation)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(ModBoat boat) {
        return this.boatResources.get((Object)boat.getCustomVariant());
    }
}

