/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.lostfeatures.entity.ai.behaviour;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterestingBlockSensor
extends Sensor<LivingEntity> {
    private final Predicate<BlockState> targetType;
    private final boolean nextTo;
    private final int xRange;
    private final int yRangeN;
    private final int yRangeP;
    private final int zRange;
    private final int memoryDuration;
    private final MemoryModuleType<BlockPos> memoryType;
    @Nullable
    private final MemoryModuleType<BlockPos> originalBlockMemory;

    public InterestingBlockSensor(int interval, Predicate<BlockState> targetType, boolean nextTo, int xRange, int yRangeN, int yRangeP, int zRange, int memoryDuration, MemoryModuleType<BlockPos> memoryType, @Nullable MemoryModuleType<BlockPos> originalBlockMemory) {
        super(interval);
        this.targetType = targetType;
        this.nextTo = nextTo;
        this.xRange = xRange;
        this.yRangeN = yRangeN;
        this.yRangeP = yRangeP;
        this.zRange = zRange;
        this.memoryDuration = memoryDuration;
        this.memoryType = memoryType;
        this.originalBlockMemory = originalBlockMemory;
    }

    @NotNull
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of(this.memoryType);
    }

    protected void m_5578_(@NotNull ServerLevel serverLevel, LivingEntity livingEntity) {
        Brain brain = livingEntity.m_6274_();
        Optional blockPosition = brain.m_21952_(this.memoryType);
        if (blockPosition.isEmpty()) {
            Optional<BlockPos> blockPos = InterestingBlockSensor.findBlock(serverLevel, this.targetType, livingEntity, this.xRange, this.yRangeN, this.yRangeP, this.zRange);
            BlockPos pos = blockPos.orElse(null);
            if (this.originalBlockMemory != null) {
                brain.m_21879_(this.originalBlockMemory, (Object)pos);
            }
            if (this.nextTo && pos != null) {
                ArrayList possibleDirs = Arrays.stream(Direction.values()).filter((Predicate<Direction>)Direction.Plane.HORIZONTAL).collect(Collectors.toCollection(ArrayList::new));
                BlockPos finalPos = pos;
                possibleDirs.removeIf(dir -> !serverLevel.m_8055_(finalPos.m_121945_(dir)).m_60795_());
                if (!possibleDirs.isEmpty()) {
                    Direction direction = (Direction)possibleDirs.get(livingEntity.m_217043_().m_188503_(possibleDirs.size()));
                    pos = pos.m_121945_(direction);
                }
            }
            if (blockPos.isPresent()) {
                InterestingBlockSensor.setInterestingBlockLocation(livingEntity, this.memoryType, this.memoryDuration, pos);
            }
        } else if (!this.targetType.test(serverLevel.m_8055_((BlockPos)blockPosition.get()))) {
            InterestingBlockSensor.setInterestingBlockLocation(livingEntity, this.memoryType, this.memoryDuration, null);
        }
    }

    private static Optional<BlockPos> findBlock(ServerLevel serverLevel, Predicate<BlockState> targetType, LivingEntity livingEntity, int xRange, int yRangeN, int yRangeP, int zRange) {
        BlockPos blockPos = livingEntity.m_20183_();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-xRange, -yRangeN, -zRange), (BlockPos)blockPos.m_7918_(xRange, yRangeP, zRange))) {
            if (!targetType.test(serverLevel.m_8055_(pos))) continue;
            positions.add(pos.m_7949_());
        }
        if (!positions.isEmpty()) {
            return Optional.ofNullable((BlockPos)positions.get(livingEntity.m_217043_().m_188503_(positions.size())));
        }
        return Optional.empty();
    }

    public static void setInterestingBlockLocation(LivingEntity entity, MemoryModuleType<BlockPos> memoryType, int memoryDuration, @Nullable BlockPos blockPos) {
        Brain brain = entity.m_6274_();
        if (blockPos != null && entity.m_9236_().m_6857_().m_61937_(blockPos)) {
            brain.m_21882_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(blockPos), (long)memoryDuration);
            brain.m_21882_(memoryType, (Object)blockPos, (long)memoryDuration);
            brain.m_21936_(MemoryModuleType.f_26370_);
        } else if (blockPos == null) {
            brain.m_21936_(memoryType);
            brain.m_21936_(MemoryModuleType.f_26371_);
            brain.m_21936_(MemoryModuleType.f_26370_);
        }
    }
}

