/*
 * Decompiled with CFR 0.152.
 */
package net.celsiusqc.cp_tweaks.base;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public enum ArmorTiers implements ArmorMaterial
{
    VOID_WORMED("void_wormed", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 5);
        map.put(ArmorItem.Type.LEGGINGS, 8);
        map.put(ArmorItem.Type.CHESTPLATE, 10);
        map.put(ArmorItem.Type.HELMET, 5);
    }), 17, SoundEvents.f_11679_, 3.2f, 0.12f, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "gu/void_worm")))),
    DESH("desh", 51, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 6);
        map.put(ArmorItem.Type.LEGGINGS, 9);
        map.put(ArmorItem.Type.CHESTPLATE, 11);
        map.put(ArmorItem.Type.HELMET, 6);
    }), 17, SoundEvents.f_11679_, 3.2f, 0.12f, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ingots/desh")))),
    CALORITE("calorite", 56, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 7);
        map.put(ArmorItem.Type.LEGGINGS, 11);
        map.put(ArmorItem.Type.CHESTPLATE, 13);
        map.put(ArmorItem.Type.HELMET, 8);
    }), 17, SoundEvents.f_11679_, 3.2f, 0.12f, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ingots/calorite")))),
    OSTRUM("ostrum", 61, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 8);
        map.put(ArmorItem.Type.LEGGINGS, 12);
        map.put(ArmorItem.Type.CHESTPLATE, 14);
        map.put(ArmorItem.Type.HELMET, 9);
    }), 17, SoundEvents.f_11679_, 3.4f, 0.14f, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ingots/ostrum")))),
    ICE_SHARD("ice_shard", 70, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 10);
        map.put(ArmorItem.Type.LEGGINGS, 14);
        map.put(ArmorItem.Type.CHESTPLATE, 16);
        map.put(ArmorItem.Type.HELMET, 11);
    }), 17, SoundEvents.f_11679_, 3.2f, 0.12f, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "shards/unstable_ice"))));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockback;
    private final Supplier<Ingredient> repairMaterial;

    private ArmorTiers(String name, int durability, EnumMap<ArmorItem.Type, Integer> damageReduction, int enchantability, SoundEvent sound, float toughness, float knockback, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.protectionFunctionForType = damageReduction;
        this.enchantability = enchantability;
        this.equipSound = sound;
        this.toughness = toughness;
        this.knockback = knockback;
        this.repairMaterial = repairMaterial;
    }

    public String m_6082_() {
        return this.name;
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    public float m_6649_() {
        return this.knockback;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

