/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.driver.nvidia;

import me.jellysquid.mods.sodium.client.util.workarounds.platform.linux.LibC;
import me.jellysquid.mods.sodium.client.util.workarounds.platform.windows.Kernel32;
import me.jellysquid.mods.sodium.client.util.workarounds.platform.windows.WindowsProcessHacks;
import net.minecraft.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvidiaWorkarounds {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Embeddium-NvidiaWorkarounds");

    public static void install() {
        LOGGER.warn("Attempting to apply workarounds for the NVIDIA Graphics Driver...");
        LOGGER.warn("If the game crashes immediately after this point, please make a bug report: https://github.com/CaffeineMC/sodium-fabric/issues");
        try {
            switch (Util.m_137581_()) {
                case WINDOWS: {
                    WindowsProcessHacks.setCommandLine("net.caffeinemc.sodium");
                    Kernel32.setEnvironmentVariable("SHIM_MCCOMPAT", "0x800000001");
                    break;
                }
                case LINUX: {
                    LibC.setEnvironmentVariable("__GL_THREADED_OPTIMIZATIONS", "0");
                }
            }
            LOGGER.info("... Successfully applied workarounds for the NVIDIA Graphics Driver!");
        }
        catch (Throwable t) {
            LOGGER.error("Failure while applying workarounds", t);
            LOGGER.error("READ ME! The workarounds for the NVIDIA Graphics Driver did not apply correctly!");
            LOGGER.error("READ ME! You are very likely going to run into unexplained crashes and severe performance issues!");
            LOGGER.error("READ ME! Please see this issue for more information: https://github.com/CaffeineMC/sodium-fabric/issues/1816");
        }
    }

    public static void uninstall() {
        switch (Util.m_137581_()) {
            case WINDOWS: {
                WindowsProcessHacks.resetCommandLine();
                break;
            }
        }
    }
}

