/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import me.jellysquid.mods.sodium.client.world.WorldSliceLocal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.lighting.FlatQuadLighter;
import net.minecraftforge.client.model.lighting.QuadLighter;
import net.minecraftforge.client.model.lighting.SmoothQuadLighter;
import net.minecraftforge.common.ForgeConfig;

public class ForgeBlockRenderer {
    private final BlockColors colors = Minecraft.m_91087_().m_91298_();
    private final ThreadLocal<QuadLighter> lighterFlat = ThreadLocal.withInitial(() -> new FlatQuadLighter(this.colors));
    private final ThreadLocal<QuadLighter> lighterSmooth = ThreadLocal.withInitial(() -> new SmoothQuadLighter(this.colors));
    private static boolean useForgeLightingPipeline = false;

    public static void init() {
        useForgeLightingPipeline = (Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }

    public static boolean useForgeLightingPipeline() {
        return useForgeLightingPipeline;
    }

    private void processQuad(ChunkModelBuilder renderData, BakedQuad quad) {
        ModelQuadView src = (ModelQuadView)quad;
        TextureAtlasSprite sprite = src.getSprite();
        if (sprite != null) {
            renderData.addSprite(sprite);
        }
    }

    public boolean renderBlock(LightMode mode, BlockRenderContext ctx, VertexConsumer buffer, PoseStack stack, RandomSource random, BlockOcclusionCache sideCache, ChunkModelBuilder renderData) {
        BlockState state = ctx.state();
        BakedModel model = ctx.model();
        ModelData data = ctx.modelData();
        RenderType layer = ctx.renderLayer();
        WorldSliceLocal world = ctx.localSlice();
        BlockPos pos = ctx.pos();
        QuadLighter lighter = mode == LightMode.FLAT ? this.lighterFlat.get() : this.lighterSmooth.get();
        QuadLighter flatLighter = null;
        PoseStack.Pose matrixEntry = stack.m_85850_();
        boolean empty = true;
        random.m_188584_(ctx.seed());
        List quads = model.getQuads(state, null, random, data, layer);
        if (!quads.isEmpty()) {
            lighter.setup((BlockAndTintGetter)world, pos, state);
            empty = false;
            for (int i = 0; i < quads.size(); ++i) {
                BakedQuad quad = (BakedQuad)quads.get(i);
                if (mode == LightMode.SMOOTH && !quad.hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = this.lighterFlat.get();
                        flatLighter.setup((BlockAndTintGetter)world, pos, state);
                    }
                    flatLighter.process(buffer, matrixEntry, quad, OverlayTexture.f_118083_);
                } else {
                    lighter.process(buffer, matrixEntry, quad, OverlayTexture.f_118083_);
                }
                this.processQuad(renderData, quad);
            }
        }
        for (Direction side : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(ctx.seed());
            quads = model.getQuads(state, side, random, data, layer);
            if (quads.isEmpty() || !sideCache.shouldDrawSide(state, (BlockGetter)world, pos, side)) continue;
            if (empty) {
                lighter.setup((BlockAndTintGetter)world, pos, state);
            }
            empty = false;
            for (int i = 0; i < quads.size(); ++i) {
                BakedQuad quad = (BakedQuad)quads.get(i);
                if (mode == LightMode.SMOOTH && !quad.hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = this.lighterFlat.get();
                        flatLighter.setup((BlockAndTintGetter)world, pos, state);
                    }
                    flatLighter.process(buffer, matrixEntry, quad, OverlayTexture.f_118083_);
                } else {
                    lighter.process(buffer, matrixEntry, quad, OverlayTexture.f_118083_);
                }
                this.processQuad(renderData, quad);
            }
        }
        lighter.reset();
        if (flatLighter != null) {
            flatLighter.reset();
        }
        return !empty;
    }
}

