/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import subaraki.paintings.Paintings;
import subaraki.paintings.compat_layer.IPackRepoDiscoveryService;
import subaraki.paintings.utils.PaintingEntry;

public class PaintingPackReader {
    public static final List<PaintingEntry> PAINTINGS = new ArrayList<PaintingEntry>();
    public static final Set<Path> FORCE_LOAD = new TreeSet<Path>();

    public void init() {
        Paintings.LOGGER.info("loading json file and contents for paintings.");
        this.duplicateBaseToFolder();
        this.makeEntriesFromStream(this.getClass().getResourceAsStream("/assets/paintings/paintings.json"));
        this.scanPacks();
    }

    private void makeEntriesFromStream(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        this.parsePaintingsFromJson(json);
    }

    private void parsePaintingsFromJson(JsonObject json) {
        JsonArray array = json.getAsJsonArray("paintings");
        for (int index = 0; index < array.size(); ++index) {
            JsonObject jsonObject = array.get(index).getAsJsonObject();
            String textureName = jsonObject.get("name").getAsString();
            if (!ResourceLocation.m_135830_((String)textureName)) {
                Paintings.LOGGER.error("Non [a-z0-9/._-] character in path of location: " + textureName);
                continue;
            }
            int sizeX = 0;
            int sizeY = 0;
            if (jsonObject.has("x")) {
                sizeX = jsonObject.get("x").getAsInt();
            }
            if (jsonObject.has("y")) {
                sizeY = jsonObject.get("y").getAsInt();
            }
            if (jsonObject.has("square")) {
                sizeX = sizeY = jsonObject.get("square").getAsInt();
            }
            int animY = sizeY;
            if (jsonObject.has("anim")) {
                animY = jsonObject.get("anim").getAsInt();
            }
            if (sizeX == 0 || sizeY == 0) {
                Paintings.LOGGER.error("Tried loading a painting where one of the sides was 0 ! ");
                Paintings.LOGGER.error("Painting name is : " + textureName);
                Paintings.LOGGER.error("Skipping...");
                continue;
            }
            if (sizeX % 16 != 0 || sizeY % 16 != 0) {
                Paintings.LOGGER.error("Tried loading a painting with a size that is not a multiple of 16 !! ");
                Paintings.LOGGER.error("Painting name is : " + textureName);
                Paintings.LOGGER.error("Skipping...");
                continue;
            }
            PaintingEntry entry = new PaintingEntry(textureName, sizeX, sizeY, animY);
            Paintings.LOGGER.info(String.format("Loaded json painting %s , %d x %d", entry.getPaintingName(), entry.getSizeX(), entry.getSizeY()));
            PAINTINGS.add(entry);
        }
    }

    private void scanPacks() {
        FORCE_LOAD.clear();
        HashSet<Path> packDirectories = new HashSet<Path>();
        packDirectories.add(Paths.get(".", "resourcepacks"));
        List<IPackRepoDiscoveryService> packRepos = ServiceLoader.load(IPackRepoDiscoveryService.class).stream().map(prov -> (IPackRepoDiscoveryService)prov.get()).toList();
        packDirectories.addAll(packRepos.stream().flatMap(repoService -> repoService.getPackRepos().stream()).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toSet()));
        packDirectories.parallelStream().filter(folder -> Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])).flatMap(folder -> Arrays.stream(folder.toFile().listFiles((dir, file) -> file.endsWith(".zip")))).map(packFile -> {
            block18: {
                try (FileSystem zipFs = FileSystems.newFileSystem(packFile.toPath());){
                    Pair pair;
                    Path json = zipFs.getPath("./paintings++.json", new String[0]);
                    if (!Files.exists(json, new LinkOption[0])) {
                        json = zipFs.getPath("./paintings.json", new String[0]);
                    }
                    if (!Files.exists(json, new LinkOption[0])) break block18;
                    JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(json));
                    try {
                        pair = Pair.of((Object)packFile.toPath(), (Object)JsonParser.parseReader((JsonReader)reader).getAsJsonObject());
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            Paintings.LOGGER.warn("************************************");
                            Paintings.LOGGER.error("`{}` Errored. Skipping.", (Object)json.getFileName().toString());
                            Paintings.LOGGER.error(e.getMessage());
                            Paintings.LOGGER.warn("************************************");
                            break block18;
                        }
                        catch (JsonParseException e) {
                            Paintings.LOGGER.warn("************************************");
                            Paintings.LOGGER.warn("json file `{}` could not parse.", (Object)json.getFileName().toString());
                            Paintings.LOGGER.warn("************************************");
                            e.printStackTrace();
                            break block18;
                        }
                    }
                    reader.close();
                    return pair;
                }
                catch (IOException e) {
                    Paintings.LOGGER.warn("************************************");
                    Paintings.LOGGER.error("Invalid ResourcePack  {}", (Object)packFile.getName());
                    Paintings.LOGGER.error(e.getMessage());
                    Paintings.LOGGER.warn("************************************");
                }
            }
            return null;
        }).filter(Objects::nonNull).filter(pair -> ((JsonObject)pair.getRight()).has("paintings")).forEach(pair -> {
            FORCE_LOAD.add((Path)pair.getLeft());
            Paintings.LOGGER.info("FLRP & Validated: {}", (Object)((Path)pair.getLeft()).getFileName().toString());
            this.parsePaintingsFromJson((JsonObject)pair.getRight());
        });
    }

    private void duplicateBaseToFolder() {
        Paintings.LOGGER.info("**Paintings++ no longer copies the base file outside if the mod. **");
    }
}

