/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import subaraki.paintings.Paintings;
import subaraki.paintings.gui.IPaintingGUI;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.utils.Services;

public class CommonPaintingScreen
extends Screen
implements IPaintingGUI {
    public static final int START_X = 10;
    public static final int START_Y = 30;
    public static final int GAP = 5;
    private final int entityID;
    private final PaintingVariant[] types;
    private int scrollBarScroll = 0;

    public CommonPaintingScreen(PaintingVariant[] types, int entityID) {
        super((Component)Component.m_237115_((String)"select.a.painting"));
        this.types = types;
        this.entityID = entityID;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
        this.scrollBarScroll = 0;
    }

    private void addButtons() {
        int END_X = this.f_96543_ - 30;
        int prevHeight = this.types[0].m_218909_();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (PaintingVariant variant : this.types) {
            if (posx + variant.m_218908_() > END_X || prevHeight > variant.m_218909_()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = variant.m_218909_();
            }
            try {
                this.m_142416_((GuiEventListener)new PaintingButton(posx, posy, variant.m_218908_(), variant.m_218909_(), (Component)Component.m_237113_((String)""), button -> {
                    this.sendPacket(BuiltInRegistries.f_257051_.m_7981_((Object)variant), this.entityID);
                    this.m_7861_();
                    this.m_7379_();
                }, variant));
            }
            catch (NullPointerException e) {
                Paintings.LOGGER.warn("*******************");
                Paintings.LOGGER.warn(e.getMessage());
                Paintings.LOGGER.warn("*******************");
            }
            posx += 5 + variant.m_218908_();
            ++index;
        }
        this.centerRow(rowstart, this.getRenderablesWithCast().size() - 1);
    }

    private void centerRow(int start, int end) {
        if (this.optionalAbstractWidget(start).isPresent() && this.optionalAbstractWidget(end).isPresent()) {
            int left = this.optionalAbstractWidget(start).get().m_252754_();
            int right = this.optionalAbstractWidget(end).get().m_252754_() + this.optionalAbstractWidget(end).get().m_5711_();
            int correction = (this.f_96543_ - 20 - (right - left)) / 2;
            for (int i = start; i <= end; ++i) {
                this.optionalAbstractWidget(i).ifPresent(widget -> {
                    if (widget instanceof PaintingButton) {
                        PaintingButton painting = (PaintingButton)((Object)widget);
                        painting.shiftX(correction);
                    }
                });
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280509_(10, 30, this.f_96543_ - 10, this.f_96544_ - 30, 0x44444444);
        Window window = this.f_96541_.m_91268_();
        int scale = (int)window.m_85449_();
        RenderSystem.enableScissor((int)(10 * scale), (int)(30 * scale), (int)(this.f_96543_ * scale), (int)((this.f_96544_ - 60) * scale));
        super.m_88315_(guiGraphics, mouseX, mouseY, f);
        RenderSystem.disableScissor();
        if (!this.getRenderablesWithCast().isEmpty()) {
            this.drawFakeScrollBar(guiGraphics);
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        this.drawToolTips(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double mouseScroll) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int move = (mouseScroll < 0.0 ? -1 : (mouseScroll > 0.0 ? 1 : 0)) * 16;
            this.movePaintingWidgets(move);
        }
        return super.m_6050_(mouseX, mouseY, mouseScroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            float move = (float)amountY * -1.0f;
            int paintingCanvasTopY = this.optionalFirstWidget().get().m_252907_();
            int paintingCanvasBotY = this.optionalLastWidget().get().m_252907_() + this.optionalLastWidget().get().m_93694_();
            int paintingContainerSize = paintingCanvasBotY - paintingCanvasTopY;
            int viewport = this.f_96544_ - 30;
            float portToCanvasScale = (float)viewport / (float)paintingContainerSize;
            float barsize = (float)viewport * portToCanvasScale;
            float scaledViewport = (float)viewport - barsize;
            float usableSpaceScale = (float)paintingContainerSize / scaledViewport;
            float scaledDrageMove = move * usableSpaceScale;
            this.movePaintingWidgets((int)scaledDrageMove);
        }
        return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void movePaintingWidgets(int scrollAmount) {
        int paintingCanvasTopY = this.optionalFirstWidget().get().m_252907_();
        int onScreenTopLimit = 35;
        int paintingCanvasBotY = this.optionalLastWidget().get().m_252907_() + this.optionalLastWidget().get().m_93694_();
        int onScreenBottomLimit = this.f_96544_ - onScreenTopLimit;
        if (scrollAmount > 0 && paintingCanvasTopY < onScreenTopLimit || scrollAmount < 0 && paintingCanvasBotY >= onScreenBottomLimit) {
            this.getRenderablesWithCast().forEach(widget -> ((AbstractWidget)widget).m_253211_(((AbstractWidget)widget).m_252907_() + scrollAmount));
            this.scrollBarScroll -= scrollAmount;
        }
    }

    private void drawToolTips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!Services.CONFIG.showPaintingSize()) {
            return;
        }
        for (Renderable guiButton : this.getRenderablesWithCast()) {
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).m_5953_(mouseX, mouseY)) continue;
            MutableComponent text = Component.m_237113_((String)(button.m_5711_() / 16 + "x" + button.m_93694_() / 16));
            HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)text);
            Style style = Style.f_131099_.m_131144_(hover);
            guiGraphics.m_280304_(this.f_96547_, style, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)text) - 4, this.f_96544_ - 7);
        }
    }

    private void drawFakeScrollBar(GuiGraphics guiGraphics) {
        if (this.getRenderablesWithCast().isEmpty()) {
            return;
        }
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int top = this.optionalFirstWidget().get().m_252907_();
            int containerSize = this.f_96544_ - 60;
            int bot = this.optionalLastWidget().get().m_252907_() + this.optionalLastWidget().get().m_93694_();
            int totalSize = bot - top;
            float percent = (float)containerSize / (float)totalSize * 100.0f;
            if ((double)percent < 100.0) {
                int sizeBar = (int)((float)containerSize / 100.0f * percent);
                int relativeScroll = (int)((float)this.scrollBarScroll / 100.0f * percent);
                guiGraphics.m_280024_(this.f_96543_ - 10, 30, this.f_96543_, 30 + containerSize, Integer.MIN_VALUE, -2145246686);
                guiGraphics.m_280024_(this.f_96543_ - 10, 30 + relativeScroll, this.f_96543_, 30 + relativeScroll + sizeBar, -2130706433, -2145246686);
            }
        }
    }

    private Optional<AbstractWidget> optionalFirstWidget() {
        return this.optionalAbstractWidget(0);
    }

    private Optional<AbstractWidget> optionalLastWidget() {
        return this.optionalAbstractWidget(this.getRenderablesWithCast().size() - 1);
    }

    @Override
    public Optional<AbstractWidget> optionalAbstractWidget(int index) {
        return Optional.empty();
    }

    @Override
    public List<Renderable> getRenderablesWithCast() {
        throw new IllegalStateException("painting gui common code crash override. please override paintingscreen");
    }

    @Override
    public void sendPacket(ResourceLocation variantName, int entityID) {
    }
}

