/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.menu.ISubMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class WTMenuHost
extends WirelessTerminalMenuHost
implements InternalInventoryHost,
ISegmentedInventory {
    private final AppEngInternalInventory singularityInventory = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final AppEngInternalInventory viewCellInventory = new AppEngInternalInventory((InternalInventoryHost)this, 5);
    private boolean rangeCheck;
    private final IGrid targetGrid;
    private IActionHost quantumBridge;
    private IUpgradeInventory upgradeInventory;
    public static final ResourceLocation INV_SINGULARITY = new ResourceLocation("ae2wtlib", "singularity");

    public WTMenuHost(Player player, @Nullable Integer inventorySlot, ItemStack is, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(player, inventorySlot, is, returnToMainMenu);
        this.upgradeInventory = UpgradeInventories.forItem((ItemStack)is, (int)WUTHandler.getUpgradeCardCount(), this::updateUpgrades);
        this.targetGrid = ((WirelessTerminalItem)is.m_41720_()).getLinkedGrid(is, player.m_9236_(), null);
    }

    public void updateUpgrades(ItemStack stack, IUpgradeInventory upgrades) {
        this.upgradeInventory = upgrades;
    }

    protected void readFromNbt() {
        CompoundTag tag = this.getItemStack().m_41784_();
        this.viewCellInventory.readFromNBT(tag, "viewcells");
        this.singularityInventory.readFromNBT(tag, "singularity");
    }

    public void saveChanges() {
        CompoundTag tag = this.getItemStack().m_41784_();
        this.viewCellInventory.writeToNBT(tag, "viewcells");
        this.singularityInventory.writeToNBT(tag, "singularity");
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
    }

    @Nullable
    public IGridNode getActionableNode() {
        if (this.isQuantumLinked() && !this.getPlayer().m_9236_().m_5776_()) {
            return this.quantumBridge.getActionableNode();
        }
        return super.getActionableNode();
    }

    @Nullable
    public MEStorage getInventory() {
        IGridNode node = this.getActionableNode();
        if (node == null) {
            return null;
        }
        return node.getGrid().getStorageService().getInventory();
    }

    public boolean rangeCheck() {
        this.rangeCheck = super.rangeCheck();
        return this.isQuantumLinked() || this.rangeCheck;
    }

    public boolean isQuantumLinked() {
        long frequency = ItemWT.getQEFrequency(this.getItemStack(), this.singularityInventory);
        if (this.quantumBridge == null) {
            this.quantumBridge = ItemWT.getQuantumBridge(this.getItemStack(), this.getPlayer().m_9236_(), this.singularityInventory, this.upgradeInventory);
            if (this.quantumBridge == null) {
                return false;
            }
        } else {
            IActionHost iActionHost = this.quantumBridge;
            if (iActionHost instanceof QuantumCluster) {
                QuantumCluster quantumCluster = (QuantumCluster)iActionHost;
                if (quantumCluster.getCenter() == null) {
                    return false;
                }
                long frequencyOther = quantumCluster.getCenter().getQEFrequency();
                if (frequencyOther != frequency && frequencyOther != -frequency && ItemWT.findQuantumBridge(this.getPlayer().m_9236_(), frequency) == null) {
                    return false;
                }
            } else if (ItemWT.findQuantumBridge(this.getPlayer().m_9236_(), frequency) == null) {
                return false;
            }
        }
        if (this.quantumBridge.getActionableNode() == null) {
            return false;
        }
        return this.quantumBridge.getActionableNode().getGrid() == this.targetGrid || this.targetGrid == null;
    }

    public AppEngInternalInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        if (this.rangeCheck) {
            super.setPowerDrainPerTick(powerDrainPerTick);
        } else {
            super.setPowerDrainPerTick(AE2wtlibConfig.INSTANCE.getOutOfRangePower());
        }
    }

    public boolean drainPower() {
        this.recharge();
        if (!super.drainPower()) {
            this.getPlayer().m_5661_((Component)PlayerMessages.DeviceNotPowered.text(), true);
            return false;
        }
        this.recharge();
        return true;
    }

    private void recharge() {
        if (this.quantumBridge == null) {
            return;
        }
        Item item = this.getItemStack().m_41720_();
        if (item instanceof AEBasePoweredItem) {
            AEBasePoweredItem item2 = (AEBasePoweredItem)item;
            double currentPower = item2.getAECurrentPower(this.getItemStack());
            double maxPower = item2.getAEMaxPower(this.getItemStack());
            double missing = maxPower - currentPower;
            if (this.getActionableNode() == null) {
                return;
            }
            double extracted = this.getActionableNode().getGrid().getEnergyService().extractAEPower(missing, Actionable.MODULATE, PowerMultiplier.ONE);
            item2.injectAEPower(this.getItemStack(), extracted, Actionable.MODULATE);
        }
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)INV_SINGULARITY)) {
            return this.singularityInventory;
        }
        return null;
    }

    public boolean stillValid() {
        return this.ensureItemStillInSlot();
    }

    protected boolean ensureItemStillInSlot() {
        if (this.getSlot() != null) {
            return super.ensureItemStillInSlot();
        }
        return Platform.isStillPresentTrinkets(this.getPlayer(), this.getItemStack());
    }
}

