/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.souldata;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.machines.common.blockentity.task.SpawnerMachineTask;
import com.enderio.machines.common.souldata.EngineSoul;
import com.enderio.machines.common.souldata.ISoulData;
import com.enderio.machines.common.souldata.SpawnerSoul;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SoulDataProvider
implements DataProvider {
    private final PackOutput.PathProvider souldataprovider;

    public SoulDataProvider(PackOutput packOutput) {
        this.souldataprovider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "eio_soul");
    }

    public void buildSoulData(Consumer<FinshedSoulData<?>> finshedSoulDataConsumer) {
        this.addSpawnerData(EntityType.f_217014_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_147039_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20549_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20550_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20551_, 60000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20553_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20554_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20555_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20556_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20557_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20558_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20559_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20560_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20562_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20563_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20566_, 60000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20567_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20565_, 1000000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20568_, 200000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20452_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_217012_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20453_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20454_, 60000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_147035_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20455_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20456_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20458_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20457_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20459_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20460_, 100000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20466_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20468_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20503_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20504_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20505_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20507_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20508_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20509_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20510_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20511_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20512_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20513_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20514_, 18000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20516_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20517_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20518_, 60000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20519_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20520_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20521_, 200000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20524_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20523_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20525_, 18000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20526_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20528_, 18000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20479_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20480_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20482_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_217013_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20490_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20488_, 15000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20489_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20491_, 12000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20492_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20493_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_217015_, 1000000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20495_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20496_, 1000000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20499_, 18000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20500_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20501_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20502_, 18000, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20530_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addSpawnerData(EntityType.f_20531_, 51200, SpawnerMachineTask.SpawnType.ENTITYTYPE, finshedSoulDataConsumer);
        this.addEngineData(EntityType.f_20551_, (TagKey<Fluid>)FluidTags.f_13132_, 300, 15, finshedSoulDataConsumer);
        this.addEngineData(EntityType.f_20501_, (Fluid)EIOFluids.NUTRIENT_DISTILLATION.get(), 500, 15, finshedSoulDataConsumer);
        this.addEngineData(EntityType.f_20530_, (Fluid)EIOFluids.NUTRIENT_DISTILLATION.get(), 500, 15, finshedSoulDataConsumer);
        this.addEngineData(EntityType.f_20458_, (Fluid)EIOFluids.NUTRIENT_DISTILLATION.get(), 500, 15, finshedSoulDataConsumer);
        this.addEngineData(EntityType.f_20566_, (Fluid)EIOFluids.DEW_OF_THE_VOID.get(), 900, 10, finshedSoulDataConsumer);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.buildSoulData(finshedSoulData -> {
            if (!set.add(finshedSoulData.getId())) {
                throw new IllegalStateException("Duplicate recipe" + finshedSoulData.getId());
            }
            list.add(DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)finshedSoulData.serializeData(), (Path)this.souldataprovider.m_245731_(finshedSoulData.getId())));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String m_6055_() {
        return "Souldata";
    }

    private void addSpawnerData(EntityType<?> entityType, int power, SpawnerMachineTask.SpawnType type, Consumer<FinshedSoulData<?>> finshedSoulDataConsumer) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        SpawnerSoul.SoulData data = new SpawnerSoul.SoulData(key, power, type);
        finshedSoulDataConsumer.accept(new FinshedSoulData<SpawnerSoul.SoulData>(SpawnerSoul.CODEC, data, "spawner/" + key.m_135827_() + "_" + key.m_135815_()));
    }

    private void addEngineData(EntityType<?> entityType, Fluid fluid, int powerpermb, int tickpermb, Consumer<FinshedSoulData<?>> finshedSoulDataConsumer) {
        ResourceLocation entityRL = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        ResourceLocation fluidRL = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        EngineSoul.SoulData data = new EngineSoul.SoulData(entityRL, fluidRL.toString(), powerpermb, tickpermb);
        finshedSoulDataConsumer.accept(new FinshedSoulData<EngineSoul.SoulData>(EngineSoul.CODEC, data, "engine/" + entityRL.m_135827_() + "_" + entityRL.m_135815_()));
    }

    private void addEngineData(EntityType<?> entityType, TagKey<Fluid> fluid, int powerpermb, int tickpermb, Consumer<FinshedSoulData<?>> finshedSoulDataConsumer) {
        ResourceLocation entityRL = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        String fluidRL = "#" + fluid.f_203868_();
        EngineSoul.SoulData data = new EngineSoul.SoulData(entityRL, fluidRL, powerpermb, tickpermb);
        finshedSoulDataConsumer.accept(new FinshedSoulData<EngineSoul.SoulData>(EngineSoul.CODEC, data, "engine/" + entityRL.m_135827_() + "_" + entityRL.m_135815_()));
    }

    static class FinshedSoulData<T extends ISoulData> {
        private final Codec<T> codec;
        private final T data;
        private final ResourceLocation id;

        FinshedSoulData(Codec<T> codec, T data, String id) {
            this.codec = codec;
            this.data = data;
            this.id = EnderIO.loc(id);
        }

        FinshedSoulData(Codec<T> codec, T data, ResourceLocation id) {
            this.codec = codec;
            this.data = data;
            this.id = id;
        }

        public JsonObject serializeData() {
            DataResult element = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.data);
            return ((JsonElement)element.get().left().get()).getAsJsonObject();
        }

        public ResourceLocation getId() {
            return this.id;
        }
    }
}

