/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.souldata;

import com.enderio.EnderIO;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.core.common.network.Packet;
import com.enderio.machines.common.souldata.ISoulData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;

public class SoulDataReloadListener<T extends ISoulData>
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    public Map<ResourceLocation, T> map = new HashMap<ResourceLocation, T>();
    private final Codec<T> codec;
    private final String folderName;
    private static final Map<String, SoulDataReloadListener<? extends ISoulData>> loadedSoulData = new HashMap<String, SoulDataReloadListener<? extends ISoulData>>();

    public SoulDataReloadListener(Gson gson, String folder, Codec<T> codec) {
        super(gson, "eio_soul/" + folder);
        this.codec = codec;
        this.folderName = "eio_soul/" + folder;
        loadedSoulData.put(folder, this);
    }

    public SoulDataReloadListener(String folder, Codec<T> codec) {
        this(GSON, folder, codec);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap newMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> element : pObject.entrySet()) {
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element.getValue()).get().ifLeft(result -> newMap.put(((ISoulData)result.getFirst()).getKey(), (ISoulData)result.getFirst())).ifRight(partial -> EnderIO.LOGGER.error("Failed to parse data json for {} due to: {}", element.getKey(), (Object)partial.message()));
        }
        this.map = newMap;
        EnderIO.LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.map.size());
    }

    public <P extends Packet> SoulDataReloadListener<T> subscribeAsSyncable(Function<Map<ResourceLocation, T>, P> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(packetFactory));
        return this;
    }

    private <P extends Packet> Consumer<OnDatapackSyncEvent> getDatapackSyncListener(Function<Map<ResourceLocation, T>, P> packetFactory) {
        return event -> {
            ServerPlayer player = event.getPlayer();
            Packet packet = (Packet)packetFactory.apply(this.map);
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            CoreNetwork.send(target, packet);
        };
    }

    public Optional<T> matches(ResourceLocation entitytype) {
        if (this.map.containsKey(entitytype)) {
            return Optional.of((ISoulData)this.map.get(entitytype));
        }
        return Optional.empty();
    }

    public static SoulDataReloadListener<? extends ISoulData> fromString(String name) {
        return loadedSoulData.get(name);
    }
}

