/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.api.grindingball.IGrindingBallData;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.core.common.util.TagUtil;
import com.enderio.machines.common.blockentity.SagMillBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SagMillingRecipe
implements MachineRecipe<Container> {
    private static final Random RANDOM = new Random();
    private final ResourceLocation id;
    private final Ingredient input;
    private final List<OutputItem> outputs;
    private final int energy;
    private final BonusType bonusType;

    public SagMillingRecipe(ResourceLocation id, Ingredient input, List<OutputItem> outputs, int energy, BonusType bonusType) {
        this.id = id;
        this.input = input;
        this.outputs = outputs;
        this.energy = energy;
        this.bonusType = bonusType;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getBaseEnergyCost() {
        return this.energy;
    }

    @Override
    public int getEnergyCost(Container container) {
        return this.getEnergyCost(container.getGrindingBall());
    }

    @Override
    public int getEnergyCost(IGrindingBallData grindingBallData) {
        return (int)((float)this.energy * grindingBallData.getPowerUse());
    }

    public BonusType getBonusType() {
        return this.bonusType;
    }

    @Override
    public List<OutputStack> craft(Container container, RegistryAccess registryAccess) {
        float chanceMult;
        ArrayList<OutputStack> outputs = new ArrayList<OutputStack>();
        float f = chanceMult = this.getBonusType().doChance() ? container.getGrindingBall().getBonusMultiplier() : 1.0f;
        for (float outputCount = this.getBonusType().canMultiply() ? container.getGrindingBall().getOutputMultiplier() : 1.0f; outputCount > 0.0f; outputCount -= 1.0f) {
            if (!(RANDOM.nextFloat() < outputCount)) continue;
            for (OutputItem output : this.outputs) {
                if (!output.isPresent() || !(RANDOM.nextFloat() < output.getChance() * chanceMult)) continue;
                Item item = output.getItem();
                int count = output.getCount();
                for (OutputStack stack : outputs) {
                    if (count <= 0) break;
                    ItemStack itemStack = stack.getItem();
                    if (!itemStack.m_150930_(item)) continue;
                    int growth = Math.min(count, itemStack.m_41741_());
                    itemStack.m_41769_(growth);
                    count -= growth;
                }
                if (count < 0) continue;
                outputs.add(OutputStack.of(new ItemStack((ItemLike)item, count)));
            }
        }
        return outputs;
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        ArrayList<OutputStack> guaranteedOutputs = new ArrayList<OutputStack>();
        for (OutputItem item : this.outputs) {
            if (!(item.chance >= 1.0f) || !item.isPresent()) continue;
            guaranteedOutputs.add(OutputStack.of(new ItemStack((ItemLike)item.getItem(), item.getCount())));
        }
        return guaranteedOutputs;
    }

    public List<OutputItem> getOutputs() {
        return this.outputs;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(Container container, Level level) {
        return this.input.test(SagMillBlockEntity.INPUT.getItemStack((net.minecraft.world.Container)container));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.SAG_MILLING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.SAG_MILLING.type().get();
    }

    public static enum BonusType {
        NONE(false, false),
        MULTIPLY_OUTPUT(true, true),
        CHANCE_ONLY(false, true);

        private final boolean multiply;
        private final boolean chance;

        private BonusType(boolean multiply, boolean chance) {
            this.multiply = multiply;
            this.chance = chance;
        }

        public boolean canMultiply() {
            return this.multiply;
        }

        public boolean doChance() {
            return this.chance;
        }

        public boolean useGrindingBall() {
            return this.multiply || this.chance;
        }
    }

    public static class Container
    extends RecipeWrapper {
        private final Supplier<IGrindingBallData> grindingBallData;

        public Container(IItemHandlerModifiable inv, Supplier<IGrindingBallData> data) {
            super(inv);
            this.grindingBallData = data;
        }

        public final IGrindingBallData getGrindingBall() {
            return this.grindingBallData.get();
        }
    }

    public static class OutputItem {
        private final Either<Item, TagKey<Item>> item;
        private final int count;
        private final float chance;
        private final boolean optional;

        public static OutputItem of(Item item, int count, float chance, boolean optional) {
            return new OutputItem((Either<Item, TagKey<Item>>)Either.left((Object)item), count, chance, optional);
        }

        public static OutputItem of(TagKey<Item> tag, int count, float chance, boolean optional) {
            return new OutputItem((Either<Item, TagKey<Item>>)Either.right(tag), count, chance, optional);
        }

        public OutputItem(Either<Item, TagKey<Item>> item, int count, float chance, boolean optional) {
            this.item = item;
            this.count = count;
            this.chance = chance;
            this.optional = optional;
        }

        public boolean isPresent() {
            return this.getItem() != null;
        }

        @Nullable
        public Item getItem() {
            return this.item.left().or(() -> TagUtil.getOptionalItem((TagKey<Item>)((TagKey)this.item.right().get()))).orElse(null);
        }

        public ItemStack getItemStack() {
            Item item = this.getItem();
            if (item != null) {
                return new ItemStack((ItemLike)item, this.count);
            }
            return ItemStack.f_41583_;
        }

        @Nullable
        public TagKey<Item> getTag() {
            if (!this.isTag()) {
                return null;
            }
            return (TagKey)this.item.right().get();
        }

        public boolean isTag() {
            return this.item.right().isPresent();
        }

        public boolean isItem() {
            return this.item.left().isPresent();
        }

        public int getCount() {
            return this.count;
        }

        public float getChance() {
            return this.chance;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }

    public static class Serializer
    implements RecipeSerializer<SagMillingRecipe> {
        public SagMillingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)serializedRecipe.get("input"));
            int energy = serializedRecipe.get("energy").getAsInt();
            BonusType bonusType = BonusType.MULTIPLY_OUTPUT;
            if (serializedRecipe.has("bonus")) {
                bonusType = BonusType.valueOf(serializedRecipe.get("bonus").getAsString().toUpperCase());
            }
            JsonArray jsonOutputs = serializedRecipe.getAsJsonArray("outputs");
            ArrayList<OutputItem> outputs = new ArrayList<OutputItem>();
            for (int i = 0; i < jsonOutputs.size(); ++i) {
                ResourceLocation id;
                boolean optional;
                JsonObject obj = jsonOutputs.get(i).getAsJsonObject();
                int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
                float chance = obj.has("chance") ? obj.get("chance").getAsFloat() : 1.0f;
                boolean bl = optional = obj.has("optional") && obj.get("optional").getAsBoolean();
                if (obj.has("tag")) {
                    id = new ResourceLocation(obj.get("tag").getAsString());
                    TagKey tag = ItemTags.create((ResourceLocation)id);
                    outputs.add(OutputItem.of((TagKey<Item>)tag, count, chance, optional));
                    continue;
                }
                id = new ResourceLocation(obj.get("item").getAsString());
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null && !optional) {
                    EnderIO.LOGGER.error("Sag milling recipe {} is missing a required output item {}", (Object)recipeId, (Object)id);
                    throw new RuntimeException("Sag milling recipe is missing a required output item.");
                }
                outputs.add(OutputItem.of(item, count, chance, optional));
            }
            return new SagMillingRecipe(recipeId, input, outputs, energy, bonusType);
        }

        @Nullable
        public SagMillingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int energy = buffer.readInt();
                BonusType bonusType = (BonusType)buffer.m_130066_(BonusType.class);
                ArrayList<OutputItem> outputs = new ArrayList<OutputItem>();
                int outputCount = buffer.readInt();
                for (int i = 0; i < outputCount; ++i) {
                    boolean isTag = buffer.readBoolean();
                    ResourceLocation id = buffer.m_130281_();
                    int count = buffer.readInt();
                    float chance = buffer.readFloat();
                    boolean optional = buffer.readBoolean();
                    if (isTag) {
                        TagKey tag = ItemTags.create((ResourceLocation)id);
                        outputs.add(OutputItem.of((TagKey<Item>)tag, count, chance, optional));
                        continue;
                    }
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                    if (item == null && !optional) {
                        EnderIO.LOGGER.error("Sag milling recipe {} is missing a required output item {}", (Object)recipeId, (Object)id);
                        throw new RuntimeException("Sag milling recipe is missing a required output item.");
                    }
                    outputs.add(OutputItem.of(item, count, chance, optional));
                }
                return new SagMillingRecipe(recipeId, input, outputs, energy, bonusType);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading sag milling recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, SagMillingRecipe recipe) {
            try {
                recipe.input.m_43923_(buffer);
                buffer.writeInt(recipe.energy);
                buffer.m_130068_((Enum)recipe.bonusType);
                buffer.writeInt(recipe.outputs.size());
                for (OutputItem item : recipe.outputs) {
                    buffer.writeBoolean(item.isTag());
                    if (item.isTag()) {
                        buffer.m_130085_(item.getTag().f_203868_());
                    } else {
                        buffer.m_130085_(ForgeRegistries.ITEMS.getKey((Object)item.getItem()));
                    }
                    buffer.writeInt(item.count);
                    buffer.writeFloat(item.chance);
                    buffer.writeBoolean(item.optional);
                }
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing allow smelting recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

