/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.item;

import com.enderio.machines.common.block.CapacitorBankBlock;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapacitorBankItem
extends BlockItem {
    public CapacitorBankItem(CapacitorBankBlock pBlock, Item.Properties pProperties) {
        super((Block)pBlock, pProperties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BlockEntityEnergyStorage(stack, ((CapacitorBankBlock)this.m_40614_()).getTier().getStorageCapacity());
    }

    private static class BlockEntityEnergyStorage
    implements IEnergyStorage,
    ICapabilityProvider {
        private final ItemStack container;
        private final int capacity;

        public BlockEntityEnergyStorage(ItemStack container, int capacity) {
            this.container = container;
            this.capacity = capacity;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (simulate) {
                return Math.min(maxReceive, this.getMaxEnergyStored() - this.getEnergyStored());
            }
            int stored = this.getEnergyStored();
            int received = Math.min(maxReceive, this.getMaxEnergyStored() - stored);
            this.setEnergyStored(stored + received);
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (simulate) {
                return Math.min(maxExtract, this.getEnergyStored());
            }
            int stored = this.getEnergyStored();
            int extracted = Math.min(maxExtract, stored);
            this.setEnergyStored(stored - extracted);
            return extracted;
        }

        public int getEnergyStored() {
            return Optional.ofNullable(this.container.m_41783_()).filter(nbt -> nbt.m_128425_("BlockEntityTag", 10)).map(nbt -> nbt.m_128469_("BlockEntityTag")).filter(nbt -> nbt.m_128425_("Energy", 10)).map(nbt -> nbt.m_128469_("Energy")).filter(nbt -> nbt.m_128425_("EnergyStored", 3)).map(nbt -> nbt.m_128451_("EnergyStored")).orElse(0);
        }

        public void setEnergyStored(int stored) {
            CompoundTag nbt = this.container.m_41784_();
            CompoundTag blockEntityTag = null;
            if (nbt.m_128425_("BlockEntityTag", 10)) {
                blockEntityTag = nbt.m_128469_("BlockEntityTag");
            } else {
                blockEntityTag = new CompoundTag();
                nbt.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
            }
            CompoundTag energyTag = null;
            if (blockEntityTag.m_128425_("Energy", 10)) {
                energyTag = blockEntityTag.m_128469_("Energy");
            } else {
                energyTag = new CompoundTag();
                nbt.m_128365_("Energy", (Tag)energyTag);
            }
            energyTag.m_128405_("EnergyStored", stored);
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ENERGY) {
                return LazyOptional.of(() -> this).cast();
            }
            return LazyOptional.empty();
        }
    }
}

