/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.machines.client.gui.screen.PrimitiveAlloySmelterScreen;
import com.enderio.machines.client.gui.screen.StirlingGeneratorScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.integrations.jei.util.MachineRecipeCategory;
import com.enderio.machines.common.integrations.jei.util.RecipeUtil;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PrimitiveAlloySmeltingCategory
extends MachineRecipeCategory<AlloySmeltingRecipe> {
    public static final RecipeType<AlloySmeltingRecipe> TYPE = RecipeType.create((String)"enderio", (String)"primitive_alloy_smelting", AlloySmeltingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic staticFlame;
    private final IDrawable animatedFlame;

    public PrimitiveAlloySmeltingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PrimitiveAlloySmelterScreen.BG_TEXTURE, 19, 16, 118, 54);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.PRIMITIVE_ALLOY_SMELTER.get()));
        this.staticFlame = guiHelper.createDrawable(StirlingGeneratorScreen.BG_TEXTURE, 176, 0, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<AlloySmeltingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_PRIMITIVE_ALLOY_SMELTING;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloySmeltingRecipe recipe, IFocusGroup focuses) {
        List<CountedIngredient> inputs = recipe.getInputs();
        if (inputs.size() > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(inputs.get(0).getItems());
        }
        if (inputs.size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 1).addItemStacks(inputs.get(1).getItems());
        }
        if (inputs.size() > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 41, 1).addItemStacks(inputs.get(2).getItems());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 19).addItemStacks(List.of(RecipeUtil.getResultStacks(recipe).get(0).getItem()));
    }

    public void draw(AlloySmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 22, 20);
    }
}

