/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.task;

import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.blockentity.task.IMachineTask;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.recipe.MachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CraftingMachineTask<R extends MachineRecipe<C>, C extends Container>
implements IMachineTask {
    protected final Level level;
    protected final MachineInventory inventory;
    protected final C container;
    protected final MultiSlotAccess outputSlots;
    @Nullable
    private R recipe;
    private int progressMade;
    private int progressRequired;
    private boolean hasConsumedInputs;
    private boolean hasDeterminedOutputs;
    private List<OutputStack> outputs = List.of();
    private boolean isComplete;
    private static final String KEY_RECIPE_ID = "RecipeId";
    private static final String KEY_PROGRESS_MADE = "ProgressMade";
    private static final String KEY_PROGRESS_REQUIRED = "ProgressRequired";
    private static final String KEY_HAS_COLLECTED_INPUTS = "HasCollectedInputs";
    private static final String KEY_IS_COMPLETE = "IsComplete";
    private static final String KEY_HAS_DETERMINED_OUTPUTS = "HasDeterminedOutputs";
    private static final String KEY_OUTPUTS = "Outputs";

    public CraftingMachineTask(@NotNull Level level, MachineInventory inventory, C container, MultiSlotAccess outputSlots, @Nullable R recipe) {
        this.level = level;
        this.inventory = inventory;
        this.container = container;
        this.outputSlots = outputSlots;
        this.recipe = recipe;
    }

    public MachineInventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public R getRecipe() {
        return this.recipe;
    }

    protected abstract void consumeInputs(R var1);

    protected abstract int makeProgress(int var1);

    protected abstract int getProgressRequired(R var1);

    protected void onDetermineOutputs(R recipe) {
    }

    @Override
    public void tick() {
        if (this.isComplete) {
            return;
        }
        if (this.recipe == null) {
            this.isComplete = true;
            return;
        }
        if (!this.hasDeterminedOutputs) {
            this.hasDeterminedOutputs = true;
            this.onDetermineOutputs(this.recipe);
            this.outputs = this.recipe.craft(this.container, this.level.m_9598_());
            this.progressRequired = this.getProgressRequired(this.recipe);
        }
        if (!this.recipe.m_5818_(this.container, this.level)) {
            this.isComplete = true;
            return;
        }
        if (this.progressMade < this.progressRequired) {
            this.progressMade += this.makeProgress(this.progressRequired - this.progressMade);
        }
        if (this.progressMade >= this.progressRequired && this.placeOutputs(this.outputs, false)) {
            this.consumeInputs(this.recipe);
            this.isComplete = true;
        }
    }

    @Override
    public float getProgress() {
        if (this.recipe == null) {
            return 0.0f;
        }
        return (float)this.progressMade / (float)this.progressRequired;
    }

    @Override
    public boolean isCompleted() {
        return this.isComplete;
    }

    protected boolean placeOutputs(List<OutputStack> outputs, boolean simulate) {
        ItemStack item;
        for (OutputStack output : outputs) {
            item = output.getItem();
            for (SingleSlotAccess outputAccess : this.outputSlots.getAccesses()) {
                item = outputAccess.insertItem(this.inventory, item, true);
            }
            if (item.m_41619_()) continue;
            return false;
        }
        if (!simulate) {
            for (OutputStack output : outputs) {
                item = output.getItem();
                for (SingleSlotAccess outputAccess : this.outputSlots.getAccesses()) {
                    item = outputAccess.insertItem(this.inventory, item, false);
                }
            }
        }
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.recipe == null) {
            return tag;
        }
        tag.m_128359_(KEY_RECIPE_ID, this.recipe.m_6423_().toString());
        tag.m_128405_(KEY_PROGRESS_MADE, this.progressMade);
        tag.m_128405_(KEY_PROGRESS_REQUIRED, this.progressRequired);
        tag.m_128379_(KEY_HAS_COLLECTED_INPUTS, this.hasConsumedInputs);
        tag.m_128379_(KEY_IS_COMPLETE, this.isComplete);
        tag.m_128379_(KEY_HAS_DETERMINED_OUTPUTS, this.hasDeterminedOutputs);
        if (this.hasDeterminedOutputs) {
            ListTag outputsNbt = new ListTag();
            for (OutputStack stack : this.outputs) {
                outputsNbt.add((Object)stack.serializeNBT());
            }
            tag.m_128365_(KEY_OUTPUTS, (Tag)outputsNbt);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.recipe = this.loadRecipe(new ResourceLocation(nbt.m_128461_(KEY_RECIPE_ID)));
        this.progressMade = nbt.m_128451_(KEY_PROGRESS_MADE);
        this.progressRequired = nbt.m_128451_(KEY_PROGRESS_REQUIRED);
        this.hasConsumedInputs = nbt.m_128471_(KEY_HAS_COLLECTED_INPUTS);
        this.isComplete = nbt.m_128471_(KEY_IS_COMPLETE);
        this.hasDeterminedOutputs = nbt.m_128471_(KEY_HAS_DETERMINED_OUTPUTS);
        if (this.hasDeterminedOutputs) {
            ListTag outputsNbt = nbt.m_128437_(KEY_OUTPUTS, 10);
            this.outputs = new ArrayList<OutputStack>();
            for (Tag tag : outputsNbt) {
                this.outputs.add(OutputStack.fromNBT((CompoundTag)tag));
            }
        }
    }

    @Nullable
    protected R loadRecipe(ResourceLocation id) {
        return (R)((MachineRecipe)this.level.m_7465_().m_44043_(id).orElse(null));
    }
}

