/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.base;

import com.enderio.api.UseOnly;
import com.enderio.api.capability.ISideConfig;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.base.common.blockentity.IWrenchable;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.particle.RangeParticleData;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.core.common.network.slot.BooleanNetworkDataSlot;
import com.enderio.core.common.network.slot.EnumNetworkDataSlot;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.core.common.network.slot.NBTSerializableNetworkDataSlot;
import com.enderio.core.common.util.PlayerInteractionUtil;
import com.enderio.machines.common.block.MachineBlock;
import com.enderio.machines.common.io.IOConfig;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlockEntity
extends EnderBlockEntity
implements MenuProvider,
IWrenchable {
    private final IIOConfig ioConfig;
    public static final ModelProperty<IIOConfig> IO_CONFIG_PROPERTY = new ModelProperty();
    private ModelData modelData = ModelData.EMPTY;
    protected int range = 3;
    protected IntegerNetworkDataSlot rangeDataSlot;
    protected boolean rangeVisible = false;
    protected BooleanNetworkDataSlot rangeVisibleDataSlot;
    private RedstoneControl redstoneControl = RedstoneControl.ALWAYS_ACTIVE;
    @Nullable
    private final MachineInventory inventory;
    @Nullable
    private final FluidTank fluidTank;
    @Nullable
    private final MachineFluidHandler fluidHandler;
    private final List<Capability<?>> cachedCapabilityTypes = new ArrayList();
    private final Map<Capability<?>, EnumMap<Direction, LazyOptional<?>>> cachedCapabilities = new HashMap();
    private boolean isCapabilityCacheDirty = false;
    private final EnumNetworkDataSlot<RedstoneControl> redstoneControlDataSlot;
    private final NBTSerializableNetworkDataSlot<IIOConfig> ioConfigDataSlot;

    public MachineBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.ioConfig = this.createIOConfig();
        this.addCapabilityProvider(this.ioConfig);
        MachineInventoryLayout slotLayout = this.getInventoryLayout();
        if (slotLayout != null) {
            this.inventory = this.createMachineInventory(slotLayout);
            this.addCapabilityProvider(this.inventory);
        } else {
            this.inventory = null;
        }
        this.fluidTank = this.createFluidTank();
        if (this.fluidTank != null) {
            this.fluidHandler = this.createFluidHandler(this.fluidTank);
            if (this.fluidHandler != null) {
                this.addCapabilityProvider(this.fluidHandler);
            }
        } else {
            this.fluidHandler = null;
        }
        if (this.supportsRedstoneControl()) {
            this.redstoneControlDataSlot = new EnumNetworkDataSlot<RedstoneControl>(RedstoneControl.class, this::getRedstoneControl, e -> {
                this.redstoneControl = e;
            });
            this.addDataSlot(this.redstoneControlDataSlot);
        } else {
            this.redstoneControlDataSlot = null;
        }
        this.ioConfigDataSlot = new NBTSerializableNetworkDataSlot<IIOConfig>(this::getIOConfig, () -> {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                this.onIOConfigChanged();
            }
        });
        this.addDataSlot(this.ioConfigDataSlot);
    }

    protected IIOConfig createIOConfig() {
        return new IOConfig(){

            @Override
            protected void onChanged(Direction side, IOMode oldMode, IOMode newMode) {
                if (MachineBlockEntity.this.f_58857_ == null) {
                    return;
                }
                MachineBlockEntity.this.m_6596_();
                if (newMode == IOMode.DISABLED) {
                    this.invalidateSide(side);
                }
                MachineBlockEntity.this.f_58857_.m_46672_(MachineBlockEntity.this.f_58858_, MachineBlockEntity.this.m_58900_().m_60734_());
                MachineBlockEntity.this.onIOConfigChanged(side, oldMode, newMode);
            }

            @Override
            protected Direction getBlockFacing() {
                BlockState state = MachineBlockEntity.this.m_58900_();
                if (state.m_61138_((Property)MachineBlock.FACING)) {
                    return (Direction)MachineBlockEntity.this.m_58900_().m_61143_((Property)MachineBlock.FACING);
                }
                return super.getBlockFacing();
            }

            @Override
            public boolean supportsMode(Direction side, IOMode mode) {
                return MachineBlockEntity.this.supportsIOMode(side, mode);
            }
        };
    }

    protected void onIOConfigChanged(Direction side, IOMode oldMode, IOMode newMode) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.ioConfigDataSlot, this.getIOConfig());
        }
    }

    public final IIOConfig getIOConfig() {
        return this.ioConfig;
    }

    protected boolean supportsIOMode(Direction side, IOMode mode) {
        return true;
    }

    @NotNull
    public ModelData getModelData() {
        return this.getIOConfig().renderOverlay() ? this.modelData : ModelData.EMPTY;
    }

    private void onIOConfigChanged() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.ioConfig.renderOverlay()) {
            this.modelData = this.modelData.derive().with(IO_CONFIG_PROPERTY, (Object)this.ioConfig).build();
            this.requestModelDataUpdate();
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean isRangeVisible() {
        return this.rangeVisible;
    }

    public void setIsRangeVisible(boolean visible) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.rangeVisibleDataSlot, visible);
        } else {
            this.rangeVisible = visible;
        }
    }

    public int getMaxRange() {
        return 0;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.rangeDataSlot, range);
        } else {
            this.range = range;
        }
    }

    public void decreaseRange() {
        if (this.range > 0) {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                this.clientUpdateSlot(this.rangeDataSlot, this.range - 1);
            } else {
                --this.range;
            }
        }
    }

    public void increaseRange() {
        if (this.range < this.getMaxRange()) {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                this.clientUpdateSlot(this.rangeDataSlot, this.range + 1);
            } else {
                ++this.range;
            }
        }
    }

    public BlockPos getParticleLocation() {
        return this.m_58899_();
    }

    private void generateParticle(RangeParticleData data, BlockPos pos) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_6485_((ParticleOptions)data, true, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
        }
    }

    public String getColor() {
        return "000000";
    }

    public boolean supportsRedstoneControl() {
        return true;
    }

    public RedstoneControl getRedstoneControl() {
        return this.redstoneControl;
    }

    public void setRedstoneControl(RedstoneControl redstoneControl) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.redstoneControlDataSlot, redstoneControl);
        } else {
            this.redstoneControl = redstoneControl;
        }
    }

    @Nullable
    public MachineInventoryLayout getInventoryLayout() {
        return null;
    }

    @Nullable
    public final MachineInventory getInventory() {
        return this.inventory;
    }

    protected final MachineInventory getInventoryNN() {
        return Objects.requireNonNull(this.inventory);
    }

    protected MachineInventory createMachineInventory(MachineInventoryLayout layout) {
        return new MachineInventory(this.getIOConfig(), layout){

            protected void onContentsChanged(int slot) {
                MachineBlockEntity.this.onInventoryContentsChanged(slot);
                MachineBlockEntity.this.m_6596_();
            }
        };
    }

    protected void onInventoryContentsChanged(int slot) {
    }

    @Nullable
    protected FluidTank createFluidTank() {
        return null;
    }

    @Nullable
    public final FluidTank getFluidTank() {
        return this.fluidTank;
    }

    protected final FluidTank getFluidTankNN() {
        return Objects.requireNonNull(this.fluidTank);
    }

    @Nullable
    protected MachineFluidHandler createFluidHandler(FluidTank fluidTank) {
        return new MachineFluidHandler(this.getIOConfig(), new IFluidTank[]{fluidTank});
    }

    @Override
    public void serverTick() {
        if (this.isCapabilityCacheDirty) {
            this.updateCapabilityCache();
        }
        if (this.canActSlow()) {
            this.forceResources();
        }
        super.serverTick();
    }

    @Override
    public void clientTick() {
        if (this.isRangeVisible()) {
            this.generateParticle(new RangeParticleData(this.getRange(), this.getColor()), this.getParticleLocation());
        }
        super.clientTick();
    }

    public boolean canAct() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.supportsRedstoneControl()) {
            return this.redstoneControl.isActive(this.f_58857_.m_276867_(this.f_58858_));
        }
        return true;
    }

    public boolean canActSlow() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.canAct() && this.f_58857_.m_46467_() % 5L == 0L;
    }

    private void forceResources() {
        for (Direction direction : Direction.values()) {
            if (!this.ioConfig.getMode(direction).canForce()) continue;
            this.moveItems(direction);
            this.moveFluids(direction);
        }
    }

    private void moveItems(Direction side) {
        this.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve().ifPresent(selfHandler -> {
            Optional otherHandler = this.getNeighbouringCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve();
            if (otherHandler.isPresent()) {
                IOMode mode = this.ioConfig.getMode(side);
                if (mode.canPush()) {
                    this.moveItems((IItemHandler)selfHandler, (IItemHandler)otherHandler.get());
                }
                if (mode.canPull()) {
                    this.moveItems((IItemHandler)otherHandler.get(), (IItemHandler)selfHandler);
                }
            }
        });
    }

    protected void moveItems(IItemHandler from, IItemHandler to) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack extracted = from.extractItem(i, 1, true);
            if (extracted.m_41619_()) continue;
            for (int j = 0; j < to.getSlots(); ++j) {
                ItemStack inserted = to.insertItem(j, extracted, false);
                if (!inserted.m_41619_()) continue;
                from.extractItem(i, 1, false);
                return;
            }
        }
    }

    private void moveFluids(Direction side) {
        this.getCapability(ForgeCapabilities.FLUID_HANDLER, side).resolve().ifPresent(selfHandler -> {
            Optional otherHandler = this.getNeighbouringCapability(ForgeCapabilities.FLUID_HANDLER, side).resolve();
            if (otherHandler.isPresent()) {
                IOMode mode = this.ioConfig.getMode(side);
                FluidStack stack = selfHandler.drain(100, IFluidHandler.FluidAction.SIMULATE);
                if (stack.isEmpty() && mode.canPull()) {
                    this.moveFluids((IFluidHandler)otherHandler.get(), (IFluidHandler)selfHandler, 100);
                } else if (mode.canPush()) {
                    this.moveFluids((IFluidHandler)selfHandler, (IFluidHandler)otherHandler.get(), 100);
                }
            }
        });
    }

    protected int moveFluids(IFluidHandler from, IFluidHandler to, int maxDrain) {
        FluidStack stack = from.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        if (stack.isEmpty()) {
            return 0;
        }
        int filled = to.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        stack.setAmount(filled);
        from.drain(stack, IFluidHandler.FluidAction.EXECUTE);
        return filled;
    }

    protected <T> LazyOptional<T> getNeighbouringCapability(Capability<T> capability, Direction side) {
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        if (!this.cachedCapabilityTypes.contains(capability)) {
            this.cachedCapabilityTypes.add(capability);
            this.cachedCapabilities.put(capability, new EnumMap(Direction.class));
            for (Direction direction : Direction.values()) {
                BlockEntity neighbor = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                this.populateCachesFor(direction, neighbor, capability);
            }
        }
        if (!this.cachedCapabilities.get(capability).containsKey(side)) {
            return LazyOptional.empty();
        }
        return this.cachedCapabilities.get(capability).get(side).cast();
    }

    public void markCapabilityCacheDirty() {
        this.isCapabilityCacheDirty = true;
    }

    private void updateCapabilityCache() {
        if (this.f_58857_ != null) {
            this.clearCaches();
            for (Direction direction : Direction.values()) {
                BlockEntity neighbor = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                this.populateCaches(direction, neighbor);
            }
            this.isCapabilityCacheDirty = false;
        }
    }

    private <T> LazyOptional<T> addInvalidationListener(LazyOptional<T> capability) {
        if (capability.isPresent()) {
            capability.addListener(c -> this.markCapabilityCacheDirty());
        }
        return capability;
    }

    private void clearCaches() {
        for (Capability<?> capability : this.cachedCapabilityTypes) {
            this.cachedCapabilities.get(capability).clear();
        }
    }

    private void populateCaches(Direction direction, @Nullable BlockEntity neighbor) {
        for (Capability<?> capability : this.cachedCapabilityTypes) {
            this.populateCachesFor(direction, neighbor, capability);
        }
    }

    private void populateCachesFor(Direction direction, @Nullable BlockEntity neighbor, Capability<?> capability) {
        if (neighbor != null) {
            this.cachedCapabilities.get(capability).put(direction, this.addInvalidationListener(neighbor.getCapability(capability, direction.m_122424_())));
        } else {
            this.cachedCapabilities.get(capability).put(direction, LazyOptional.empty());
        }
    }

    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("IoConfig", this.getIOConfig().serializeNBT());
        if (this.supportsRedstoneControl()) {
            pTag.m_128405_("RedstoneControl", this.redstoneControl.ordinal());
        }
        if (this.inventory != null) {
            pTag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
        }
        if (this.fluidTank != null) {
            pTag.m_128365_("Fluid", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        }
        if (this.getMaxRange() > 0) {
            pTag.m_128405_("Range", this.getRange());
            pTag.m_128379_("RangeVisible", this.isRangeVisible());
        }
    }

    public void m_142466_(CompoundTag pTag) {
        this.ioConfig.deserializeNBT((Tag)pTag.m_128469_("IoConfig"));
        if (this.supportsRedstoneControl()) {
            this.redstoneControl = RedstoneControl.values()[pTag.m_128451_("RedstoneControl")];
        }
        if (this.inventory != null) {
            this.inventory.deserializeNBT(pTag.m_128469_("Items"));
        }
        if (this.fluidTank != null) {
            this.fluidTank.readFromNBT(pTag.m_128469_("Fluid"));
        }
        if (this.f_58857_ != null) {
            this.onIOConfigChanged();
        }
        if (pTag.m_128441_("Range")) {
            this.range = pTag.m_128451_("Range");
        }
        if (pTag.m_128441_("RangeVisible")) {
            this.rangeVisible = pTag.m_128471_("RangeVisible");
        }
        this.isCapabilityCacheDirty = true;
        super.m_142466_(pTag);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public InteractionResult onBlockEntityUsed(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public boolean stillValid(Player pPlayer) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.canReach(this.f_58858_, 1.5);
    }

    @Override
    @UseOnly(value=LogicalSide.SERVER)
    public InteractionResult onWrenched(UseOnContext context) {
        Level level;
        Player player = context.m_43723_();
        if (player != null && this.f_58857_ != null && player.m_36341_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            BlockState state = this.m_58900_();
            List drops = Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)this.f_58857_.m_7702_(pos));
            this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            player.m_6674_(InteractionHand.MAIN_HAND);
            SoundType soundType = state.m_60734_().getSoundType(state, (LevelReader)this.f_58857_, pos, null);
            this.f_58857_.m_5594_(null, pos, soundType.m_56775_(), SoundSource.BLOCKS, soundType.f_56731_, soundType.f_56732_);
            PlayerInteractionUtil.putStacksInInventoryFromWorldInteraction(player, pos, drops);
            return InteractionResult.CONSUME;
        }
        LazyOptional<ISideConfig> optSideConfig = this.getCapability(EIOCapabilities.SIDE_CONFIG, context.m_43719_());
        if (optSideConfig.isPresent()) {
            optSideConfig.ifPresent(ISideConfig::cycleMode);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean canOpenMenu() {
        return true;
    }

    public int getLightEmission() {
        return this.m_58900_().m_60791_();
    }
}

