/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.advancement.PaintingTrigger;
import com.enderio.base.common.block.painted.IPaintedBlock;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.PoweredCraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.CraftingMachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.PaintingMachineMenu;
import com.enderio.machines.common.recipe.PaintingRecipe;
import com.enderio.machines.common.recipe.RecipeCaches;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PaintingMachineBlockEntity
extends PoweredMachineBlockEntity {
    public static final SingleSlotAccess INPUT = new SingleSlotAccess();
    public static final SingleSlotAccess PAINT = new SingleSlotAccess();
    public static final SingleSlotAccess OUTPUT = new SingleSlotAccess();
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.PAINTING_MACHINE_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.PAINTING_MACHINE_USAGE);
    private final AABB area;
    private final CraftingMachineTaskHost<PaintingRecipe, RecipeWrapper> craftingTaskHost;

    public PaintingMachineBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
        this.area = AABB.m_165882_((Vec3)worldPosition.m_252807_(), (double)10.0, (double)10.0, (double)10.0);
        this.craftingTaskHost = new CraftingMachineTaskHost<PaintingRecipe, RecipeWrapper>(this, this::hasEnergy, (RecipeType)MachineRecipes.PAINTING.type().get(), new RecipeWrapper((IItemHandlerModifiable)this.getInventoryNN()), this::createTask);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new PaintingMachineMenu(this, pInventory, pContainerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.craftingTaskHost.tick();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.craftingTaskHost.onLevelReady();
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().capacitor().inputSlot(this::isValidInput).slotAccess(INPUT).inputSlot(this::isValidPaint).slotAccess(PAINT).outputSlot().slotAccess(OUTPUT).build();
    }

    private boolean isValidInput(int index, ItemStack stack) {
        return RecipeCaches.PAINTING.hasRecipe(List.of(stack));
    }

    private boolean isValidPaint(int index, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof IPaintedBlock) {
                return false;
            }
            return block.m_49966_().m_60768_((BlockGetter)this.f_58857_, this.m_58899_()) == Shapes.m_83144_();
        }
        return false;
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.craftingTaskHost.newTaskAvailable();
    }

    public float getCraftingProgress() {
        return this.craftingTaskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.craftingTaskHost.hasTask();
    }

    protected PoweredCraftingMachineTask<PaintingRecipe, RecipeWrapper> createTask(Level level, RecipeWrapper container, @Nullable PaintingRecipe recipe) {
        return new PoweredCraftingMachineTask<PaintingRecipe, RecipeWrapper>(level, this.getInventoryNN(), this.getEnergyStorage(), container, OUTPUT, recipe){

            @Override
            protected void consumeInputs(PaintingRecipe recipe) {
                INPUT.getItemStack(this.getInventory()).m_41774_(1);
            }

            @Override
            protected boolean placeOutputs(List<OutputStack> outputs, boolean simulate) {
                if (PaintingMachineBlockEntity.this.m_58904_() == null || PaintingMachineBlockEntity.this.m_58904_().f_46443_) {
                    return super.placeOutputs(outputs, simulate);
                }
                Optional<String> s = outputs.stream().findFirst().map(OutputStack::getItem).flatMap(item -> Optional.ofNullable(item.m_41783_())).filter(nbt -> nbt.m_128425_("BlockEntityTag", 10)).map(nbt -> nbt.m_128469_("BlockEntityTag")).filter(nbt -> nbt.m_128425_("Paint", 8)).map(nbt -> nbt.m_128461_("Paint"));
                if (s.isPresent()) {
                    Block paint = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s.get()));
                    for (Player player : PaintingMachineBlockEntity.this.m_58904_().m_6907_()) {
                        if (!(player instanceof ServerPlayer)) continue;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (!PaintingMachineBlockEntity.this.area.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                        PaintingTrigger.PAINTING_TRIGGER.trigger(serverPlayer, paint);
                    }
                }
                return super.placeOutputs(outputs, simulate);
            }
        };
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.craftingTaskHost.save(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.craftingTaskHost.load(pTag);
    }
}

