/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.block;

import com.enderio.base.common.handler.TravelHandler;
import com.enderio.base.common.travel.TravelSavedData;
import com.enderio.machines.common.block.MachineBlock;
import com.enderio.machines.common.blockentity.TravelAnchorBlockEntity;
import com.enderio.machines.common.init.MachineBlockEntities;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class TravelAnchorBlock
extends MachineBlock {
    private static final Map<Player, PlayerSneakEntry> sneakCache = new WeakHashMap<Player, PlayerSneakEntry>();

    public TravelAnchorBlock(BlockBehaviour.Properties props) {
        super(props, MachineBlockEntities.TRAVEL_ANCHOR);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return MachineBlockEntities.TRAVEL_ANCHOR.create(pPos, pState);
    }

    @SubscribeEvent
    public static void jump(LivingEvent.LivingJumpEvent jumpEvent) {
        Player player;
        LivingEntity livingEntity;
        if (!jumpEvent.getEntity().m_9236_().f_46443_ && (livingEntity = jumpEvent.getEntity()) instanceof Player && (player = (Player)livingEntity).m_9236_().m_8055_(player.m_20183_().m_7495_()).m_60734_() instanceof TravelAnchorBlock) {
            TravelHandler.blockTeleport(player.m_9236_(), player);
        }
    }

    @SubscribeEvent
    public static void sneak(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        Player player2;
        if (event.phase == TickEvent.Phase.END && (player2 = event.player) instanceof ServerPlayer && (player = (ServerPlayer)player2).m_9236_().m_8055_(player.m_20183_().m_7495_()).m_60734_() instanceof TravelAnchorBlock) {
            PlayerSneakEntry sneakEntry = TravelAnchorBlock.getLastSneakEntry(player);
            if ((!sneakEntry.isSneaking() || sneakEntry.atTime() != player.m_9236_().m_7654_().m_129921_() - 1) && player.m_6144_()) {
                TravelHandler.blockTeleport(player.m_9236_(), (Player)player);
            }
            sneakCache.put((Player)player, new PlayerSneakEntry(player.m_6144_(), player.m_9236_().m_7654_().m_129921_()));
        }
    }

    private static PlayerSneakEntry getLastSneakEntry(ServerPlayer player) {
        return sneakCache.getOrDefault(player, new PlayerSneakEntry(false, player.m_9236_().m_7654_().m_129921_() - 1));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TravelAnchorBlockEntity) {
            TravelAnchorBlockEntity anchorBlock = (TravelAnchorBlockEntity)blockEntity;
            TravelSavedData.getTravelData(level).removeTravelTargetAt(level, pos);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    private record PlayerSneakEntry(boolean isSneaking, int atTime) {
    }
}

