/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.rendering.blockentity;

import com.enderio.EnderIO;
import com.enderio.core.client.RenderUtil;
import com.enderio.machines.common.blockentity.capacitorbank.CapacitorBankBlockEntity;
import com.enderio.machines.common.blockentity.capacitorbank.DisplayMode;
import com.enderio.machines.common.blockentity.multienergy.ICapacityTier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class CapacitorBankBER
implements BlockEntityRenderer<CapacitorBankBlockEntity> {
    private static final ResourceLocation FULL_BAR = EnderIO.loc("block/capacitor_additionals/capacitor_bank_bar_full");
    private static final ResourceLocation END_BAR = EnderIO.loc("block/capacitor_additionals/capacitor_bank_bar_end");
    private static final ResourceLocation ENERGY_BAR = EnderIO.loc("block/capacitor_additionals/capacitor_bank_bar_energy");
    private static final ResourceLocation IO_1x1 = EnderIO.loc("block/capacitor_additionals/1x1_full");
    private static final ResourceLocation IO_FULL = EnderIO.loc("block/capacitor_additionals/full");
    private static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public CapacitorBankBER(BlockEntityRendererProvider.Context context) {
    }

    public void render(CapacitorBankBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.m_58904_() != null) {
            for (Direction direction : HORIZONTAL_DIRECTIONS) {
                BlockPos facingPos = blockEntity.m_58899_().m_121945_(direction);
                if (!Block.m_152444_((BlockState)blockEntity.m_58900_(), (BlockGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_(), (Direction)direction, (BlockPos)facingPos)) continue;
                DisplayMode mode = blockEntity.getDisplayMode(direction);
                if (mode == DisplayMode.BAR) {
                    CapacitorBankBER.renderBar(blockEntity, poseStack, bufferSource, direction);
                }
                if (mode != DisplayMode.IO) continue;
                CapacitorBankBER.renderIO(blockEntity, poseStack, bufferSource, direction);
            }
        }
    }

    private static void renderBar(CapacitorBankBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, Direction facing) {
        int length;
        if (CapacitorBankBER.getDisplayModeRelative(blockEntity, facing, new Vector2i(0, -1)) == DisplayMode.BAR) {
            return;
        }
        for (length = 1; length < 16 && CapacitorBankBER.getDisplayModeRelative(blockEntity, facing, new Vector2i(0, length)) == DisplayMode.BAR; ++length) {
        }
        for (int i = 0; i < length; ++i) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, (float)(-i), 0.0f);
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
            PoseStack.Pose last = poseStack.m_85850_();
            CapacitorBankBER.renderTopHalf(last.m_252922_(), last.m_252943_(), buffer, facing, i == 0);
            CapacitorBankBER.renderBottomHalf(last.m_252922_(), last.m_252943_(), buffer, facing, i == length - 1);
            poseStack.m_85849_();
        }
        if (blockEntity.getEnergyStorage().getMaxEnergyStored() > 0) {
            boolean isBottomEnd;
            float f = (float)blockEntity.getEnergyStorage().getEnergyStored() / (float)blockEntity.getEnergyStorage().getMaxEnergyStored();
            int filledPixels = Math.round(f * (float)(10 + (length - 1) * 16));
            for (int i = length - 1; i >= 0 && filledPixels > 0; filledPixels -= isBottomEnd ? 13 : 16, --i) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, (float)(-i), 0.0f);
                VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
                PoseStack.Pose last = poseStack.m_85850_();
                isBottomEnd = i == length - 1;
                CapacitorBankBER.renderEnergy(last.m_252922_(), last.m_252943_(), buffer, facing, filledPixels, isBottomEnd);
                poseStack.m_85849_();
            }
        }
    }

    private static void renderIO(CapacitorBankBlockEntity capacitorBank, PoseStack poseStack, MultiBufferSource bufferSource, Direction facing) {
        int light = 0xF000F0;
        if (capacitorBank.m_58904_() != null) {
            light = LevelRenderer.m_109541_((BlockAndTintGetter)capacitorBank.m_58904_(), (BlockPos)capacitorBank.m_58899_().m_121945_(facing));
        }
        Size size = CapacitorBankBER.findSize(capacitorBank, facing);
        CapacitorBankBER.renderTexture(poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252943_(), bufferSource.m_6299_(RenderType.m_110463_()), facing, size.getTexture(), light);
        if (!(-size.x0 != size.x1 && -size.x0 + 1 != size.x1 || -size.y0 != size.y1 && -size.y0 + 1 != size.y1)) {
            int height = size.y1 - size.y0 + 1;
            int width = size.x1 - size.x0 + 1;
            boolean isLongInformation = (float)height > 1.4f * (float)width;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(facing.m_122416_() * 90)));
            poseStack.m_252880_(width % 2 == 0 ? 0.5f : 0.0f, height % 2 == 0 ? -0.5f : 0.0f, 0.502f);
            poseStack.m_85841_(0.0625f, -0.0625f, 0.0625f);
            Font font = Minecraft.m_91087_().f_91062_;
            float fontWidthScale = (float)width / (float)font.m_92895_("OutputOutput");
            float f = height;
            Objects.requireNonNull(font);
            float fontHeightScale = f / (float)(9 * 5);
            float scale = Math.min(fontWidthScale, fontHeightScale) * 16.0f;
            poseStack.m_85841_(scale, scale, scale);
            if (!isLongInformation) {
                poseStack.m_85836_();
                float f2 = (float)(-font.m_92895_("I/0")) / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f2, (float)(-9) * 1.5f, 0.0f);
                font.m_272078_("I/0", 0.0f, 0.0f, -16777216, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light, false);
                poseStack.m_85849_();
                poseStack.m_85836_();
                long energySurplus = capacitorBank.getAddedEnergy() - capacitorBank.getRemovedEnergy();
                int color = 0;
                if (energySurplus > 0L) {
                    color = -16711936;
                }
                if (energySurplus < 0L) {
                    color = -65536;
                }
                float f3 = (float)(-font.m_92895_(String.valueOf(energySurplus))) / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f3, 9.0f * 0.5f, 0.0f);
                font.m_272078_(String.valueOf(energySurplus), 0.0f, 0.0f, color, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light, false);
                poseStack.m_85849_();
            } else {
                poseStack.m_85836_();
                float f4 = (float)(-font.m_92895_("Input")) / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f4, (float)(-9) * 3.5f, 0.0f);
                font.m_272078_("Input", 0.0f, 0.0f, -16777216, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light, false);
                poseStack.m_85849_();
                poseStack.m_85836_();
                float f5 = (float)(-font.m_92895_(String.valueOf(capacitorBank.getAddedEnergy()))) / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f5, (float)(-9) * 1.5f, 0.0f);
                font.m_272078_(String.valueOf(capacitorBank.getAddedEnergy()), 0.0f, 0.0f, -16711936, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light, false);
                poseStack.m_85849_();
                poseStack.m_85836_();
                float f6 = (float)(-font.m_92895_("Output")) / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f6, 9.0f * 0.5f, 0.0f);
                font.m_272078_("Output", 0.0f, 0.0f, -16777216, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light, false);
                poseStack.m_85849_();
                poseStack.m_85836_();
                float f7 = (float)(-font.m_92895_(String.valueOf(capacitorBank.getRemovedEnergy()))) / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f7, 9.0f * 2.5f, 0.0f);
                font.m_272078_(String.valueOf(capacitorBank.getRemovedEnergy()), 0.0f, 0.0f, -65536, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light, false);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    private static DisplayMode getDisplayModeRelative(CapacitorBankBlockEntity blockEntity, Direction horizontalFacing, Vector2i relative) {
        if (blockEntity.m_58904_() == null) {
            return DisplayMode.NONE;
        }
        return CapacitorBankBER.getDisplayModeRelative(blockEntity.m_58904_(), horizontalFacing, blockEntity.m_58899_(), relative, blockEntity.tier);
    }

    private static DisplayMode getDisplayModeRelative(Level level, Direction horizontalFacing, BlockPos pos, Vector2i relative, ICapacityTier tier) {
        pos = pos.m_6625_(relative.y());
        BlockEntity blockEntity = level.m_7702_(pos = pos.m_5484_(horizontalFacing.m_122427_(), -relative.x));
        if (blockEntity instanceof CapacitorBankBlockEntity) {
            CapacitorBankBlockEntity capacitorBank = (CapacitorBankBlockEntity)blockEntity;
            if (capacitorBank.tier == tier) {
                return capacitorBank.getDisplayMode(horizontalFacing);
            }
        }
        return DisplayMode.NONE;
    }

    public static void renderBottomHalf(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, Direction facing, boolean isEnd) {
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(isEnd ? END_BAR : FULL_BAR);
        float inset = -0.001f;
        RenderUtil.renderFace(facing, pose, normal, consumer, texture, 0.0f, 0.0f, inset, 1.0f, 0.5f, -1);
    }

    public static void renderTopHalf(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, Direction facing, boolean isEnd) {
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(isEnd ? END_BAR : FULL_BAR);
        float inset = -0.001f;
        RenderUtil.renderFace(facing, pose, normal, consumer, texture, 0.0f, 0.5f, inset, 1.0f, 0.5f, -1);
    }

    public static void renderEnergy(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, Direction facing, int pixels, boolean isBottomEnd) {
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ENERGY_BAR);
        float inset = -0.002f;
        RenderUtil.renderFace(facing, pose, normal, consumer, texture, 0.0f, isBottomEnd ? 0.1875f : 0.0f, inset, 1.0f, (float)Math.min(pixels, isBottomEnd ? 13 : 16) / 16.0f, -1);
    }

    public static void renderTexture(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, Direction facing, ResourceLocation rl, int light) {
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(rl);
        float inset = -0.001f;
        RenderUtil.renderFace(facing, pose, normal, consumer, texture, 0.0f, 0.0f, inset, 1.0f, 1.0f, -1, light);
    }

    public int m_142163_() {
        return 92;
    }

    private static Size findSize(CapacitorBankBlockEntity capacitorBank, Direction facing) {
        int x;
        int checked;
        int x0 = 0;
        int y0 = 0;
        int x1 = 0;
        int y1 = 0;
        int i = 1;
        while (i < 16 && CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(i, 0)) == DisplayMode.IO) {
            x1 = i++;
        }
        for (i = 1; i < 16 - x1 && CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(-i, 0)) == DisplayMode.IO; ++i) {
            x0 = -i;
        }
        i = 1;
        block2: while (i < 16) {
            checked = 0;
            for (x = x0; x <= x1; ++x) {
                if (CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(x, i)) == DisplayMode.IO) {
                    ++checked;
                    continue;
                }
                if (checked <= 0) break block2;
                return new Size(0, 0, 0, 0);
            }
            y1 = i++;
        }
        block4: for (i = 1; i < 16 - y1; ++i) {
            checked = 0;
            for (x = x0; x <= x1; ++x) {
                if (CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(x, -i)) == DisplayMode.IO) {
                    ++checked;
                    continue;
                }
                if (checked <= 0) break block4;
                return new Size(0, 0, 0, 0);
            }
            y0 = -i;
        }
        return CapacitorBankBER.validateSize(new Size(x0, y0, x1, y1), capacitorBank, facing);
    }

    private static Size validateSize(Size size, CapacitorBankBlockEntity capacitorBank, Direction facing) {
        for (int x = size.x0; x <= size.x1; ++x) {
            if (CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(x, size.y0 - 1)) == DisplayMode.IO) {
                return new Size(0, 0, 0, 0);
            }
            if (CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(x, size.y1 + 1)) != DisplayMode.IO) continue;
            return new Size(0, 0, 0, 0);
        }
        for (int y = size.y0; y <= size.y1; ++y) {
            if (CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(size.x0 - 1, y)) == DisplayMode.IO) {
                return new Size(0, 0, 0, 0);
            }
            if (CapacitorBankBER.getDisplayModeRelative(capacitorBank, facing, new Vector2i(size.x1 + 1, y)) != DisplayMode.IO) continue;
            return new Size(0, 0, 0, 0);
        }
        return size;
    }

    private record Size(int x0, int y0, int x1, int y1) {
        ResourceLocation getTexture() {
            boolean isSmallY;
            boolean isLeft = this.x0 == 0;
            boolean isRight = this.x1 == 0;
            boolean isSmallX = isLeft && isRight;
            boolean isUp = this.y0 == 0;
            boolean isDown = this.y1 == 0;
            boolean bl = isSmallY = isUp && isDown;
            if (isSmallX && isSmallY) {
                return IO_1x1;
            }
            if (isSmallY) {
                if (isLeft) {
                    return EnderIO.loc("block/capacitor_additionals/small_r");
                }
                if (isRight) {
                    return EnderIO.loc("block/capacitor_additionals/small_l");
                }
                return EnderIO.loc("block/capacitor_additionals/small_lr");
            }
            if (isSmallX) {
                if (isUp) {
                    return EnderIO.loc("block/capacitor_additionals/small_u");
                }
                if (isDown) {
                    return EnderIO.loc("block/capacitor_additionals/small_d");
                }
                return EnderIO.loc("block/capacitor_additionals/small_ud");
            }
            if (isUp) {
                if (isLeft) {
                    return EnderIO.loc("block/capacitor_additionals/corner_tr");
                }
                if (isRight) {
                    return EnderIO.loc("block/capacitor_additionals/corner_tl");
                }
                return EnderIO.loc("block/capacitor_additionals/side_t");
            }
            if (isDown) {
                if (isLeft) {
                    return EnderIO.loc("block/capacitor_additionals/corner_br");
                }
                if (isRight) {
                    return EnderIO.loc("block/capacitor_additionals/corner_bl");
                }
                return EnderIO.loc("block/capacitor_additionals/side_b");
            }
            if (isLeft) {
                return EnderIO.loc("block/capacitor_additionals/side_r");
            }
            if (isRight) {
                return EnderIO.loc("block/capacitor_additionals/side_l");
            }
            return IO_FULL;
        }
    }
}

