/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget;

import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.core.common.util.TooltipUtil;
import com.enderio.machines.common.lang.MachineLang;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;

public abstract class ProgressWidget
extends AbstractWidget {
    protected final Supplier<Float> progressSupplier;
    private final EIOScreen screen;
    protected final int u;
    protected final int v;
    private final boolean tooltip;

    protected ProgressWidget(EIOScreen screen, Supplier<Float> progressSupplier, int x, int y, int width, int height, int u, int v, boolean tooltip) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.screen = screen;
        this.progressSupplier = progressSupplier;
        this.u = u;
        this.v = v;
        this.tooltip = tooltip;
    }

    protected ProgressWidget(EIOScreen screen, Supplier<Float> progressSupplier, int x, int y, int width, int height, int u, int v) {
        this(screen, progressSupplier, x, y, width, height, u, v, true);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.m_198029_() && this.tooltip) {
            this.m_257544_(Tooltip.m_257550_((Component)TooltipUtil.withArgs(MachineLang.PROGRESS_TOOLTIP, (int)(this.progressSupplier.get().floatValue() * 100.0f))));
        }
    }

    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }

    protected void render(GuiGraphics guiGraphics, int x, int y, int u, int v, int w, int h) {
        guiGraphics.m_280218_(this.screen.getBackgroundImage(), x, y, u, v, w, h);
    }

    public static class LeftRight
    extends ProgressWidget {
        public LeftRight(EIOScreen screen, Supplier<Float> getter, int x, int y, int width, int height, int u, int v, boolean tooltip) {
            super(screen, getter, x, y, width, height, u, v, tooltip);
        }

        public LeftRight(EIOScreen screen, Supplier<Float> getter, int x, int y, int width, int height, int u, int v) {
            super(screen, getter, x, y, width, height, u, v);
        }

        @Override
        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            float progress = ((Float)this.progressSupplier.get()).floatValue();
            this.render(guiGraphics, this.m_252754_(), this.m_252907_(), this.u, this.v, (int)((float)this.f_93618_ * progress), this.f_93619_);
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public static class TopDown
    extends ProgressWidget {
        public TopDown(EIOScreen screen, Supplier<Float> getter, int x, int y, int width, int height, int u, int v, boolean tooltip) {
            super(screen, getter, x, y, width, height, u, v, tooltip);
        }

        public TopDown(EIOScreen screen, Supplier<Float> getter, int x, int y, int width, int height, int u, int v) {
            super(screen, getter, x, y, width, height, u, v);
        }

        @Override
        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            float progress = ((Float)this.progressSupplier.get()).floatValue();
            this.render(guiGraphics, this.m_252754_(), this.m_252907_(), this.u, this.v, this.f_93618_, (int)((float)this.f_93619_ * progress));
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public static class BottomUp
    extends ProgressWidget {
        public BottomUp(EIOScreen screen, Supplier<Float> getter, int x, int y, int width, int height, int u, int v) {
            super(screen, getter, x, y, width, height, u, v);
        }

        public BottomUp(EIOScreen screen, Supplier<Float> getter, int x, int y, int width, int height, int u, int v, boolean tooltip) {
            super(screen, getter, x, y, width, height, u, v, tooltip);
        }

        @Override
        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            float progress = ((Float)this.progressSupplier.get()).floatValue();
            int yOffset = (int)((float)this.f_93619_ * (1.0f - progress));
            this.render(guiGraphics, this.m_252754_(), this.m_252907_() + yOffset, this.u, this.v + yOffset, this.f_93618_, (int)((float)this.f_93619_ * progress));
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

